// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudhsmv2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.cloudhsmv2.HsmArgs;
import com.pulumi.aws.cloudhsmv2.inputs.HsmState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Creates an HSM module in Amazon CloudHSM v2 cluster.
 * 
 * ## Example Usage
 * 
 * The following example below creates an HSM module in CloudHSM cluster.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudhsmv2.Cloudhsmv2Functions;
 * import com.pulumi.aws.cloudhsmv2.inputs.GetClusterArgs;
 * import com.pulumi.aws.cloudhsmv2.Hsm;
 * import com.pulumi.aws.cloudhsmv2.HsmArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var cluster = Cloudhsmv2Functions.getCluster(GetClusterArgs.builder()
 *             .clusterId(var_.cloudhsm_cluster_id())
 *             .build());
 * 
 *         var cloudhsmV2Hsm = new Hsm(&#34;cloudhsmV2Hsm&#34;, HsmArgs.builder()        
 *             .subnetId(cluster.applyValue(getClusterResult -&gt; getClusterResult.subnetIds()[0]))
 *             .clusterId(cluster.applyValue(getClusterResult -&gt; getClusterResult.clusterId()))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import HSM modules using their HSM ID. For example:
 * 
 * ```sh
 *  $ pulumi import aws:cloudhsmv2/hsm:Hsm bar hsm-quo8dahtaca
 * ```
 * 
 */
@ResourceType(type="aws:cloudhsmv2/hsm:Hsm")
public class Hsm extends com.pulumi.resources.CustomResource {
    /**
     * The IDs of AZ in which HSM module will be located. Conflicts with `subnet_id`.
     * 
     */
    @Export(name="availabilityZone", refs={String.class}, tree="[0]")
    private Output<String> availabilityZone;

    /**
     * @return The IDs of AZ in which HSM module will be located. Conflicts with `subnet_id`.
     * 
     */
    public Output<String> availabilityZone() {
        return this.availabilityZone;
    }
    /**
     * The ID of Cloud HSM v2 cluster to which HSM will be added.
     * 
     */
    @Export(name="clusterId", refs={String.class}, tree="[0]")
    private Output<String> clusterId;

    /**
     * @return The ID of Cloud HSM v2 cluster to which HSM will be added.
     * 
     */
    public Output<String> clusterId() {
        return this.clusterId;
    }
    /**
     * The id of the ENI interface allocated for HSM module.
     * 
     */
    @Export(name="hsmEniId", refs={String.class}, tree="[0]")
    private Output<String> hsmEniId;

    /**
     * @return The id of the ENI interface allocated for HSM module.
     * 
     */
    public Output<String> hsmEniId() {
        return this.hsmEniId;
    }
    /**
     * The id of the HSM module.
     * 
     */
    @Export(name="hsmId", refs={String.class}, tree="[0]")
    private Output<String> hsmId;

    /**
     * @return The id of the HSM module.
     * 
     */
    public Output<String> hsmId() {
        return this.hsmId;
    }
    /**
     * The state of the HSM module.
     * 
     */
    @Export(name="hsmState", refs={String.class}, tree="[0]")
    private Output<String> hsmState;

    /**
     * @return The state of the HSM module.
     * 
     */
    public Output<String> hsmState() {
        return this.hsmState;
    }
    /**
     * The IP address of HSM module. Must be within the CIDR of selected subnet.
     * 
     */
    @Export(name="ipAddress", refs={String.class}, tree="[0]")
    private Output<String> ipAddress;

    /**
     * @return The IP address of HSM module. Must be within the CIDR of selected subnet.
     * 
     */
    public Output<String> ipAddress() {
        return this.ipAddress;
    }
    /**
     * The ID of subnet in which HSM module will be located. Conflicts with `availability_zone`.
     * 
     */
    @Export(name="subnetId", refs={String.class}, tree="[0]")
    private Output<String> subnetId;

    /**
     * @return The ID of subnet in which HSM module will be located. Conflicts with `availability_zone`.
     * 
     */
    public Output<String> subnetId() {
        return this.subnetId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Hsm(String name) {
        this(name, HsmArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Hsm(String name, HsmArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Hsm(String name, HsmArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudhsmv2/hsm:Hsm", name, args == null ? HsmArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Hsm(String name, Output<String> id, @Nullable HsmState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudhsmv2/hsm:Hsm", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Hsm get(String name, Output<String> id, @Nullable HsmState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Hsm(name, id, state, options);
    }
}
