// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudhsmv2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.cloudhsmv2.ClusterArgs;
import com.pulumi.aws.cloudhsmv2.inputs.ClusterState;
import com.pulumi.aws.cloudhsmv2.outputs.ClusterClusterCertificate;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Creates an Amazon CloudHSM v2 cluster.
 * 
 * For information about CloudHSM v2, see the
 * [AWS CloudHSM User Guide](https://docs.aws.amazon.com/cloudhsm/latest/userguide/introduction.html) and the [Amazon
 * CloudHSM API Reference][2].
 * 
 * &gt; **NOTE:** A CloudHSM Cluster can take several minutes to set up.
 * Practically no single attribute can be updated, except for `tags`.
 * If you need to delete a cluster, you have to remove its HSM modules first.
 * To initialize cluster, you have to add an HSM instance to the cluster, then sign CSR and upload it.
 * 
 * ## Import
 * 
 * Using `pulumi import`, import CloudHSM v2 Clusters using the cluster `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:cloudhsmv2/cluster:Cluster test_cluster cluster-aeb282a201
 * ```
 * 
 */
@ResourceType(type="aws:cloudhsmv2/cluster:Cluster")
public class Cluster extends com.pulumi.resources.CustomResource {
    /**
     * The list of cluster certificates.
     * * `cluster_certificates.0.cluster_certificate` - The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster&#39;s owner.
     * * `cluster_certificates.0.cluster_csr` - The certificate signing request (CSR). Available only in `UNINITIALIZED` state after an HSM instance is added to the cluster.
     * * `cluster_certificates.0.aws_hardware_certificate` - The HSM hardware certificate issued (signed) by AWS CloudHSM.
     * * `cluster_certificates.0.hsm_certificate` - The HSM certificate issued (signed) by the HSM hardware.
     * * `cluster_certificates.0.manufacturer_hardware_certificate` - The HSM hardware certificate issued (signed) by the hardware manufacturer.
     * 
     */
    @Export(name="clusterCertificates", refs={List.class,ClusterClusterCertificate.class}, tree="[0,1]")
    private Output<List<ClusterClusterCertificate>> clusterCertificates;

    /**
     * @return The list of cluster certificates.
     * * `cluster_certificates.0.cluster_certificate` - The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster&#39;s owner.
     * * `cluster_certificates.0.cluster_csr` - The certificate signing request (CSR). Available only in `UNINITIALIZED` state after an HSM instance is added to the cluster.
     * * `cluster_certificates.0.aws_hardware_certificate` - The HSM hardware certificate issued (signed) by AWS CloudHSM.
     * * `cluster_certificates.0.hsm_certificate` - The HSM certificate issued (signed) by the HSM hardware.
     * * `cluster_certificates.0.manufacturer_hardware_certificate` - The HSM hardware certificate issued (signed) by the hardware manufacturer.
     * 
     */
    public Output<List<ClusterClusterCertificate>> clusterCertificates() {
        return this.clusterCertificates;
    }
    /**
     * The id of the CloudHSM cluster.
     * 
     */
    @Export(name="clusterId", refs={String.class}, tree="[0]")
    private Output<String> clusterId;

    /**
     * @return The id of the CloudHSM cluster.
     * 
     */
    public Output<String> clusterId() {
        return this.clusterId;
    }
    /**
     * The state of the CloudHSM cluster.
     * 
     */
    @Export(name="clusterState", refs={String.class}, tree="[0]")
    private Output<String> clusterState;

    /**
     * @return The state of the CloudHSM cluster.
     * 
     */
    public Output<String> clusterState() {
        return this.clusterState;
    }
    /**
     * The type of HSM module in the cluster. Currently, only `hsm1.medium` is supported.
     * 
     */
    @Export(name="hsmType", refs={String.class}, tree="[0]")
    private Output<String> hsmType;

    /**
     * @return The type of HSM module in the cluster. Currently, only `hsm1.medium` is supported.
     * 
     */
    public Output<String> hsmType() {
        return this.hsmType;
    }
    /**
     * The ID of the security group associated with the CloudHSM cluster.
     * 
     */
    @Export(name="securityGroupId", refs={String.class}, tree="[0]")
    private Output<String> securityGroupId;

    /**
     * @return The ID of the security group associated with the CloudHSM cluster.
     * 
     */
    public Output<String> securityGroupId() {
        return this.securityGroupId;
    }
    /**
     * ID of Cloud HSM v2 cluster backup to be restored.
     * 
     */
    @Export(name="sourceBackupIdentifier", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> sourceBackupIdentifier;

    /**
     * @return ID of Cloud HSM v2 cluster backup to be restored.
     * 
     */
    public Output<Optional<String>> sourceBackupIdentifier() {
        return Codegen.optional(this.sourceBackupIdentifier);
    }
    /**
     * The IDs of subnets in which cluster will operate.
     * 
     */
    @Export(name="subnetIds", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> subnetIds;

    /**
     * @return The IDs of subnets in which cluster will operate.
     * 
     */
    public Output<List<String>> subnetIds() {
        return this.subnetIds;
    }
    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The id of the VPC that the CloudHSM cluster resides in.
     * 
     */
    @Export(name="vpcId", refs={String.class}, tree="[0]")
    private Output<String> vpcId;

    /**
     * @return The id of the VPC that the CloudHSM cluster resides in.
     * 
     */
    public Output<String> vpcId() {
        return this.vpcId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Cluster(String name) {
        this(name, ClusterArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Cluster(String name, ClusterArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Cluster(String name, ClusterArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudhsmv2/cluster:Cluster", name, args == null ? ClusterArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Cluster(String name, Output<String> id, @Nullable ClusterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudhsmv2/cluster:Cluster", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Cluster get(String name, Output<String> id, @Nullable ClusterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Cluster(name, id, state, options);
    }
}
