// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudfront.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DistributionOriginCustomOriginConfig {
    /**
     * @return HTTP port the custom origin listens on.
     * 
     */
    private Integer httpPort;
    /**
     * @return HTTPS port the custom origin listens on.
     * 
     */
    private Integer httpsPort;
    /**
     * @return The Custom KeepAlive timeout, in seconds. By default, AWS enforces an upper limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout). Defaults to `5`.
     * 
     */
    private @Nullable Integer originKeepaliveTimeout;
    /**
     * @return Origin protocol policy to apply to your origin. One of `http-only`, `https-only`, or `match-viewer`.
     * 
     */
    private String originProtocolPolicy;
    /**
     * @return The Custom Read timeout, in seconds. By default, AWS enforces an upper limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout). Defaults to `30`.
     * 
     */
    private @Nullable Integer originReadTimeout;
    /**
     * @return SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS. A list of one or more of `SSLv3`, `TLSv1`, `TLSv1.1`, and `TLSv1.2`.
     * 
     */
    private List<String> originSslProtocols;

    private DistributionOriginCustomOriginConfig() {}
    /**
     * @return HTTP port the custom origin listens on.
     * 
     */
    public Integer httpPort() {
        return this.httpPort;
    }
    /**
     * @return HTTPS port the custom origin listens on.
     * 
     */
    public Integer httpsPort() {
        return this.httpsPort;
    }
    /**
     * @return The Custom KeepAlive timeout, in seconds. By default, AWS enforces an upper limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout). Defaults to `5`.
     * 
     */
    public Optional<Integer> originKeepaliveTimeout() {
        return Optional.ofNullable(this.originKeepaliveTimeout);
    }
    /**
     * @return Origin protocol policy to apply to your origin. One of `http-only`, `https-only`, or `match-viewer`.
     * 
     */
    public String originProtocolPolicy() {
        return this.originProtocolPolicy;
    }
    /**
     * @return The Custom Read timeout, in seconds. By default, AWS enforces an upper limit of `60`. But you can request an [increase](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-request-timeout). Defaults to `30`.
     * 
     */
    public Optional<Integer> originReadTimeout() {
        return Optional.ofNullable(this.originReadTimeout);
    }
    /**
     * @return SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS. A list of one or more of `SSLv3`, `TLSv1`, `TLSv1.1`, and `TLSv1.2`.
     * 
     */
    public List<String> originSslProtocols() {
        return this.originSslProtocols;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DistributionOriginCustomOriginConfig defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private Integer httpPort;
        private Integer httpsPort;
        private @Nullable Integer originKeepaliveTimeout;
        private String originProtocolPolicy;
        private @Nullable Integer originReadTimeout;
        private List<String> originSslProtocols;
        public Builder() {}
        public Builder(DistributionOriginCustomOriginConfig defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.httpPort = defaults.httpPort;
    	      this.httpsPort = defaults.httpsPort;
    	      this.originKeepaliveTimeout = defaults.originKeepaliveTimeout;
    	      this.originProtocolPolicy = defaults.originProtocolPolicy;
    	      this.originReadTimeout = defaults.originReadTimeout;
    	      this.originSslProtocols = defaults.originSslProtocols;
        }

        @CustomType.Setter
        public Builder httpPort(Integer httpPort) {
            this.httpPort = Objects.requireNonNull(httpPort);
            return this;
        }
        @CustomType.Setter
        public Builder httpsPort(Integer httpsPort) {
            this.httpsPort = Objects.requireNonNull(httpsPort);
            return this;
        }
        @CustomType.Setter
        public Builder originKeepaliveTimeout(@Nullable Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
            return this;
        }
        @CustomType.Setter
        public Builder originProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = Objects.requireNonNull(originProtocolPolicy);
            return this;
        }
        @CustomType.Setter
        public Builder originReadTimeout(@Nullable Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
            return this;
        }
        @CustomType.Setter
        public Builder originSslProtocols(List<String> originSslProtocols) {
            this.originSslProtocols = Objects.requireNonNull(originSslProtocols);
            return this;
        }
        public Builder originSslProtocols(String... originSslProtocols) {
            return originSslProtocols(List.of(originSslProtocols));
        }
        public DistributionOriginCustomOriginConfig build() {
            final var o = new DistributionOriginCustomOriginConfig();
            o.httpPort = httpPort;
            o.httpsPort = httpsPort;
            o.originKeepaliveTimeout = originKeepaliveTimeout;
            o.originProtocolPolicy = originProtocolPolicy;
            o.originReadTimeout = originReadTimeout;
            o.originSslProtocols = originSslProtocols;
            return o;
        }
    }
}
