// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudfront.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class DistributionLoggingConfigArgs extends com.pulumi.resources.ResourceArgs {

    public static final DistributionLoggingConfigArgs Empty = new DistributionLoggingConfigArgs();

    /**
     * Amazon S3 bucket to store the access logs in, for example, `myawslogbucket.s3.amazonaws.com`.
     * 
     */
    @Import(name="bucket", required=true)
    private Output<String> bucket;

    /**
     * @return Amazon S3 bucket to store the access logs in, for example, `myawslogbucket.s3.amazonaws.com`.
     * 
     */
    public Output<String> bucket() {
        return this.bucket;
    }

    /**
     * Whether to include cookies in access logs (default: `false`).
     * 
     */
    @Import(name="includeCookies")
    private @Nullable Output<Boolean> includeCookies;

    /**
     * @return Whether to include cookies in access logs (default: `false`).
     * 
     */
    public Optional<Output<Boolean>> includeCookies() {
        return Optional.ofNullable(this.includeCookies);
    }

    /**
     * Prefix to the access log filenames for this distribution, for example, `myprefix/`.
     * 
     */
    @Import(name="prefix")
    private @Nullable Output<String> prefix;

    /**
     * @return Prefix to the access log filenames for this distribution, for example, `myprefix/`.
     * 
     */
    public Optional<Output<String>> prefix() {
        return Optional.ofNullable(this.prefix);
    }

    private DistributionLoggingConfigArgs() {}

    private DistributionLoggingConfigArgs(DistributionLoggingConfigArgs $) {
        this.bucket = $.bucket;
        this.includeCookies = $.includeCookies;
        this.prefix = $.prefix;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DistributionLoggingConfigArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DistributionLoggingConfigArgs $;

        public Builder() {
            $ = new DistributionLoggingConfigArgs();
        }

        public Builder(DistributionLoggingConfigArgs defaults) {
            $ = new DistributionLoggingConfigArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param bucket Amazon S3 bucket to store the access logs in, for example, `myawslogbucket.s3.amazonaws.com`.
         * 
         * @return builder
         * 
         */
        public Builder bucket(Output<String> bucket) {
            $.bucket = bucket;
            return this;
        }

        /**
         * @param bucket Amazon S3 bucket to store the access logs in, for example, `myawslogbucket.s3.amazonaws.com`.
         * 
         * @return builder
         * 
         */
        public Builder bucket(String bucket) {
            return bucket(Output.of(bucket));
        }

        /**
         * @param includeCookies Whether to include cookies in access logs (default: `false`).
         * 
         * @return builder
         * 
         */
        public Builder includeCookies(@Nullable Output<Boolean> includeCookies) {
            $.includeCookies = includeCookies;
            return this;
        }

        /**
         * @param includeCookies Whether to include cookies in access logs (default: `false`).
         * 
         * @return builder
         * 
         */
        public Builder includeCookies(Boolean includeCookies) {
            return includeCookies(Output.of(includeCookies));
        }

        /**
         * @param prefix Prefix to the access log filenames for this distribution, for example, `myprefix/`.
         * 
         * @return builder
         * 
         */
        public Builder prefix(@Nullable Output<String> prefix) {
            $.prefix = prefix;
            return this;
        }

        /**
         * @param prefix Prefix to the access log filenames for this distribution, for example, `myprefix/`.
         * 
         * @return builder
         * 
         */
        public Builder prefix(String prefix) {
            return prefix(Output.of(prefix));
        }

        public DistributionLoggingConfigArgs build() {
            $.bucket = Objects.requireNonNull($.bucket, "expected parameter 'bucket' to be non-null");
            return $;
        }
    }

}
