// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudfront;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs;
import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyState;
import com.pulumi.aws.cloudfront.outputs.ResponseHeadersPolicyCorsConfig;
import com.pulumi.aws.cloudfront.outputs.ResponseHeadersPolicyCustomHeadersConfig;
import com.pulumi.aws.cloudfront.outputs.ResponseHeadersPolicyRemoveHeadersConfig;
import com.pulumi.aws.cloudfront.outputs.ResponseHeadersPolicySecurityHeadersConfig;
import com.pulumi.aws.cloudfront.outputs.ResponseHeadersPolicyServerTimingHeadersConfig;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a CloudFront response headers policy resource.
 * A response headers policy contains information about a set of HTTP response headers and their values.
 * After you create a response headers policy, you can use its ID to attach it to one or more cache behaviors in a CloudFront distribution.
 * When it’s attached to a cache behavior, CloudFront adds the headers in the policy to every response that it sends for requests that match the cache behavior.
 * 
 * ## Example Usage
 * 
 * The example below creates a CloudFront response headers policy.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicy;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new ResponseHeadersPolicy(&#34;example&#34;, ResponseHeadersPolicyArgs.builder()        
 *             .comment(&#34;test comment&#34;)
 *             .corsConfig(ResponseHeadersPolicyCorsConfigArgs.builder()
 *                 .accessControlAllowCredentials(true)
 *                 .accessControlAllowHeaders(ResponseHeadersPolicyCorsConfigAccessControlAllowHeadersArgs.builder()
 *                     .items(&#34;test&#34;)
 *                     .build())
 *                 .accessControlAllowMethods(ResponseHeadersPolicyCorsConfigAccessControlAllowMethodsArgs.builder()
 *                     .items(&#34;GET&#34;)
 *                     .build())
 *                 .accessControlAllowOrigins(ResponseHeadersPolicyCorsConfigAccessControlAllowOriginsArgs.builder()
 *                     .items(&#34;test.example.comtest&#34;)
 *                     .build())
 *                 .originOverride(true)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * The example below creates a CloudFront response headers policy with a custom headers config.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicy;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCustomHeadersConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new ResponseHeadersPolicy(&#34;example&#34;, ResponseHeadersPolicyArgs.builder()        
 *             .customHeadersConfig(ResponseHeadersPolicyCustomHeadersConfigArgs.builder()
 *                 .items(                
 *                     ResponseHeadersPolicyCustomHeadersConfigItemArgs.builder()
 *                         .header(&#34;X-Permitted-Cross-Domain-Policies&#34;)
 *                         .override(true)
 *                         .value(&#34;none&#34;)
 *                         .build(),
 *                     ResponseHeadersPolicyCustomHeadersConfigItemArgs.builder()
 *                         .header(&#34;X-Test&#34;)
 *                         .override(true)
 *                         .value(&#34;none&#34;)
 *                         .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * The example below creates a CloudFront response headers policy with a custom headers config and server timing headers config.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicy;
 * import com.pulumi.aws.cloudfront.ResponseHeadersPolicyArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyCustomHeadersConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.ResponseHeadersPolicyServerTimingHeadersConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new ResponseHeadersPolicy(&#34;example&#34;, ResponseHeadersPolicyArgs.builder()        
 *             .customHeadersConfig(ResponseHeadersPolicyCustomHeadersConfigArgs.builder()
 *                 .items(ResponseHeadersPolicyCustomHeadersConfigItemArgs.builder()
 *                     .header(&#34;X-Permitted-Cross-Domain-Policies&#34;)
 *                     .override(true)
 *                     .value(&#34;none&#34;)
 *                     .build())
 *                 .build())
 *             .serverTimingHeadersConfig(ResponseHeadersPolicyServerTimingHeadersConfigArgs.builder()
 *                 .enabled(true)
 *                 .samplingRate(50)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Cloudfront Response Headers Policies using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:cloudfront/responseHeadersPolicy:ResponseHeadersPolicy policy 658327ea-f89d-4fab-a63d-7e88639e58f9
 * ```
 * 
 */
@ResourceType(type="aws:cloudfront/responseHeadersPolicy:ResponseHeadersPolicy")
public class ResponseHeadersPolicy extends com.pulumi.resources.CustomResource {
    /**
     * A comment to describe the response headers policy. The comment cannot be longer than 128 characters.
     * 
     */
    @Export(name="comment", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> comment;

    /**
     * @return A comment to describe the response headers policy. The comment cannot be longer than 128 characters.
     * 
     */
    public Output<Optional<String>> comment() {
        return Codegen.optional(this.comment);
    }
    /**
     * A configuration for a set of HTTP response headers that are used for Cross-Origin Resource Sharing (CORS). See Cors Config for more information.
     * 
     */
    @Export(name="corsConfig", refs={ResponseHeadersPolicyCorsConfig.class}, tree="[0]")
    private Output</* @Nullable */ ResponseHeadersPolicyCorsConfig> corsConfig;

    /**
     * @return A configuration for a set of HTTP response headers that are used for Cross-Origin Resource Sharing (CORS). See Cors Config for more information.
     * 
     */
    public Output<Optional<ResponseHeadersPolicyCorsConfig>> corsConfig() {
        return Codegen.optional(this.corsConfig);
    }
    /**
     * Object that contains an attribute `items` that contains a list of custom headers. See Custom Header for more information.
     * 
     */
    @Export(name="customHeadersConfig", refs={ResponseHeadersPolicyCustomHeadersConfig.class}, tree="[0]")
    private Output</* @Nullable */ ResponseHeadersPolicyCustomHeadersConfig> customHeadersConfig;

    /**
     * @return Object that contains an attribute `items` that contains a list of custom headers. See Custom Header for more information.
     * 
     */
    public Output<Optional<ResponseHeadersPolicyCustomHeadersConfig>> customHeadersConfig() {
        return Codegen.optional(this.customHeadersConfig);
    }
    /**
     * The current version of the response headers policy.
     * 
     */
    @Export(name="etag", refs={String.class}, tree="[0]")
    private Output<String> etag;

    /**
     * @return The current version of the response headers policy.
     * 
     */
    public Output<String> etag() {
        return this.etag;
    }
    /**
     * A unique name to identify the response headers policy.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return A unique name to identify the response headers policy.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * A configuration for a set of HTTP headers to remove from the HTTP response. Object that contains an attribute `items` that contains a list of headers. See Remove Header for more information.
     * 
     */
    @Export(name="removeHeadersConfig", refs={ResponseHeadersPolicyRemoveHeadersConfig.class}, tree="[0]")
    private Output</* @Nullable */ ResponseHeadersPolicyRemoveHeadersConfig> removeHeadersConfig;

    /**
     * @return A configuration for a set of HTTP headers to remove from the HTTP response. Object that contains an attribute `items` that contains a list of headers. See Remove Header for more information.
     * 
     */
    public Output<Optional<ResponseHeadersPolicyRemoveHeadersConfig>> removeHeadersConfig() {
        return Codegen.optional(this.removeHeadersConfig);
    }
    /**
     * A configuration for a set of security-related HTTP response headers. See Security Headers Config for more information.
     * 
     */
    @Export(name="securityHeadersConfig", refs={ResponseHeadersPolicySecurityHeadersConfig.class}, tree="[0]")
    private Output</* @Nullable */ ResponseHeadersPolicySecurityHeadersConfig> securityHeadersConfig;

    /**
     * @return A configuration for a set of security-related HTTP response headers. See Security Headers Config for more information.
     * 
     */
    public Output<Optional<ResponseHeadersPolicySecurityHeadersConfig>> securityHeadersConfig() {
        return Codegen.optional(this.securityHeadersConfig);
    }
    /**
     * A configuration for enabling the Server-Timing header in HTTP responses sent from CloudFront. See Server Timing Headers Config for more information.
     * 
     */
    @Export(name="serverTimingHeadersConfig", refs={ResponseHeadersPolicyServerTimingHeadersConfig.class}, tree="[0]")
    private Output</* @Nullable */ ResponseHeadersPolicyServerTimingHeadersConfig> serverTimingHeadersConfig;

    /**
     * @return A configuration for enabling the Server-Timing header in HTTP responses sent from CloudFront. See Server Timing Headers Config for more information.
     * 
     */
    public Output<Optional<ResponseHeadersPolicyServerTimingHeadersConfig>> serverTimingHeadersConfig() {
        return Codegen.optional(this.serverTimingHeadersConfig);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ResponseHeadersPolicy(String name) {
        this(name, ResponseHeadersPolicyArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ResponseHeadersPolicy(String name, @Nullable ResponseHeadersPolicyArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ResponseHeadersPolicy(String name, @Nullable ResponseHeadersPolicyArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudfront/responseHeadersPolicy:ResponseHeadersPolicy", name, args == null ? ResponseHeadersPolicyArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ResponseHeadersPolicy(String name, Output<String> id, @Nullable ResponseHeadersPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudfront/responseHeadersPolicy:ResponseHeadersPolicy", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ResponseHeadersPolicy get(String name, Output<String> id, @Nullable ResponseHeadersPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ResponseHeadersPolicy(name, id, state, options);
    }
}
