// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudfront;

import com.pulumi.aws.cloudfront.inputs.RealtimeLogConfigEndpointArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class RealtimeLogConfigArgs extends com.pulumi.resources.ResourceArgs {

    public static final RealtimeLogConfigArgs Empty = new RealtimeLogConfigArgs();

    /**
     * The Amazon Kinesis data streams where real-time log data is sent.
     * 
     */
    @Import(name="endpoint", required=true)
    private Output<RealtimeLogConfigEndpointArgs> endpoint;

    /**
     * @return The Amazon Kinesis data streams where real-time log data is sent.
     * 
     */
    public Output<RealtimeLogConfigEndpointArgs> endpoint() {
        return this.endpoint;
    }

    /**
     * The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
     * 
     */
    @Import(name="fields", required=true)
    private Output<List<String>> fields;

    /**
     * @return The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
     * 
     */
    public Output<List<String>> fields() {
        return this.fields;
    }

    /**
     * The unique name to identify this real-time log configuration.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The unique name to identify this real-time log configuration.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. An integer between `1` and `100`, inclusive.
     * 
     */
    @Import(name="samplingRate", required=true)
    private Output<Integer> samplingRate;

    /**
     * @return The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. An integer between `1` and `100`, inclusive.
     * 
     */
    public Output<Integer> samplingRate() {
        return this.samplingRate;
    }

    private RealtimeLogConfigArgs() {}

    private RealtimeLogConfigArgs(RealtimeLogConfigArgs $) {
        this.endpoint = $.endpoint;
        this.fields = $.fields;
        this.name = $.name;
        this.samplingRate = $.samplingRate;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(RealtimeLogConfigArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private RealtimeLogConfigArgs $;

        public Builder() {
            $ = new RealtimeLogConfigArgs();
        }

        public Builder(RealtimeLogConfigArgs defaults) {
            $ = new RealtimeLogConfigArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param endpoint The Amazon Kinesis data streams where real-time log data is sent.
         * 
         * @return builder
         * 
         */
        public Builder endpoint(Output<RealtimeLogConfigEndpointArgs> endpoint) {
            $.endpoint = endpoint;
            return this;
        }

        /**
         * @param endpoint The Amazon Kinesis data streams where real-time log data is sent.
         * 
         * @return builder
         * 
         */
        public Builder endpoint(RealtimeLogConfigEndpointArgs endpoint) {
            return endpoint(Output.of(endpoint));
        }

        /**
         * @param fields The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
         * 
         * @return builder
         * 
         */
        public Builder fields(Output<List<String>> fields) {
            $.fields = fields;
            return this;
        }

        /**
         * @param fields The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
         * 
         * @return builder
         * 
         */
        public Builder fields(List<String> fields) {
            return fields(Output.of(fields));
        }

        /**
         * @param fields The fields that are included in each real-time log record. See the [AWS documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) for supported values.
         * 
         * @return builder
         * 
         */
        public Builder fields(String... fields) {
            return fields(List.of(fields));
        }

        /**
         * @param name The unique name to identify this real-time log configuration.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The unique name to identify this real-time log configuration.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param samplingRate The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. An integer between `1` and `100`, inclusive.
         * 
         * @return builder
         * 
         */
        public Builder samplingRate(Output<Integer> samplingRate) {
            $.samplingRate = samplingRate;
            return this;
        }

        /**
         * @param samplingRate The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. An integer between `1` and `100`, inclusive.
         * 
         * @return builder
         * 
         */
        public Builder samplingRate(Integer samplingRate) {
            return samplingRate(Output.of(samplingRate));
        }

        public RealtimeLogConfigArgs build() {
            $.endpoint = Objects.requireNonNull($.endpoint, "expected parameter 'endpoint' to be non-null");
            $.fields = Objects.requireNonNull($.fields, "expected parameter 'fields' to be non-null");
            $.samplingRate = Objects.requireNonNull($.samplingRate, "expected parameter 'samplingRate' to be non-null");
            return $;
        }
    }

}
