// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudfront;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class PublicKeyArgs extends com.pulumi.resources.ResourceArgs {

    public static final PublicKeyArgs Empty = new PublicKeyArgs();

    /**
     * An optional comment about the public key.
     * 
     */
    @Import(name="comment")
    private @Nullable Output<String> comment;

    /**
     * @return An optional comment about the public key.
     * 
     */
    public Optional<Output<String>> comment() {
        return Optional.ofNullable(this.comment);
    }

    /**
     * The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
     * 
     */
    @Import(name="encodedKey", required=true)
    private Output<String> encodedKey;

    /**
     * @return The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
     * 
     */
    public Output<String> encodedKey() {
        return this.encodedKey;
    }

    /**
     * The name for the public key. By default generated by this provider.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name for the public key. By default generated by this provider.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The name for the public key. Conflicts with `name`.
     * 
     * **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `aws.cloudfront.PublicKey` resource.
     * 
     */
    @Import(name="namePrefix")
    private @Nullable Output<String> namePrefix;

    /**
     * @return The name for the public key. Conflicts with `name`.
     * 
     * **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `aws.cloudfront.PublicKey` resource.
     * 
     */
    public Optional<Output<String>> namePrefix() {
        return Optional.ofNullable(this.namePrefix);
    }

    private PublicKeyArgs() {}

    private PublicKeyArgs(PublicKeyArgs $) {
        this.comment = $.comment;
        this.encodedKey = $.encodedKey;
        this.name = $.name;
        this.namePrefix = $.namePrefix;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(PublicKeyArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private PublicKeyArgs $;

        public Builder() {
            $ = new PublicKeyArgs();
        }

        public Builder(PublicKeyArgs defaults) {
            $ = new PublicKeyArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param comment An optional comment about the public key.
         * 
         * @return builder
         * 
         */
        public Builder comment(@Nullable Output<String> comment) {
            $.comment = comment;
            return this;
        }

        /**
         * @param comment An optional comment about the public key.
         * 
         * @return builder
         * 
         */
        public Builder comment(String comment) {
            return comment(Output.of(comment));
        }

        /**
         * @param encodedKey The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
         * 
         * @return builder
         * 
         */
        public Builder encodedKey(Output<String> encodedKey) {
            $.encodedKey = encodedKey;
            return this;
        }

        /**
         * @param encodedKey The encoded public key that you want to add to CloudFront to use with features like field-level encryption.
         * 
         * @return builder
         * 
         */
        public Builder encodedKey(String encodedKey) {
            return encodedKey(Output.of(encodedKey));
        }

        /**
         * @param name The name for the public key. By default generated by this provider.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name for the public key. By default generated by this provider.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param namePrefix The name for the public key. Conflicts with `name`.
         * 
         * **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `aws.cloudfront.PublicKey` resource.
         * 
         * @return builder
         * 
         */
        public Builder namePrefix(@Nullable Output<String> namePrefix) {
            $.namePrefix = namePrefix;
            return this;
        }

        /**
         * @param namePrefix The name for the public key. Conflicts with `name`.
         * 
         * **NOTE:** When setting `encoded_key` value, there needs a newline at the end of string. Otherwise, multiple runs of pulumi will want to recreate the `aws.cloudfront.PublicKey` resource.
         * 
         * @return builder
         * 
         */
        public Builder namePrefix(String namePrefix) {
            return namePrefix(Output.of(namePrefix));
        }

        public PublicKeyArgs build() {
            $.encodedKey = Objects.requireNonNull($.encodedKey, "expected parameter 'encodedKey' to be non-null");
            return $;
        }
    }

}
