// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudfront;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.cloudfront.FieldLevelEncryptionProfileArgs;
import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionProfileState;
import com.pulumi.aws.cloudfront.outputs.FieldLevelEncryptionProfileEncryptionEntities;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a CloudFront Field-level Encryption Profile resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.PublicKey;
 * import com.pulumi.aws.cloudfront.PublicKeyArgs;
 * import com.pulumi.aws.cloudfront.FieldLevelEncryptionProfile;
 * import com.pulumi.aws.cloudfront.FieldLevelEncryptionProfileArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionProfileEncryptionEntitiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new PublicKey(&#34;example&#34;, PublicKeyArgs.builder()        
 *             .comment(&#34;test public key&#34;)
 *             .encodedKey(Files.readString(Paths.get(&#34;public_key.pem&#34;)))
 *             .build());
 * 
 *         var test = new FieldLevelEncryptionProfile(&#34;test&#34;, FieldLevelEncryptionProfileArgs.builder()        
 *             .comment(&#34;test comment&#34;)
 *             .encryptionEntities(FieldLevelEncryptionProfileEncryptionEntitiesArgs.builder()
 *                 .items(FieldLevelEncryptionProfileEncryptionEntitiesItemArgs.builder()
 *                     .publicKeyId(example.id())
 *                     .providerId(&#34;test provider&#34;)
 *                     .fieldPatterns(FieldLevelEncryptionProfileEncryptionEntitiesItemFieldPatternsArgs.builder()
 *                         .items(&#34;DateOfBirth&#34;)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Cloudfront Field Level Encryption Profile using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:cloudfront/fieldLevelEncryptionProfile:FieldLevelEncryptionProfile profile K3D5EWEUDCCXON
 * ```
 * 
 */
@ResourceType(type="aws:cloudfront/fieldLevelEncryptionProfile:FieldLevelEncryptionProfile")
public class FieldLevelEncryptionProfile extends com.pulumi.resources.CustomResource {
    /**
     * Internal value used by CloudFront to allow future updates to the Field Level Encryption Profile.
     * 
     */
    @Export(name="callerReference", refs={String.class}, tree="[0]")
    private Output<String> callerReference;

    /**
     * @return Internal value used by CloudFront to allow future updates to the Field Level Encryption Profile.
     * 
     */
    public Output<String> callerReference() {
        return this.callerReference;
    }
    /**
     * An optional comment about the Field Level Encryption Profile.
     * 
     */
    @Export(name="comment", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> comment;

    /**
     * @return An optional comment about the Field Level Encryption Profile.
     * 
     */
    public Output<Optional<String>> comment() {
        return Codegen.optional(this.comment);
    }
    /**
     * The encryption entities config block for field-level encryption profiles that contains an attribute `items` which includes the encryption key and field pattern specifications.
     * 
     */
    @Export(name="encryptionEntities", refs={FieldLevelEncryptionProfileEncryptionEntities.class}, tree="[0]")
    private Output<FieldLevelEncryptionProfileEncryptionEntities> encryptionEntities;

    /**
     * @return The encryption entities config block for field-level encryption profiles that contains an attribute `items` which includes the encryption key and field pattern specifications.
     * 
     */
    public Output<FieldLevelEncryptionProfileEncryptionEntities> encryptionEntities() {
        return this.encryptionEntities;
    }
    /**
     * The current version of the Field Level Encryption Profile. For example: `E2QWRUHAPOMQZL`.
     * 
     */
    @Export(name="etag", refs={String.class}, tree="[0]")
    private Output<String> etag;

    /**
     * @return The current version of the Field Level Encryption Profile. For example: `E2QWRUHAPOMQZL`.
     * 
     */
    public Output<String> etag() {
        return this.etag;
    }
    /**
     * The name of the Field Level Encryption Profile.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the Field Level Encryption Profile.
     * 
     */
    public Output<String> name() {
        return this.name;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public FieldLevelEncryptionProfile(String name) {
        this(name, FieldLevelEncryptionProfileArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public FieldLevelEncryptionProfile(String name, FieldLevelEncryptionProfileArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public FieldLevelEncryptionProfile(String name, FieldLevelEncryptionProfileArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudfront/fieldLevelEncryptionProfile:FieldLevelEncryptionProfile", name, args == null ? FieldLevelEncryptionProfileArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private FieldLevelEncryptionProfile(String name, Output<String> id, @Nullable FieldLevelEncryptionProfileState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudfront/fieldLevelEncryptionProfile:FieldLevelEncryptionProfile", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static FieldLevelEncryptionProfile get(String name, Output<String> id, @Nullable FieldLevelEncryptionProfileState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new FieldLevelEncryptionProfile(name, id, state, options);
    }
}
