// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudfront;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.cloudfront.FieldLevelEncryptionConfigArgs;
import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigState;
import com.pulumi.aws.cloudfront.outputs.FieldLevelEncryptionConfigContentTypeProfileConfig;
import com.pulumi.aws.cloudfront.outputs.FieldLevelEncryptionConfigQueryArgProfileConfig;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a CloudFront Field-level Encryption Config resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudfront.FieldLevelEncryptionConfig;
 * import com.pulumi.aws.cloudfront.FieldLevelEncryptionConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigArgs;
 * import com.pulumi.aws.cloudfront.inputs.FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new FieldLevelEncryptionConfig(&#34;test&#34;, FieldLevelEncryptionConfigArgs.builder()        
 *             .comment(&#34;test comment&#34;)
 *             .contentTypeProfileConfig(FieldLevelEncryptionConfigContentTypeProfileConfigArgs.builder()
 *                 .forwardWhenContentTypeIsUnknown(true)
 *                 .contentTypeProfiles(FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesArgs.builder()
 *                     .items(FieldLevelEncryptionConfigContentTypeProfileConfigContentTypeProfilesItemArgs.builder()
 *                         .contentType(&#34;application/x-www-form-urlencoded&#34;)
 *                         .format(&#34;URLEncoded&#34;)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .queryArgProfileConfig(FieldLevelEncryptionConfigQueryArgProfileConfigArgs.builder()
 *                 .forwardWhenQueryArgProfileIsUnknown(true)
 *                 .queryArgProfiles(FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesArgs.builder()
 *                     .items(FieldLevelEncryptionConfigQueryArgProfileConfigQueryArgProfilesItemArgs.builder()
 *                         .profileId(aws_cloudfront_field_level_encryption_profile.test().id())
 *                         .queryArg(&#34;Arg1&#34;)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Cloudfront Field Level Encryption Config using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:cloudfront/fieldLevelEncryptionConfig:FieldLevelEncryptionConfig config E74FTE3AEXAMPLE
 * ```
 * 
 */
@ResourceType(type="aws:cloudfront/fieldLevelEncryptionConfig:FieldLevelEncryptionConfig")
public class FieldLevelEncryptionConfig extends com.pulumi.resources.CustomResource {
    /**
     * Internal value used by CloudFront to allow future updates to the Field Level Encryption Config.
     * 
     */
    @Export(name="callerReference", refs={String.class}, tree="[0]")
    private Output<String> callerReference;

    /**
     * @return Internal value used by CloudFront to allow future updates to the Field Level Encryption Config.
     * 
     */
    public Output<String> callerReference() {
        return this.callerReference;
    }
    /**
     * An optional comment about the Field Level Encryption Config.
     * 
     */
    @Export(name="comment", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> comment;

    /**
     * @return An optional comment about the Field Level Encryption Config.
     * 
     */
    public Output<Optional<String>> comment() {
        return Codegen.optional(this.comment);
    }
    /**
     * Content Type Profile Config specifies when to forward content if a content type isn&#39;t recognized and profiles to use as by default in a request if a query argument doesn&#39;t specify a profile to use.
     * 
     */
    @Export(name="contentTypeProfileConfig", refs={FieldLevelEncryptionConfigContentTypeProfileConfig.class}, tree="[0]")
    private Output<FieldLevelEncryptionConfigContentTypeProfileConfig> contentTypeProfileConfig;

    /**
     * @return Content Type Profile Config specifies when to forward content if a content type isn&#39;t recognized and profiles to use as by default in a request if a query argument doesn&#39;t specify a profile to use.
     * 
     */
    public Output<FieldLevelEncryptionConfigContentTypeProfileConfig> contentTypeProfileConfig() {
        return this.contentTypeProfileConfig;
    }
    /**
     * The current version of the Field Level Encryption Config. For example: `E2QWRUHAPOMQZL`.
     * 
     */
    @Export(name="etag", refs={String.class}, tree="[0]")
    private Output<String> etag;

    /**
     * @return The current version of the Field Level Encryption Config. For example: `E2QWRUHAPOMQZL`.
     * 
     */
    public Output<String> etag() {
        return this.etag;
    }
    /**
     * Query Arg Profile Config that specifies when to forward content if a profile isn&#39;t found and the profile that can be provided as a query argument in a request.
     * 
     */
    @Export(name="queryArgProfileConfig", refs={FieldLevelEncryptionConfigQueryArgProfileConfig.class}, tree="[0]")
    private Output<FieldLevelEncryptionConfigQueryArgProfileConfig> queryArgProfileConfig;

    /**
     * @return Query Arg Profile Config that specifies when to forward content if a profile isn&#39;t found and the profile that can be provided as a query argument in a request.
     * 
     */
    public Output<FieldLevelEncryptionConfigQueryArgProfileConfig> queryArgProfileConfig() {
        return this.queryArgProfileConfig;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public FieldLevelEncryptionConfig(String name) {
        this(name, FieldLevelEncryptionConfigArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public FieldLevelEncryptionConfig(String name, FieldLevelEncryptionConfigArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public FieldLevelEncryptionConfig(String name, FieldLevelEncryptionConfigArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudfront/fieldLevelEncryptionConfig:FieldLevelEncryptionConfig", name, args == null ? FieldLevelEncryptionConfigArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private FieldLevelEncryptionConfig(String name, Output<String> id, @Nullable FieldLevelEncryptionConfigState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudfront/fieldLevelEncryptionConfig:FieldLevelEncryptionConfig", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static FieldLevelEncryptionConfig get(String name, Output<String> id, @Nullable FieldLevelEncryptionConfigState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new FieldLevelEncryptionConfig(name, id, state, options);
    }
}
