// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudformation.inputs;

import com.pulumi.aws.cloudformation.inputs.StackSetInstanceDeploymentTargetsArgs;
import com.pulumi.aws.cloudformation.inputs.StackSetInstanceOperationPreferencesArgs;
import com.pulumi.aws.cloudformation.inputs.StackSetInstanceStackInstanceSummaryArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class StackSetInstanceState extends com.pulumi.resources.ResourceArgs {

    public static final StackSetInstanceState Empty = new StackSetInstanceState();

    /**
     * Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
     * 
     */
    @Import(name="accountId")
    private @Nullable Output<String> accountId;

    /**
     * @return Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
     * 
     */
    public Optional<Output<String>> accountId() {
        return Optional.ofNullable(this.accountId);
    }

    /**
     * Specifies whether you are acting as an account administrator in the organization&#39;s management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
     * 
     */
    @Import(name="callAs")
    private @Nullable Output<String> callAs;

    /**
     * @return Specifies whether you are acting as an account administrator in the organization&#39;s management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
     * 
     */
    public Optional<Output<String>> callAs() {
        return Optional.ofNullable(this.callAs);
    }

    /**
     * The AWS Organizations accounts to which StackSets deploys. StackSets doesn&#39;t deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
     * 
     */
    @Import(name="deploymentTargets")
    private @Nullable Output<StackSetInstanceDeploymentTargetsArgs> deploymentTargets;

    /**
     * @return The AWS Organizations accounts to which StackSets deploys. StackSets doesn&#39;t deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
     * 
     */
    public Optional<Output<StackSetInstanceDeploymentTargetsArgs>> deploymentTargets() {
        return Optional.ofNullable(this.deploymentTargets);
    }

    /**
     * Preferences for how AWS CloudFormation performs a stack set operation.
     * 
     */
    @Import(name="operationPreferences")
    private @Nullable Output<StackSetInstanceOperationPreferencesArgs> operationPreferences;

    /**
     * @return Preferences for how AWS CloudFormation performs a stack set operation.
     * 
     */
    public Optional<Output<StackSetInstanceOperationPreferencesArgs>> operationPreferences() {
        return Optional.ofNullable(this.operationPreferences);
    }

    /**
     * Organizational unit ID in which the stack is deployed.
     * 
     */
    @Import(name="organizationalUnitId")
    private @Nullable Output<String> organizationalUnitId;

    /**
     * @return Organizational unit ID in which the stack is deployed.
     * 
     */
    public Optional<Output<String>> organizationalUnitId() {
        return Optional.ofNullable(this.organizationalUnitId);
    }

    /**
     * Key-value map of input parameters to override from the StackSet for this Instance.
     * 
     */
    @Import(name="parameterOverrides")
    private @Nullable Output<Map<String,String>> parameterOverrides;

    /**
     * @return Key-value map of input parameters to override from the StackSet for this Instance.
     * 
     */
    public Optional<Output<Map<String,String>>> parameterOverrides() {
        return Optional.ofNullable(this.parameterOverrides);
    }

    /**
     * Target AWS Region to create a Stack based on the StackSet. Defaults to current region.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return Target AWS Region to create a Stack based on the StackSet. Defaults to current region.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * During resource destroy, remove Instance from StackSet while keeping the Stack and its associated resources. Must be enabled in the state _before_ destroy operation to take effect. You cannot reassociate a retained Stack or add an existing, saved Stack to a new StackSet. Defaults to `false`.
     * 
     */
    @Import(name="retainStack")
    private @Nullable Output<Boolean> retainStack;

    /**
     * @return During resource destroy, remove Instance from StackSet while keeping the Stack and its associated resources. Must be enabled in the state _before_ destroy operation to take effect. You cannot reassociate a retained Stack or add an existing, saved Stack to a new StackSet. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> retainStack() {
        return Optional.ofNullable(this.retainStack);
    }

    /**
     * Stack identifier.
     * 
     */
    @Import(name="stackId")
    private @Nullable Output<String> stackId;

    /**
     * @return Stack identifier.
     * 
     */
    public Optional<Output<String>> stackId() {
        return Optional.ofNullable(this.stackId);
    }

    /**
     * List of stack instances created from an organizational unit deployment target. This will only be populated when `deployment_targets` is set. See `stack_instance_summaries`.
     * 
     */
    @Import(name="stackInstanceSummaries")
    private @Nullable Output<List<StackSetInstanceStackInstanceSummaryArgs>> stackInstanceSummaries;

    /**
     * @return List of stack instances created from an organizational unit deployment target. This will only be populated when `deployment_targets` is set. See `stack_instance_summaries`.
     * 
     */
    public Optional<Output<List<StackSetInstanceStackInstanceSummaryArgs>>> stackInstanceSummaries() {
        return Optional.ofNullable(this.stackInstanceSummaries);
    }

    /**
     * Name of the StackSet.
     * 
     */
    @Import(name="stackSetName")
    private @Nullable Output<String> stackSetName;

    /**
     * @return Name of the StackSet.
     * 
     */
    public Optional<Output<String>> stackSetName() {
        return Optional.ofNullable(this.stackSetName);
    }

    private StackSetInstanceState() {}

    private StackSetInstanceState(StackSetInstanceState $) {
        this.accountId = $.accountId;
        this.callAs = $.callAs;
        this.deploymentTargets = $.deploymentTargets;
        this.operationPreferences = $.operationPreferences;
        this.organizationalUnitId = $.organizationalUnitId;
        this.parameterOverrides = $.parameterOverrides;
        this.region = $.region;
        this.retainStack = $.retainStack;
        this.stackId = $.stackId;
        this.stackInstanceSummaries = $.stackInstanceSummaries;
        this.stackSetName = $.stackSetName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(StackSetInstanceState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private StackSetInstanceState $;

        public Builder() {
            $ = new StackSetInstanceState();
        }

        public Builder(StackSetInstanceState defaults) {
            $ = new StackSetInstanceState(Objects.requireNonNull(defaults));
        }

        /**
         * @param accountId Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
         * 
         * @return builder
         * 
         */
        public Builder accountId(@Nullable Output<String> accountId) {
            $.accountId = accountId;
            return this;
        }

        /**
         * @param accountId Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
         * 
         * @return builder
         * 
         */
        public Builder accountId(String accountId) {
            return accountId(Output.of(accountId));
        }

        /**
         * @param callAs Specifies whether you are acting as an account administrator in the organization&#39;s management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
         * 
         * @return builder
         * 
         */
        public Builder callAs(@Nullable Output<String> callAs) {
            $.callAs = callAs;
            return this;
        }

        /**
         * @param callAs Specifies whether you are acting as an account administrator in the organization&#39;s management account or as a delegated administrator in a member account. Valid values: `SELF` (default), `DELEGATED_ADMIN`.
         * 
         * @return builder
         * 
         */
        public Builder callAs(String callAs) {
            return callAs(Output.of(callAs));
        }

        /**
         * @param deploymentTargets The AWS Organizations accounts to which StackSets deploys. StackSets doesn&#39;t deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
         * 
         * @return builder
         * 
         */
        public Builder deploymentTargets(@Nullable Output<StackSetInstanceDeploymentTargetsArgs> deploymentTargets) {
            $.deploymentTargets = deploymentTargets;
            return this;
        }

        /**
         * @param deploymentTargets The AWS Organizations accounts to which StackSets deploys. StackSets doesn&#39;t deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization. Drift detection is not possible for this argument. See deployment_targets below.
         * 
         * @return builder
         * 
         */
        public Builder deploymentTargets(StackSetInstanceDeploymentTargetsArgs deploymentTargets) {
            return deploymentTargets(Output.of(deploymentTargets));
        }

        /**
         * @param operationPreferences Preferences for how AWS CloudFormation performs a stack set operation.
         * 
         * @return builder
         * 
         */
        public Builder operationPreferences(@Nullable Output<StackSetInstanceOperationPreferencesArgs> operationPreferences) {
            $.operationPreferences = operationPreferences;
            return this;
        }

        /**
         * @param operationPreferences Preferences for how AWS CloudFormation performs a stack set operation.
         * 
         * @return builder
         * 
         */
        public Builder operationPreferences(StackSetInstanceOperationPreferencesArgs operationPreferences) {
            return operationPreferences(Output.of(operationPreferences));
        }

        /**
         * @param organizationalUnitId Organizational unit ID in which the stack is deployed.
         * 
         * @return builder
         * 
         */
        public Builder organizationalUnitId(@Nullable Output<String> organizationalUnitId) {
            $.organizationalUnitId = organizationalUnitId;
            return this;
        }

        /**
         * @param organizationalUnitId Organizational unit ID in which the stack is deployed.
         * 
         * @return builder
         * 
         */
        public Builder organizationalUnitId(String organizationalUnitId) {
            return organizationalUnitId(Output.of(organizationalUnitId));
        }

        /**
         * @param parameterOverrides Key-value map of input parameters to override from the StackSet for this Instance.
         * 
         * @return builder
         * 
         */
        public Builder parameterOverrides(@Nullable Output<Map<String,String>> parameterOverrides) {
            $.parameterOverrides = parameterOverrides;
            return this;
        }

        /**
         * @param parameterOverrides Key-value map of input parameters to override from the StackSet for this Instance.
         * 
         * @return builder
         * 
         */
        public Builder parameterOverrides(Map<String,String> parameterOverrides) {
            return parameterOverrides(Output.of(parameterOverrides));
        }

        /**
         * @param region Target AWS Region to create a Stack based on the StackSet. Defaults to current region.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region Target AWS Region to create a Stack based on the StackSet. Defaults to current region.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param retainStack During resource destroy, remove Instance from StackSet while keeping the Stack and its associated resources. Must be enabled in the state _before_ destroy operation to take effect. You cannot reassociate a retained Stack or add an existing, saved Stack to a new StackSet. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder retainStack(@Nullable Output<Boolean> retainStack) {
            $.retainStack = retainStack;
            return this;
        }

        /**
         * @param retainStack During resource destroy, remove Instance from StackSet while keeping the Stack and its associated resources. Must be enabled in the state _before_ destroy operation to take effect. You cannot reassociate a retained Stack or add an existing, saved Stack to a new StackSet. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder retainStack(Boolean retainStack) {
            return retainStack(Output.of(retainStack));
        }

        /**
         * @param stackId Stack identifier.
         * 
         * @return builder
         * 
         */
        public Builder stackId(@Nullable Output<String> stackId) {
            $.stackId = stackId;
            return this;
        }

        /**
         * @param stackId Stack identifier.
         * 
         * @return builder
         * 
         */
        public Builder stackId(String stackId) {
            return stackId(Output.of(stackId));
        }

        /**
         * @param stackInstanceSummaries List of stack instances created from an organizational unit deployment target. This will only be populated when `deployment_targets` is set. See `stack_instance_summaries`.
         * 
         * @return builder
         * 
         */
        public Builder stackInstanceSummaries(@Nullable Output<List<StackSetInstanceStackInstanceSummaryArgs>> stackInstanceSummaries) {
            $.stackInstanceSummaries = stackInstanceSummaries;
            return this;
        }

        /**
         * @param stackInstanceSummaries List of stack instances created from an organizational unit deployment target. This will only be populated when `deployment_targets` is set. See `stack_instance_summaries`.
         * 
         * @return builder
         * 
         */
        public Builder stackInstanceSummaries(List<StackSetInstanceStackInstanceSummaryArgs> stackInstanceSummaries) {
            return stackInstanceSummaries(Output.of(stackInstanceSummaries));
        }

        /**
         * @param stackInstanceSummaries List of stack instances created from an organizational unit deployment target. This will only be populated when `deployment_targets` is set. See `stack_instance_summaries`.
         * 
         * @return builder
         * 
         */
        public Builder stackInstanceSummaries(StackSetInstanceStackInstanceSummaryArgs... stackInstanceSummaries) {
            return stackInstanceSummaries(List.of(stackInstanceSummaries));
        }

        /**
         * @param stackSetName Name of the StackSet.
         * 
         * @return builder
         * 
         */
        public Builder stackSetName(@Nullable Output<String> stackSetName) {
            $.stackSetName = stackSetName;
            return this;
        }

        /**
         * @param stackSetName Name of the StackSet.
         * 
         * @return builder
         * 
         */
        public Builder stackSetName(String stackSetName) {
            return stackSetName(Output.of(stackSetName));
        }

        public StackSetInstanceState build() {
            return $;
        }
    }

}
