// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudformation;

import com.pulumi.aws.cloudformation.inputs.CloudFormationTypeLoggingConfigArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class CloudFormationTypeArgs extends com.pulumi.resources.ResourceArgs {

    public static final CloudFormationTypeArgs Empty = new CloudFormationTypeArgs();

    /**
     * Amazon Resource Name (ARN) of the IAM Role for CloudFormation to assume when invoking the extension. If your extension calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. When CloudFormation needs to invoke the extension handler, CloudFormation assumes this execution role to create a temporary session token, which it then passes to the extension handler, thereby supplying your extension with the appropriate credentials.
     * 
     */
    @Import(name="executionRoleArn")
    private @Nullable Output<String> executionRoleArn;

    /**
     * @return Amazon Resource Name (ARN) of the IAM Role for CloudFormation to assume when invoking the extension. If your extension calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. When CloudFormation needs to invoke the extension handler, CloudFormation assumes this execution role to create a temporary session token, which it then passes to the extension handler, thereby supplying your extension with the appropriate credentials.
     * 
     */
    public Optional<Output<String>> executionRoleArn() {
        return Optional.ofNullable(this.executionRoleArn);
    }

    /**
     * Configuration block containing logging configuration.
     * 
     */
    @Import(name="loggingConfig")
    private @Nullable Output<CloudFormationTypeLoggingConfigArgs> loggingConfig;

    /**
     * @return Configuration block containing logging configuration.
     * 
     */
    public Optional<Output<CloudFormationTypeLoggingConfigArgs>> loggingConfig() {
        return Optional.ofNullable(this.loggingConfig);
    }

    /**
     * URL to the S3 bucket containing the extension project package that contains the necessary files for the extension you want to register. Must begin with `s3://` or `https://`. For example, `s3://example-bucket/example-object`.
     * 
     */
    @Import(name="schemaHandlerPackage", required=true)
    private Output<String> schemaHandlerPackage;

    /**
     * @return URL to the S3 bucket containing the extension project package that contains the necessary files for the extension you want to register. Must begin with `s3://` or `https://`. For example, `s3://example-bucket/example-object`.
     * 
     */
    public Output<String> schemaHandlerPackage() {
        return this.schemaHandlerPackage;
    }

    /**
     * CloudFormation Registry Type. For example, `RESOURCE` or `MODULE`.
     * 
     */
    @Import(name="type")
    private @Nullable Output<String> type;

    /**
     * @return CloudFormation Registry Type. For example, `RESOURCE` or `MODULE`.
     * 
     */
    public Optional<Output<String>> type() {
        return Optional.ofNullable(this.type);
    }

    /**
     * CloudFormation Type name. For example, `ExampleCompany::ExampleService::ExampleResource`.
     * 
     */
    @Import(name="typeName", required=true)
    private Output<String> typeName;

    /**
     * @return CloudFormation Type name. For example, `ExampleCompany::ExampleService::ExampleResource`.
     * 
     */
    public Output<String> typeName() {
        return this.typeName;
    }

    private CloudFormationTypeArgs() {}

    private CloudFormationTypeArgs(CloudFormationTypeArgs $) {
        this.executionRoleArn = $.executionRoleArn;
        this.loggingConfig = $.loggingConfig;
        this.schemaHandlerPackage = $.schemaHandlerPackage;
        this.type = $.type;
        this.typeName = $.typeName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(CloudFormationTypeArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private CloudFormationTypeArgs $;

        public Builder() {
            $ = new CloudFormationTypeArgs();
        }

        public Builder(CloudFormationTypeArgs defaults) {
            $ = new CloudFormationTypeArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param executionRoleArn Amazon Resource Name (ARN) of the IAM Role for CloudFormation to assume when invoking the extension. If your extension calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. When CloudFormation needs to invoke the extension handler, CloudFormation assumes this execution role to create a temporary session token, which it then passes to the extension handler, thereby supplying your extension with the appropriate credentials.
         * 
         * @return builder
         * 
         */
        public Builder executionRoleArn(@Nullable Output<String> executionRoleArn) {
            $.executionRoleArn = executionRoleArn;
            return this;
        }

        /**
         * @param executionRoleArn Amazon Resource Name (ARN) of the IAM Role for CloudFormation to assume when invoking the extension. If your extension calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. When CloudFormation needs to invoke the extension handler, CloudFormation assumes this execution role to create a temporary session token, which it then passes to the extension handler, thereby supplying your extension with the appropriate credentials.
         * 
         * @return builder
         * 
         */
        public Builder executionRoleArn(String executionRoleArn) {
            return executionRoleArn(Output.of(executionRoleArn));
        }

        /**
         * @param loggingConfig Configuration block containing logging configuration.
         * 
         * @return builder
         * 
         */
        public Builder loggingConfig(@Nullable Output<CloudFormationTypeLoggingConfigArgs> loggingConfig) {
            $.loggingConfig = loggingConfig;
            return this;
        }

        /**
         * @param loggingConfig Configuration block containing logging configuration.
         * 
         * @return builder
         * 
         */
        public Builder loggingConfig(CloudFormationTypeLoggingConfigArgs loggingConfig) {
            return loggingConfig(Output.of(loggingConfig));
        }

        /**
         * @param schemaHandlerPackage URL to the S3 bucket containing the extension project package that contains the necessary files for the extension you want to register. Must begin with `s3://` or `https://`. For example, `s3://example-bucket/example-object`.
         * 
         * @return builder
         * 
         */
        public Builder schemaHandlerPackage(Output<String> schemaHandlerPackage) {
            $.schemaHandlerPackage = schemaHandlerPackage;
            return this;
        }

        /**
         * @param schemaHandlerPackage URL to the S3 bucket containing the extension project package that contains the necessary files for the extension you want to register. Must begin with `s3://` or `https://`. For example, `s3://example-bucket/example-object`.
         * 
         * @return builder
         * 
         */
        public Builder schemaHandlerPackage(String schemaHandlerPackage) {
            return schemaHandlerPackage(Output.of(schemaHandlerPackage));
        }

        /**
         * @param type CloudFormation Registry Type. For example, `RESOURCE` or `MODULE`.
         * 
         * @return builder
         * 
         */
        public Builder type(@Nullable Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type CloudFormation Registry Type. For example, `RESOURCE` or `MODULE`.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        /**
         * @param typeName CloudFormation Type name. For example, `ExampleCompany::ExampleService::ExampleResource`.
         * 
         * @return builder
         * 
         */
        public Builder typeName(Output<String> typeName) {
            $.typeName = typeName;
            return this;
        }

        /**
         * @param typeName CloudFormation Type name. For example, `ExampleCompany::ExampleService::ExampleResource`.
         * 
         * @return builder
         * 
         */
        public Builder typeName(String typeName) {
            return typeName(Output.of(typeName));
        }

        public CloudFormationTypeArgs build() {
            $.schemaHandlerPackage = Objects.requireNonNull($.schemaHandlerPackage, "expected parameter 'schemaHandlerPackage' to be non-null");
            $.typeName = Objects.requireNonNull($.typeName, "expected parameter 'typeName' to be non-null");
            return $;
        }
    }

}
