// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudcontrol;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ResourceArgs extends com.pulumi.resources.ResourceArgs {

    public static final ResourceArgs Empty = new ResourceArgs();

    /**
     * JSON string matching the CloudFormation resource type schema with desired configuration.
     * 
     */
    @Import(name="desiredState", required=true)
    private Output<String> desiredState;

    /**
     * @return JSON string matching the CloudFormation resource type schema with desired configuration.
     * 
     */
    public Output<String> desiredState() {
        return this.desiredState;
    }

    /**
     * Amazon Resource Name (ARN) of the IAM Role to assume for operations.
     * 
     */
    @Import(name="roleArn")
    private @Nullable Output<String> roleArn;

    /**
     * @return Amazon Resource Name (ARN) of the IAM Role to assume for operations.
     * 
     */
    public Optional<Output<String>> roleArn() {
        return Optional.ofNullable(this.roleArn);
    }

    /**
     * JSON string of the CloudFormation resource type schema which is used for plan time validation where possible. Automatically fetched if not provided. In large scale environments with multiple resources using the same `type_name`, it is recommended to fetch the schema once via the `aws.cloudformation.CloudFormationType` data source and use this argument to reduce `DescribeType` API operation throttling. This value is marked sensitive only to prevent large plan differences from showing.
     * 
     */
    @Import(name="schema")
    private @Nullable Output<String> schema;

    /**
     * @return JSON string of the CloudFormation resource type schema which is used for plan time validation where possible. Automatically fetched if not provided. In large scale environments with multiple resources using the same `type_name`, it is recommended to fetch the schema once via the `aws.cloudformation.CloudFormationType` data source and use this argument to reduce `DescribeType` API operation throttling. This value is marked sensitive only to prevent large plan differences from showing.
     * 
     */
    public Optional<Output<String>> schema() {
        return Optional.ofNullable(this.schema);
    }

    /**
     * CloudFormation resource type name. For example, `AWS::EC2::VPC`.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="typeName", required=true)
    private Output<String> typeName;

    /**
     * @return CloudFormation resource type name. For example, `AWS::EC2::VPC`.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> typeName() {
        return this.typeName;
    }

    /**
     * Identifier of the CloudFormation resource type version.
     * 
     */
    @Import(name="typeVersionId")
    private @Nullable Output<String> typeVersionId;

    /**
     * @return Identifier of the CloudFormation resource type version.
     * 
     */
    public Optional<Output<String>> typeVersionId() {
        return Optional.ofNullable(this.typeVersionId);
    }

    private ResourceArgs() {}

    private ResourceArgs(ResourceArgs $) {
        this.desiredState = $.desiredState;
        this.roleArn = $.roleArn;
        this.schema = $.schema;
        this.typeName = $.typeName;
        this.typeVersionId = $.typeVersionId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ResourceArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ResourceArgs $;

        public Builder() {
            $ = new ResourceArgs();
        }

        public Builder(ResourceArgs defaults) {
            $ = new ResourceArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param desiredState JSON string matching the CloudFormation resource type schema with desired configuration.
         * 
         * @return builder
         * 
         */
        public Builder desiredState(Output<String> desiredState) {
            $.desiredState = desiredState;
            return this;
        }

        /**
         * @param desiredState JSON string matching the CloudFormation resource type schema with desired configuration.
         * 
         * @return builder
         * 
         */
        public Builder desiredState(String desiredState) {
            return desiredState(Output.of(desiredState));
        }

        /**
         * @param roleArn Amazon Resource Name (ARN) of the IAM Role to assume for operations.
         * 
         * @return builder
         * 
         */
        public Builder roleArn(@Nullable Output<String> roleArn) {
            $.roleArn = roleArn;
            return this;
        }

        /**
         * @param roleArn Amazon Resource Name (ARN) of the IAM Role to assume for operations.
         * 
         * @return builder
         * 
         */
        public Builder roleArn(String roleArn) {
            return roleArn(Output.of(roleArn));
        }

        /**
         * @param schema JSON string of the CloudFormation resource type schema which is used for plan time validation where possible. Automatically fetched if not provided. In large scale environments with multiple resources using the same `type_name`, it is recommended to fetch the schema once via the `aws.cloudformation.CloudFormationType` data source and use this argument to reduce `DescribeType` API operation throttling. This value is marked sensitive only to prevent large plan differences from showing.
         * 
         * @return builder
         * 
         */
        public Builder schema(@Nullable Output<String> schema) {
            $.schema = schema;
            return this;
        }

        /**
         * @param schema JSON string of the CloudFormation resource type schema which is used for plan time validation where possible. Automatically fetched if not provided. In large scale environments with multiple resources using the same `type_name`, it is recommended to fetch the schema once via the `aws.cloudformation.CloudFormationType` data source and use this argument to reduce `DescribeType` API operation throttling. This value is marked sensitive only to prevent large plan differences from showing.
         * 
         * @return builder
         * 
         */
        public Builder schema(String schema) {
            return schema(Output.of(schema));
        }

        /**
         * @param typeName CloudFormation resource type name. For example, `AWS::EC2::VPC`.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder typeName(Output<String> typeName) {
            $.typeName = typeName;
            return this;
        }

        /**
         * @param typeName CloudFormation resource type name. For example, `AWS::EC2::VPC`.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder typeName(String typeName) {
            return typeName(Output.of(typeName));
        }

        /**
         * @param typeVersionId Identifier of the CloudFormation resource type version.
         * 
         * @return builder
         * 
         */
        public Builder typeVersionId(@Nullable Output<String> typeVersionId) {
            $.typeVersionId = typeVersionId;
            return this;
        }

        /**
         * @param typeVersionId Identifier of the CloudFormation resource type version.
         * 
         * @return builder
         * 
         */
        public Builder typeVersionId(String typeVersionId) {
            return typeVersionId(Output.of(typeVersionId));
        }

        public ResourceArgs build() {
            $.desiredState = Objects.requireNonNull($.desiredState, "expected parameter 'desiredState' to be non-null");
            $.typeName = Objects.requireNonNull($.typeName, "expected parameter 'typeName' to be non-null");
            return $;
        }
    }

}
