// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cleanrooms;

import com.pulumi.aws.cleanrooms.inputs.CollaborationDataEncryptionMetadataArgs;
import com.pulumi.aws.cleanrooms.inputs.CollaborationMemberArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class CollaborationArgs extends com.pulumi.resources.ResourceArgs {

    public static final CollaborationArgs Empty = new CollaborationArgs();

    /**
     * The name for the member record for the collaboration creator.
     * 
     */
    @Import(name="creatorDisplayName", required=true)
    private Output<String> creatorDisplayName;

    /**
     * @return The name for the member record for the collaboration creator.
     * 
     */
    public Output<String> creatorDisplayName() {
        return this.creatorDisplayName;
    }

    /**
     * The list of member abilities for the creator of the collaboration.  Valid v
     * lues [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-re
     * uest-creatorMemberAbilities)
     * 
     */
    @Import(name="creatorMemberAbilities", required=true)
    private Output<List<String>> creatorMemberAbilities;

    /**
     * @return The list of member abilities for the creator of the collaboration.  Valid v
     * lues [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-re
     * uest-creatorMemberAbilities)
     * 
     */
    public Output<List<String>> creatorMemberAbilities() {
        return this.creatorMemberAbilities;
    }

    /**
     * a collection of settings which determine how the [c3r client](https://docs
     * aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration
     * * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
     *   field.
     * * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
     *   boolean field.
     * * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
     *   n any other Fingerprint column with a different name. This is a boolean field.
     * * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
     *   or cryptographically processed (false).
     * 
     */
    @Import(name="dataEncryptionMetadata")
    private @Nullable Output<CollaborationDataEncryptionMetadataArgs> dataEncryptionMetadata;

    /**
     * @return a collection of settings which determine how the [c3r client](https://docs
     * aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration
     * * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
     *   field.
     * * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
     *   boolean field.
     * * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
     *   n any other Fingerprint column with a different name. This is a boolean field.
     * * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
     *   or cryptographically processed (false).
     * 
     */
    public Optional<Output<CollaborationDataEncryptionMetadataArgs>> dataEncryptionMetadata() {
        return Optional.ofNullable(this.dataEncryptionMetadata);
    }

    /**
     * A description for a collaboration.
     * 
     */
    @Import(name="description", required=true)
    private Output<String> description;

    /**
     * @return A description for a collaboration.
     * 
     */
    public Output<String> description() {
        return this.description;
    }

    /**
     * Additional members of the collaboration which will be invited to join the collaboration.
     * * `member.account_id` - (Required - Forces new resource) - The account id for the invited member
     * * `member.display_name` - (Required - Forces new resource) - The display name for the invited member
     * * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbiliti
     *   s
     * 
     */
    @Import(name="members")
    private @Nullable Output<List<CollaborationMemberArgs>> members;

    /**
     * @return Additional members of the collaboration which will be invited to join the collaboration.
     * * `member.account_id` - (Required - Forces new resource) - The account id for the invited member
     * * `member.display_name` - (Required - Forces new resource) - The display name for the invited member
     * * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbiliti
     *   s
     * 
     */
    public Optional<Output<List<CollaborationMemberArgs>>> members() {
        return Optional.ofNullable(this.members);
    }

    /**
     * The name of the collaboration.  Collaboration names do not need to be unique.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the collaboration.  Collaboration names do not need to be unique.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Determines if members of the collaboration can enable query logs within their own
     * emberships. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-Cr
     * ateCollaboration-request-queryLogStatus).
     * 
     */
    @Import(name="queryLogStatus", required=true)
    private Output<String> queryLogStatus;

    /**
     * @return Determines if members of the collaboration can enable query logs within their own
     * emberships. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-Cr
     * ateCollaboration-request-queryLogStatus).
     * 
     */
    public Output<String> queryLogStatus() {
        return this.queryLogStatus;
    }

    /**
     * Key value pairs which tag the collaboration.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key value pairs which tag the collaboration.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private CollaborationArgs() {}

    private CollaborationArgs(CollaborationArgs $) {
        this.creatorDisplayName = $.creatorDisplayName;
        this.creatorMemberAbilities = $.creatorMemberAbilities;
        this.dataEncryptionMetadata = $.dataEncryptionMetadata;
        this.description = $.description;
        this.members = $.members;
        this.name = $.name;
        this.queryLogStatus = $.queryLogStatus;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(CollaborationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private CollaborationArgs $;

        public Builder() {
            $ = new CollaborationArgs();
        }

        public Builder(CollaborationArgs defaults) {
            $ = new CollaborationArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param creatorDisplayName The name for the member record for the collaboration creator.
         * 
         * @return builder
         * 
         */
        public Builder creatorDisplayName(Output<String> creatorDisplayName) {
            $.creatorDisplayName = creatorDisplayName;
            return this;
        }

        /**
         * @param creatorDisplayName The name for the member record for the collaboration creator.
         * 
         * @return builder
         * 
         */
        public Builder creatorDisplayName(String creatorDisplayName) {
            return creatorDisplayName(Output.of(creatorDisplayName));
        }

        /**
         * @param creatorMemberAbilities The list of member abilities for the creator of the collaboration.  Valid v
         * lues [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-re
         * uest-creatorMemberAbilities)
         * 
         * @return builder
         * 
         */
        public Builder creatorMemberAbilities(Output<List<String>> creatorMemberAbilities) {
            $.creatorMemberAbilities = creatorMemberAbilities;
            return this;
        }

        /**
         * @param creatorMemberAbilities The list of member abilities for the creator of the collaboration.  Valid v
         * lues [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-re
         * uest-creatorMemberAbilities)
         * 
         * @return builder
         * 
         */
        public Builder creatorMemberAbilities(List<String> creatorMemberAbilities) {
            return creatorMemberAbilities(Output.of(creatorMemberAbilities));
        }

        /**
         * @param creatorMemberAbilities The list of member abilities for the creator of the collaboration.  Valid v
         * lues [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-re
         * uest-creatorMemberAbilities)
         * 
         * @return builder
         * 
         */
        public Builder creatorMemberAbilities(String... creatorMemberAbilities) {
            return creatorMemberAbilities(List.of(creatorMemberAbilities));
        }

        /**
         * @param dataEncryptionMetadata a collection of settings which determine how the [c3r client](https://docs
         * aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration
         * * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
         *   field.
         * * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
         *   boolean field.
         * * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
         *   n any other Fingerprint column with a different name. This is a boolean field.
         * * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
         *   or cryptographically processed (false).
         * 
         * @return builder
         * 
         */
        public Builder dataEncryptionMetadata(@Nullable Output<CollaborationDataEncryptionMetadataArgs> dataEncryptionMetadata) {
            $.dataEncryptionMetadata = dataEncryptionMetadata;
            return this;
        }

        /**
         * @param dataEncryptionMetadata a collection of settings which determine how the [c3r client](https://docs
         * aws.amazon.com/clean-rooms/latest/userguide/crypto-computing.html) will encrypt data for use within this collaboration
         * * `data_encryption_metadata.allow_clear_text` - (Required - Forces new resource) - Indicates whether encrypted tables can contain cleartext data. This is a boolea
         *   field.
         * * `data_encryption_metadata.allow_duplicates` - (Required - Forces new resource ) - Indicates whether Fingerprint columns can contain duplicate entries. This is a
         *   boolean field.
         * * `data_encryption_metadata.allow_joins_on_columns_with_different_names` - (Required - Forces new resource) - Indicates whether Fingerprint columns can be joined
         *   n any other Fingerprint column with a different name. This is a boolean field.
         * * `data_encryption_metadata.preserve_nulls` - (Required - Forces new resource) - Indicates whether NULL values are to be copied as NULL to encrypted tables (true)
         *   or cryptographically processed (false).
         * 
         * @return builder
         * 
         */
        public Builder dataEncryptionMetadata(CollaborationDataEncryptionMetadataArgs dataEncryptionMetadata) {
            return dataEncryptionMetadata(Output.of(dataEncryptionMetadata));
        }

        /**
         * @param description A description for a collaboration.
         * 
         * @return builder
         * 
         */
        public Builder description(Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description A description for a collaboration.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param members Additional members of the collaboration which will be invited to join the collaboration.
         * * `member.account_id` - (Required - Forces new resource) - The account id for the invited member
         * * `member.display_name` - (Required - Forces new resource) - The display name for the invited member
         * * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbiliti
         *   s
         * 
         * @return builder
         * 
         */
        public Builder members(@Nullable Output<List<CollaborationMemberArgs>> members) {
            $.members = members;
            return this;
        }

        /**
         * @param members Additional members of the collaboration which will be invited to join the collaboration.
         * * `member.account_id` - (Required - Forces new resource) - The account id for the invited member
         * * `member.display_name` - (Required - Forces new resource) - The display name for the invited member
         * * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbiliti
         *   s
         * 
         * @return builder
         * 
         */
        public Builder members(List<CollaborationMemberArgs> members) {
            return members(Output.of(members));
        }

        /**
         * @param members Additional members of the collaboration which will be invited to join the collaboration.
         * * `member.account_id` - (Required - Forces new resource) - The account id for the invited member
         * * `member.display_name` - (Required - Forces new resource) - The display name for the invited member
         * * `member.member_abilities` - (Required - Forces new resource) - The list of abilities for the invited member. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-CreateCollaboration-request-creatorMemberAbiliti
         *   s
         * 
         * @return builder
         * 
         */
        public Builder members(CollaborationMemberArgs... members) {
            return members(List.of(members));
        }

        /**
         * @param name The name of the collaboration.  Collaboration names do not need to be unique.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the collaboration.  Collaboration names do not need to be unique.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param queryLogStatus Determines if members of the collaboration can enable query logs within their own
         * emberships. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-Cr
         * ateCollaboration-request-queryLogStatus).
         * 
         * @return builder
         * 
         */
        public Builder queryLogStatus(Output<String> queryLogStatus) {
            $.queryLogStatus = queryLogStatus;
            return this;
        }

        /**
         * @param queryLogStatus Determines if members of the collaboration can enable query logs within their own
         * emberships. Valid values [may be found here](https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html#API-Cr
         * ateCollaboration-request-queryLogStatus).
         * 
         * @return builder
         * 
         */
        public Builder queryLogStatus(String queryLogStatus) {
            return queryLogStatus(Output.of(queryLogStatus));
        }

        /**
         * @param tags Key value pairs which tag the collaboration.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key value pairs which tag the collaboration.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public CollaborationArgs build() {
            $.creatorDisplayName = Objects.requireNonNull($.creatorDisplayName, "expected parameter 'creatorDisplayName' to be non-null");
            $.creatorMemberAbilities = Objects.requireNonNull($.creatorMemberAbilities, "expected parameter 'creatorMemberAbilities' to be non-null");
            $.description = Objects.requireNonNull($.description, "expected parameter 'description' to be non-null");
            $.queryLogStatus = Objects.requireNonNull($.queryLogStatus, "expected parameter 'queryLogStatus' to be non-null");
            return $;
        }
    }

}
