// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.chimesdkmediapipelines;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationState;
import com.pulumi.aws.chimesdkmediapipelines.outputs.MediaInsightsPipelineConfigurationElement;
import com.pulumi.aws.chimesdkmediapipelines.outputs.MediaInsightsPipelineConfigurationRealTimeAlertConfiguration;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS Chime SDK Media Pipelines Media Insights Pipeline Configuration.
 * Consult the [Call analytics developer guide](https://docs.aws.amazon.com/chime-sdk/latest/dg/call-analytics.html) for more detailed information about usage.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Stream(&#34;example&#34;, StreamArgs.builder()        
 *             .shardCount(2)
 *             .build());
 * 
 *         final var mediaPipelinesAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect(&#34;Allow&#34;)
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type(&#34;Service&#34;)
 *                     .identifiers(&#34;mediapipelines.chime.amazonaws.com&#34;)
 *                     .build())
 *                 .actions(&#34;sts:AssumeRole&#34;)
 *                 .build())
 *             .build());
 * 
 *         var callAnalyticsRole = new Role(&#34;callAnalyticsRole&#34;, RoleArgs.builder()        
 *             .assumeRolePolicy(mediaPipelinesAssumeRole.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json()))
 *             .build());
 * 
 *         var myConfiguration = new MediaInsightsPipelineConfiguration(&#34;myConfiguration&#34;, MediaInsightsPipelineConfigurationArgs.builder()        
 *             .resourceAccessRoleArn(callAnalyticsRole.arn())
 *             .elements(            
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type(&#34;AmazonTranscribeCallAnalyticsProcessor&#34;)
 *                     .amazonTranscribeCallAnalyticsProcessorConfiguration(MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs.builder()
 *                         .languageCode(&#34;en-US&#34;)
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type(&#34;KinesisDataStreamSink&#34;)
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(example.arn())
 *                         .build())
 *                     .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry(&#34;Key1&#34;, &#34;Value1&#34;),
 *                 Map.entry(&#34;Key2&#34;, &#34;Value2&#34;)
 *             ))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * - The required policies on `call_analytics_role` will vary based on the selected processors. See [Call analytics resource access role](https://docs.aws.amazon.com/chime-sdk/latest/dg/ca-resource-access-role.html) for directions on choosing appropriate policies.
 * ### Transcribe Call Analytics processor usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var transcribeAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect(&#34;Allow&#34;)
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type(&#34;Service&#34;)
 *                     .identifiers(&#34;transcribe.amazonaws.com&#34;)
 *                     .build())
 *                 .actions(&#34;sts:AssumeRole&#34;)
 *                 .build())
 *             .build());
 * 
 *         var postCallRole = new Role(&#34;postCallRole&#34;, RoleArgs.builder()        
 *             .assumeRolePolicy(transcribeAssumeRole.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json()))
 *             .build());
 * 
 *         var myConfiguration = new MediaInsightsPipelineConfiguration(&#34;myConfiguration&#34;, MediaInsightsPipelineConfigurationArgs.builder()        
 *             .resourceAccessRoleArn(aws_iam_role.example().arn())
 *             .elements(            
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type(&#34;AmazonTranscribeCallAnalyticsProcessor&#34;)
 *                     .amazonTranscribeCallAnalyticsProcessorConfiguration(MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs.builder()
 *                         .callAnalyticsStreamCategories(                        
 *                             &#34;category_1&#34;,
 *                             &#34;category_2&#34;)
 *                         .contentRedactionType(&#34;PII&#34;)
 *                         .enablePartialResultsStabilization(true)
 *                         .filterPartialResults(true)
 *                         .languageCode(&#34;en-US&#34;)
 *                         .languageModelName(&#34;MyLanguageModel&#34;)
 *                         .partialResultsStability(&#34;high&#34;)
 *                         .piiEntityTypes(&#34;ADDRESS,BANK_ACCOUNT_NUMBER&#34;)
 *                         .postCallAnalyticsSettings(MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationPostCallAnalyticsSettingsArgs.builder()
 *                             .contentRedactionOutput(&#34;redacted&#34;)
 *                             .dataAccessRoleArn(postCallRole.arn())
 *                             .outputEncryptionKmsKeyId(&#34;MyKmsKeyId&#34;)
 *                             .outputLocation(&#34;s3://MyBucket&#34;)
 *                             .build())
 *                         .vocabularyFilterMethod(&#34;mask&#34;)
 *                         .vocabularyFilterName(&#34;MyVocabularyFilter&#34;)
 *                         .vocabularyName(&#34;MyVocabulary&#34;)
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type(&#34;KinesisDataStreamSink&#34;)
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(aws_kinesis_stream.example().arn())
 *                         .build())
 *                     .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Real time alerts usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var myConfiguration = new MediaInsightsPipelineConfiguration(&#34;myConfiguration&#34;, MediaInsightsPipelineConfigurationArgs.builder()        
 *             .resourceAccessRoleArn(aws_iam_role.call_analytics_role().arn())
 *             .elements(            
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type(&#34;AmazonTranscribeCallAnalyticsProcessor&#34;)
 *                     .amazonTranscribeCallAnalyticsProcessorConfiguration(MediaInsightsPipelineConfigurationElementAmazonTranscribeCallAnalyticsProcessorConfigurationArgs.builder()
 *                         .languageCode(&#34;en-US&#34;)
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type(&#34;KinesisDataStreamSink&#34;)
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(aws_kinesis_stream.example().arn())
 *                         .build())
 *                     .build())
 *             .realTimeAlertConfiguration(MediaInsightsPipelineConfigurationRealTimeAlertConfigurationArgs.builder()
 *                 .disabled(false)
 *                 .rules(                
 *                     MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs.builder()
 *                         .type(&#34;IssueDetection&#34;)
 *                         .issueDetectionConfiguration(MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleIssueDetectionConfigurationArgs.builder()
 *                             .ruleName(&#34;MyIssueDetectionRule&#34;)
 *                             .build())
 *                         .build(),
 *                     MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs.builder()
 *                         .type(&#34;KeywordMatch&#34;)
 *                         .keywordMatchConfiguration(MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleKeywordMatchConfigurationArgs.builder()
 *                             .keywords(                            
 *                                 &#34;keyword1&#34;,
 *                                 &#34;keyword2&#34;)
 *                             .negate(false)
 *                             .ruleName(&#34;MyKeywordMatchRule&#34;)
 *                             .build())
 *                         .build(),
 *                     MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleArgs.builder()
 *                         .type(&#34;Sentiment&#34;)
 *                         .sentimentConfiguration(MediaInsightsPipelineConfigurationRealTimeAlertConfigurationRuleSentimentConfigurationArgs.builder()
 *                             .ruleName(&#34;MySentimentRule&#34;)
 *                             .sentimentType(&#34;NEGATIVE&#34;)
 *                             .timePeriod(60)
 *                             .build())
 *                         .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Transcribe processor usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var myConfiguration = new MediaInsightsPipelineConfiguration(&#34;myConfiguration&#34;, MediaInsightsPipelineConfigurationArgs.builder()        
 *             .resourceAccessRoleArn(aws_iam_role.example().arn())
 *             .elements(            
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type(&#34;AmazonTranscribeProcessor&#34;)
 *                     .amazonTranscribeProcessorConfiguration(MediaInsightsPipelineConfigurationElementAmazonTranscribeProcessorConfigurationArgs.builder()
 *                         .contentIdentificationType(&#34;PII&#34;)
 *                         .enablePartialResultsStabilization(true)
 *                         .filterPartialResults(true)
 *                         .languageCode(&#34;en-US&#34;)
 *                         .languageModelName(&#34;MyLanguageModel&#34;)
 *                         .partialResultsStability(&#34;high&#34;)
 *                         .piiEntityTypes(&#34;ADDRESS,BANK_ACCOUNT_NUMBER&#34;)
 *                         .showSpeakerLabel(true)
 *                         .vocabularyFilterMethod(&#34;mask&#34;)
 *                         .vocabularyFilterName(&#34;MyVocabularyFilter&#34;)
 *                         .vocabularyName(&#34;MyVocabulary&#34;)
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type(&#34;KinesisDataStreamSink&#34;)
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(aws_kinesis_stream.example().arn())
 *                         .build())
 *                     .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Voice analytics processor usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var myConfiguration = new MediaInsightsPipelineConfiguration(&#34;myConfiguration&#34;, MediaInsightsPipelineConfigurationArgs.builder()        
 *             .resourceAccessRoleArn(aws_iam_role.example().arn())
 *             .elements(            
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type(&#34;VoiceAnalyticsProcessor&#34;)
 *                     .voiceAnalyticsProcessorConfiguration(MediaInsightsPipelineConfigurationElementVoiceAnalyticsProcessorConfigurationArgs.builder()
 *                         .speakerSearchStatus(&#34;Enabled&#34;)
 *                         .voiceToneAnalysisStatus(&#34;Enabled&#34;)
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type(&#34;LambdaFunctionSink&#34;)
 *                     .lambdaFunctionSinkConfiguration(MediaInsightsPipelineConfigurationElementLambdaFunctionSinkConfigurationArgs.builder()
 *                         .insightsTarget(&#34;arn:aws:lambda:us-west-2:1111111111:function:MyFunction&#34;)
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type(&#34;SnsTopicSink&#34;)
 *                     .snsTopicSinkConfiguration(MediaInsightsPipelineConfigurationElementSnsTopicSinkConfigurationArgs.builder()
 *                         .insightsTarget(&#34;arn:aws:sns:us-west-2:1111111111:topic/MyTopic&#34;)
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type(&#34;SqsQueueSink&#34;)
 *                     .sqsQueueSinkConfiguration(MediaInsightsPipelineConfigurationElementSqsQueueSinkConfigurationArgs.builder()
 *                         .insightsTarget(&#34;arn:aws:sqs:us-west-2:1111111111:queue/MyQueue&#34;)
 *                         .build())
 *                     .build(),
 *                 MediaInsightsPipelineConfigurationElementArgs.builder()
 *                     .type(&#34;KinesisDataStreamSink&#34;)
 *                     .kinesisDataStreamSinkConfiguration(MediaInsightsPipelineConfigurationElementKinesisDataStreamSinkConfigurationArgs.builder()
 *                         .insightsTarget(aws_kinesis_stream.test().arn())
 *                         .build())
 *                     .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### S3 Recording sink usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfiguration;
 * import com.pulumi.aws.chimesdkmediapipelines.MediaInsightsPipelineConfigurationArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementArgs;
 * import com.pulumi.aws.chimesdkmediapipelines.inputs.MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var myConfiguration = new MediaInsightsPipelineConfiguration(&#34;myConfiguration&#34;, MediaInsightsPipelineConfigurationArgs.builder()        
 *             .resourceAccessRoleArn(aws_iam_role.example().arn())
 *             .elements(MediaInsightsPipelineConfigurationElementArgs.builder()
 *                 .type(&#34;S3RecordingSink&#34;)
 *                 .s3RecordingSinkConfiguration(MediaInsightsPipelineConfigurationElementS3RecordingSinkConfigurationArgs.builder()
 *                     .destination(&#34;arn:aws:s3:::MyBucket&#34;)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Chime SDK Media Pipelines Media Insights Pipeline Configuration using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:chimesdkmediapipelines/mediaInsightsPipelineConfiguration:MediaInsightsPipelineConfiguration example abcdef123456
 * ```
 * 
 */
@ResourceType(type="aws:chimesdkmediapipelines/mediaInsightsPipelineConfiguration:MediaInsightsPipelineConfiguration")
public class MediaInsightsPipelineConfiguration extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the Media Insights Pipeline Configuration.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the Media Insights Pipeline Configuration.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Collection of processors and sinks to transform media and deliver data.
     * 
     */
    @Export(name="elements", refs={List.class,MediaInsightsPipelineConfigurationElement.class}, tree="[0,1]")
    private Output<List<MediaInsightsPipelineConfigurationElement>> elements;

    /**
     * @return Collection of processors and sinks to transform media and deliver data.
     * 
     */
    public Output<List<MediaInsightsPipelineConfigurationElement>> elements() {
        return this.elements;
    }
    /**
     * Configuration name.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Configuration name.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Configuration for real-time alert rules to send EventBridge notifications when certain conditions are met.
     * 
     */
    @Export(name="realTimeAlertConfiguration", refs={MediaInsightsPipelineConfigurationRealTimeAlertConfiguration.class}, tree="[0]")
    private Output</* @Nullable */ MediaInsightsPipelineConfigurationRealTimeAlertConfiguration> realTimeAlertConfiguration;

    /**
     * @return Configuration for real-time alert rules to send EventBridge notifications when certain conditions are met.
     * 
     */
    public Output<Optional<MediaInsightsPipelineConfigurationRealTimeAlertConfiguration>> realTimeAlertConfiguration() {
        return Codegen.optional(this.realTimeAlertConfiguration);
    }
    /**
     * ARN of IAM Role used by service to invoke processors and sinks specified by configuration elements.
     * 
     */
    @Export(name="resourceAccessRoleArn", refs={String.class}, tree="[0]")
    private Output<String> resourceAccessRoleArn;

    /**
     * @return ARN of IAM Role used by service to invoke processors and sinks specified by configuration elements.
     * 
     */
    public Output<String> resourceAccessRoleArn() {
        return this.resourceAccessRoleArn;
    }
    /**
     * Key-value map of tags for the resource.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of tags for the resource.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public MediaInsightsPipelineConfiguration(String name) {
        this(name, MediaInsightsPipelineConfigurationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public MediaInsightsPipelineConfiguration(String name, MediaInsightsPipelineConfigurationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public MediaInsightsPipelineConfiguration(String name, MediaInsightsPipelineConfigurationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:chimesdkmediapipelines/mediaInsightsPipelineConfiguration:MediaInsightsPipelineConfiguration", name, args == null ? MediaInsightsPipelineConfigurationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private MediaInsightsPipelineConfiguration(String name, Output<String> id, @Nullable MediaInsightsPipelineConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:chimesdkmediapipelines/mediaInsightsPipelineConfiguration:MediaInsightsPipelineConfiguration", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static MediaInsightsPipelineConfiguration get(String name, Output<String> id, @Nullable MediaInsightsPipelineConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new MediaInsightsPipelineConfiguration(name, id, state, options);
    }
}
