// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.chime.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class VoiceConnectorOrganizationRouteArgs extends com.pulumi.resources.ResourceArgs {

    public static final VoiceConnectorOrganizationRouteArgs Empty = new VoiceConnectorOrganizationRouteArgs();

    /**
     * The FQDN or IP address to contact for origination traffic.
     * 
     */
    @Import(name="host", required=true)
    private Output<String> host;

    /**
     * @return The FQDN or IP address to contact for origination traffic.
     * 
     */
    public Output<String> host() {
        return this.host;
    }

    /**
     * The designated origination route port. Defaults to `5060`.
     * 
     */
    @Import(name="port")
    private @Nullable Output<Integer> port;

    /**
     * @return The designated origination route port. Defaults to `5060`.
     * 
     */
    public Optional<Output<Integer>> port() {
        return Optional.ofNullable(this.port);
    }

    /**
     * The priority associated with the host, with 1 being the highest priority. Higher priority hosts are attempted first.
     * 
     */
    @Import(name="priority", required=true)
    private Output<Integer> priority;

    /**
     * @return The priority associated with the host, with 1 being the highest priority. Higher priority hosts are attempted first.
     * 
     */
    public Output<Integer> priority() {
        return this.priority;
    }

    /**
     * The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.
     * 
     */
    @Import(name="protocol", required=true)
    private Output<String> protocol;

    /**
     * @return The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.
     * 
     */
    public Output<String> protocol() {
        return this.protocol;
    }

    /**
     * The weight associated with the host. If hosts are equal in priority, calls are redistributed among them based on their relative weight.
     * 
     */
    @Import(name="weight", required=true)
    private Output<Integer> weight;

    /**
     * @return The weight associated with the host. If hosts are equal in priority, calls are redistributed among them based on their relative weight.
     * 
     */
    public Output<Integer> weight() {
        return this.weight;
    }

    private VoiceConnectorOrganizationRouteArgs() {}

    private VoiceConnectorOrganizationRouteArgs(VoiceConnectorOrganizationRouteArgs $) {
        this.host = $.host;
        this.port = $.port;
        this.priority = $.priority;
        this.protocol = $.protocol;
        this.weight = $.weight;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(VoiceConnectorOrganizationRouteArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private VoiceConnectorOrganizationRouteArgs $;

        public Builder() {
            $ = new VoiceConnectorOrganizationRouteArgs();
        }

        public Builder(VoiceConnectorOrganizationRouteArgs defaults) {
            $ = new VoiceConnectorOrganizationRouteArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param host The FQDN or IP address to contact for origination traffic.
         * 
         * @return builder
         * 
         */
        public Builder host(Output<String> host) {
            $.host = host;
            return this;
        }

        /**
         * @param host The FQDN or IP address to contact for origination traffic.
         * 
         * @return builder
         * 
         */
        public Builder host(String host) {
            return host(Output.of(host));
        }

        /**
         * @param port The designated origination route port. Defaults to `5060`.
         * 
         * @return builder
         * 
         */
        public Builder port(@Nullable Output<Integer> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port The designated origination route port. Defaults to `5060`.
         * 
         * @return builder
         * 
         */
        public Builder port(Integer port) {
            return port(Output.of(port));
        }

        /**
         * @param priority The priority associated with the host, with 1 being the highest priority. Higher priority hosts are attempted first.
         * 
         * @return builder
         * 
         */
        public Builder priority(Output<Integer> priority) {
            $.priority = priority;
            return this;
        }

        /**
         * @param priority The priority associated with the host, with 1 being the highest priority. Higher priority hosts are attempted first.
         * 
         * @return builder
         * 
         */
        public Builder priority(Integer priority) {
            return priority(Output.of(priority));
        }

        /**
         * @param protocol The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.
         * 
         * @return builder
         * 
         */
        public Builder protocol(Output<String> protocol) {
            $.protocol = protocol;
            return this;
        }

        /**
         * @param protocol The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.
         * 
         * @return builder
         * 
         */
        public Builder protocol(String protocol) {
            return protocol(Output.of(protocol));
        }

        /**
         * @param weight The weight associated with the host. If hosts are equal in priority, calls are redistributed among them based on their relative weight.
         * 
         * @return builder
         * 
         */
        public Builder weight(Output<Integer> weight) {
            $.weight = weight;
            return this;
        }

        /**
         * @param weight The weight associated with the host. If hosts are equal in priority, calls are redistributed among them based on their relative weight.
         * 
         * @return builder
         * 
         */
        public Builder weight(Integer weight) {
            return weight(Output.of(weight));
        }

        public VoiceConnectorOrganizationRouteArgs build() {
            $.host = Objects.requireNonNull($.host, "expected parameter 'host' to be non-null");
            $.priority = Objects.requireNonNull($.priority, "expected parameter 'priority' to be non-null");
            $.protocol = Objects.requireNonNull($.protocol, "expected parameter 'protocol' to be non-null");
            $.weight = Objects.requireNonNull($.weight, "expected parameter 'weight' to be non-null");
            return $;
        }
    }

}
