// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.chime;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.chime.VoiceConnectorTerminationCredentialsArgs;
import com.pulumi.aws.chime.inputs.VoiceConnectorTerminationCredentialsState;
import com.pulumi.aws.chime.outputs.VoiceConnectorTerminationCredentialsCredential;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import javax.annotation.Nullable;

/**
 * Adds termination SIP credentials for the specified Amazon Chime Voice Connector.
 * 
 * &gt; **Note:** Voice Connector Termination Credentials requires a Voice Connector Termination to be present. Use of `depends_on` (as shown below) is recommended to avoid race conditions.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorTermination;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationArgs;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationCredentials;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationCredentialsArgs;
 * import com.pulumi.aws.chime.inputs.VoiceConnectorTerminationCredentialsCredentialArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var defaultVoiceConnector = new VoiceConnector(&#34;defaultVoiceConnector&#34;, VoiceConnectorArgs.builder()        
 *             .requireEncryption(true)
 *             .build());
 * 
 *         var defaultVoiceConnectorTermination = new VoiceConnectorTermination(&#34;defaultVoiceConnectorTermination&#34;, VoiceConnectorTerminationArgs.builder()        
 *             .disabled(true)
 *             .cpsLimit(1)
 *             .cidrAllowLists(&#34;50.35.78.96/31&#34;)
 *             .callingRegions(            
 *                 &#34;US&#34;,
 *                 &#34;CA&#34;)
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .build());
 * 
 *         var defaultVoiceConnectorTerminationCredentials = new VoiceConnectorTerminationCredentials(&#34;defaultVoiceConnectorTerminationCredentials&#34;, VoiceConnectorTerminationCredentialsArgs.builder()        
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .credentials(VoiceConnectorTerminationCredentialsCredentialArgs.builder()
 *                 .username(&#34;test&#34;)
 *                 .password(&#34;test!&#34;)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(defaultVoiceConnectorTermination)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Chime Voice Connector Termination Credentials using the `voice_connector_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorTerminationCredentials:VoiceConnectorTerminationCredentials default abcdef1ghij2klmno3pqr4
 * ```
 * 
 */
@ResourceType(type="aws:chime/voiceConnectorTerminationCredentials:VoiceConnectorTerminationCredentials")
public class VoiceConnectorTerminationCredentials extends com.pulumi.resources.CustomResource {
    /**
     * List of termination SIP credentials.
     * 
     */
    @Export(name="credentials", refs={List.class,VoiceConnectorTerminationCredentialsCredential.class}, tree="[0,1]")
    private Output<List<VoiceConnectorTerminationCredentialsCredential>> credentials;

    /**
     * @return List of termination SIP credentials.
     * 
     */
    public Output<List<VoiceConnectorTerminationCredentialsCredential>> credentials() {
        return this.credentials;
    }
    /**
     * Amazon Chime Voice Connector ID.
     * 
     */
    @Export(name="voiceConnectorId", refs={String.class}, tree="[0]")
    private Output<String> voiceConnectorId;

    /**
     * @return Amazon Chime Voice Connector ID.
     * 
     */
    public Output<String> voiceConnectorId() {
        return this.voiceConnectorId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public VoiceConnectorTerminationCredentials(String name) {
        this(name, VoiceConnectorTerminationCredentialsArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public VoiceConnectorTerminationCredentials(String name, VoiceConnectorTerminationCredentialsArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public VoiceConnectorTerminationCredentials(String name, VoiceConnectorTerminationCredentialsArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:chime/voiceConnectorTerminationCredentials:VoiceConnectorTerminationCredentials", name, args == null ? VoiceConnectorTerminationCredentialsArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private VoiceConnectorTerminationCredentials(String name, Output<String> id, @Nullable VoiceConnectorTerminationCredentialsState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:chime/voiceConnectorTerminationCredentials:VoiceConnectorTerminationCredentials", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static VoiceConnectorTerminationCredentials get(String name, Output<String> id, @Nullable VoiceConnectorTerminationCredentialsState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new VoiceConnectorTerminationCredentials(name, id, state, options);
    }
}
