// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.chime;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.chime.VoiceConnectorTerminationArgs;
import com.pulumi.aws.chime.inputs.VoiceConnectorTerminationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Enable Termination settings to control outbound calling from your SIP infrastructure.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorTermination;
 * import com.pulumi.aws.chime.VoiceConnectorTerminationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var defaultVoiceConnector = new VoiceConnector(&#34;defaultVoiceConnector&#34;, VoiceConnectorArgs.builder()        
 *             .requireEncryption(true)
 *             .build());
 * 
 *         var defaultVoiceConnectorTermination = new VoiceConnectorTermination(&#34;defaultVoiceConnectorTermination&#34;, VoiceConnectorTerminationArgs.builder()        
 *             .disabled(false)
 *             .cpsLimit(1)
 *             .cidrAllowLists(&#34;50.35.78.96/31&#34;)
 *             .callingRegions(            
 *                 &#34;US&#34;,
 *                 &#34;CA&#34;)
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Chime Voice Connector Termination using the `voice_connector_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorTermination:VoiceConnectorTermination default abcdef1ghij2klmno3pqr4
 * ```
 * 
 */
@ResourceType(type="aws:chime/voiceConnectorTermination:VoiceConnectorTermination")
public class VoiceConnectorTermination extends com.pulumi.resources.CustomResource {
    /**
     * The countries to which calls are allowed, in ISO 3166-1 alpha-2 format.
     * 
     */
    @Export(name="callingRegions", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> callingRegions;

    /**
     * @return The countries to which calls are allowed, in ISO 3166-1 alpha-2 format.
     * 
     */
    public Output<List<String>> callingRegions() {
        return this.callingRegions;
    }
    /**
     * The IP addresses allowed to make calls, in CIDR format.
     * 
     */
    @Export(name="cidrAllowLists", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> cidrAllowLists;

    /**
     * @return The IP addresses allowed to make calls, in CIDR format.
     * 
     */
    public Output<List<String>> cidrAllowLists() {
        return this.cidrAllowLists;
    }
    /**
     * The limit on calls per second. Max value based on account service quota. Default value of `1`.
     * 
     */
    @Export(name="cpsLimit", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> cpsLimit;

    /**
     * @return The limit on calls per second. Max value based on account service quota. Default value of `1`.
     * 
     */
    public Output<Optional<Integer>> cpsLimit() {
        return Codegen.optional(this.cpsLimit);
    }
    /**
     * The default caller ID phone number.
     * 
     */
    @Export(name="defaultPhoneNumber", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> defaultPhoneNumber;

    /**
     * @return The default caller ID phone number.
     * 
     */
    public Output<Optional<String>> defaultPhoneNumber() {
        return Codegen.optional(this.defaultPhoneNumber);
    }
    /**
     * When termination settings are disabled, outbound calls can not be made.
     * 
     */
    @Export(name="disabled", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> disabled;

    /**
     * @return When termination settings are disabled, outbound calls can not be made.
     * 
     */
    public Output<Optional<Boolean>> disabled() {
        return Codegen.optional(this.disabled);
    }
    /**
     * The Amazon Chime Voice Connector ID.
     * 
     */
    @Export(name="voiceConnectorId", refs={String.class}, tree="[0]")
    private Output<String> voiceConnectorId;

    /**
     * @return The Amazon Chime Voice Connector ID.
     * 
     */
    public Output<String> voiceConnectorId() {
        return this.voiceConnectorId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public VoiceConnectorTermination(String name) {
        this(name, VoiceConnectorTerminationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public VoiceConnectorTermination(String name, VoiceConnectorTerminationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public VoiceConnectorTermination(String name, VoiceConnectorTerminationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:chime/voiceConnectorTermination:VoiceConnectorTermination", name, args == null ? VoiceConnectorTerminationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private VoiceConnectorTermination(String name, Output<String> id, @Nullable VoiceConnectorTerminationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:chime/voiceConnectorTermination:VoiceConnectorTermination", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static VoiceConnectorTermination get(String name, Output<String> id, @Nullable VoiceConnectorTerminationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new VoiceConnectorTermination(name, id, state, options);
    }
}
