// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.chime;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.chime.VoiceConnectorOrganizationArgs;
import com.pulumi.aws.chime.inputs.VoiceConnectorOrganizationState;
import com.pulumi.aws.chime.outputs.VoiceConnectorOrganizationRoute;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Enable origination settings to control inbound calling to your SIP infrastructure.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorOrganization;
 * import com.pulumi.aws.chime.VoiceConnectorOrganizationArgs;
 * import com.pulumi.aws.chime.inputs.VoiceConnectorOrganizationRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var defaultVoiceConnector = new VoiceConnector(&#34;defaultVoiceConnector&#34;, VoiceConnectorArgs.builder()        
 *             .requireEncryption(true)
 *             .build());
 * 
 *         var defaultVoiceConnectorOrganization = new VoiceConnectorOrganization(&#34;defaultVoiceConnectorOrganization&#34;, VoiceConnectorOrganizationArgs.builder()        
 *             .disabled(false)
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .routes(            
 *                 VoiceConnectorOrganizationRouteArgs.builder()
 *                     .host(&#34;127.0.0.1&#34;)
 *                     .port(8081)
 *                     .protocol(&#34;TCP&#34;)
 *                     .priority(1)
 *                     .weight(1)
 *                     .build(),
 *                 VoiceConnectorOrganizationRouteArgs.builder()
 *                     .host(&#34;127.0.0.2&#34;)
 *                     .port(8082)
 *                     .protocol(&#34;TCP&#34;)
 *                     .priority(2)
 *                     .weight(10)
 *                     .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Chime Voice Connector Origination using the `voice_connector_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorOrganization:VoiceConnectorOrganization default abcdef1ghij2klmno3pqr4
 * ```
 * 
 */
@ResourceType(type="aws:chime/voiceConnectorOrganization:VoiceConnectorOrganization")
public class VoiceConnectorOrganization extends com.pulumi.resources.CustomResource {
    /**
     * When origination settings are disabled, inbound calls are not enabled for your Amazon Chime Voice Connector.
     * 
     */
    @Export(name="disabled", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> disabled;

    /**
     * @return When origination settings are disabled, inbound calls are not enabled for your Amazon Chime Voice Connector.
     * 
     */
    public Output<Optional<Boolean>> disabled() {
        return Codegen.optional(this.disabled);
    }
    /**
     * Set of call distribution properties defined for your SIP hosts. See route below for more details. Minimum of 1. Maximum of 20.
     * 
     */
    @Export(name="routes", refs={List.class,VoiceConnectorOrganizationRoute.class}, tree="[0,1]")
    private Output<List<VoiceConnectorOrganizationRoute>> routes;

    /**
     * @return Set of call distribution properties defined for your SIP hosts. See route below for more details. Minimum of 1. Maximum of 20.
     * 
     */
    public Output<List<VoiceConnectorOrganizationRoute>> routes() {
        return this.routes;
    }
    /**
     * The Amazon Chime Voice Connector ID.
     * 
     */
    @Export(name="voiceConnectorId", refs={String.class}, tree="[0]")
    private Output<String> voiceConnectorId;

    /**
     * @return The Amazon Chime Voice Connector ID.
     * 
     */
    public Output<String> voiceConnectorId() {
        return this.voiceConnectorId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public VoiceConnectorOrganization(String name) {
        this(name, VoiceConnectorOrganizationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public VoiceConnectorOrganization(String name, VoiceConnectorOrganizationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public VoiceConnectorOrganization(String name, VoiceConnectorOrganizationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:chime/voiceConnectorOrganization:VoiceConnectorOrganization", name, args == null ? VoiceConnectorOrganizationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private VoiceConnectorOrganization(String name, Output<String> id, @Nullable VoiceConnectorOrganizationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:chime/voiceConnectorOrganization:VoiceConnectorOrganization", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static VoiceConnectorOrganization get(String name, Output<String> id, @Nullable VoiceConnectorOrganizationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new VoiceConnectorOrganization(name, id, state, options);
    }
}
