// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.chime;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.chime.VoiceConnectorLoggingArgs;
import com.pulumi.aws.chime.inputs.VoiceConnectorLoggingState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorLogging;
 * import com.pulumi.aws.chime.VoiceConnectorLoggingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var defaultVoiceConnector = new VoiceConnector(&#34;defaultVoiceConnector&#34;, VoiceConnectorArgs.builder()        
 *             .requireEncryption(true)
 *             .build());
 * 
 *         var defaultVoiceConnectorLogging = new VoiceConnectorLogging(&#34;defaultVoiceConnectorLogging&#34;, VoiceConnectorLoggingArgs.builder()        
 *             .enableSipLogs(true)
 *             .enableMediaMetricLogs(true)
 *             .voiceConnectorId(defaultVoiceConnector.id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Chime Voice Connector Logging using the `voice_connector_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorLogging:VoiceConnectorLogging default abcdef1ghij2klmno3pqr4
 * ```
 * 
 */
@ResourceType(type="aws:chime/voiceConnectorLogging:VoiceConnectorLogging")
public class VoiceConnectorLogging extends com.pulumi.resources.CustomResource {
    /**
     * When true, enables logging of detailed media metrics for Voice Connectors to Amazon CloudWatch logs.
     * 
     */
    @Export(name="enableMediaMetricLogs", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> enableMediaMetricLogs;

    /**
     * @return When true, enables logging of detailed media metrics for Voice Connectors to Amazon CloudWatch logs.
     * 
     */
    public Output<Optional<Boolean>> enableMediaMetricLogs() {
        return Codegen.optional(this.enableMediaMetricLogs);
    }
    /**
     * When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
     * 
     */
    @Export(name="enableSipLogs", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> enableSipLogs;

    /**
     * @return When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
     * 
     */
    public Output<Optional<Boolean>> enableSipLogs() {
        return Codegen.optional(this.enableSipLogs);
    }
    /**
     * The Amazon Chime Voice Connector ID.
     * 
     */
    @Export(name="voiceConnectorId", refs={String.class}, tree="[0]")
    private Output<String> voiceConnectorId;

    /**
     * @return The Amazon Chime Voice Connector ID.
     * 
     */
    public Output<String> voiceConnectorId() {
        return this.voiceConnectorId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public VoiceConnectorLogging(String name) {
        this(name, VoiceConnectorLoggingArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public VoiceConnectorLogging(String name, VoiceConnectorLoggingArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public VoiceConnectorLogging(String name, VoiceConnectorLoggingArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:chime/voiceConnectorLogging:VoiceConnectorLogging", name, args == null ? VoiceConnectorLoggingArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private VoiceConnectorLogging(String name, Output<String> id, @Nullable VoiceConnectorLoggingState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:chime/voiceConnectorLogging:VoiceConnectorLogging", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static VoiceConnectorLogging get(String name, Output<String> id, @Nullable VoiceConnectorLoggingState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new VoiceConnectorLogging(name, id, state, options);
    }
}
