// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.chime;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.chime.VoiceConnectorGroupArgs;
import com.pulumi.aws.chime.inputs.VoiceConnectorGroupState;
import com.pulumi.aws.chime.outputs.VoiceConnectorGroupConnector;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Creates an Amazon Chime Voice Connector group under the administrator&#39;s AWS account. You can associate Amazon Chime Voice Connectors with the Amazon Chime Voice Connector group by including VoiceConnectorItems in the request.
 * 
 * You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault tolerant mechanism for fallback in case of availability events.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.chime.VoiceConnector;
 * import com.pulumi.aws.chime.VoiceConnectorArgs;
 * import com.pulumi.aws.chime.VoiceConnectorGroup;
 * import com.pulumi.aws.chime.VoiceConnectorGroupArgs;
 * import com.pulumi.aws.chime.inputs.VoiceConnectorGroupConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var vc1 = new VoiceConnector(&#34;vc1&#34;, VoiceConnectorArgs.builder()        
 *             .requireEncryption(true)
 *             .awsRegion(&#34;us-east-1&#34;)
 *             .build());
 * 
 *         var vc2 = new VoiceConnector(&#34;vc2&#34;, VoiceConnectorArgs.builder()        
 *             .requireEncryption(true)
 *             .awsRegion(&#34;us-west-2&#34;)
 *             .build());
 * 
 *         var group = new VoiceConnectorGroup(&#34;group&#34;, VoiceConnectorGroupArgs.builder()        
 *             .connectors(            
 *                 VoiceConnectorGroupConnectorArgs.builder()
 *                     .voiceConnectorId(vc1.id())
 *                     .priority(1)
 *                     .build(),
 *                 VoiceConnectorGroupConnectorArgs.builder()
 *                     .voiceConnectorId(vc2.id())
 *                     .priority(3)
 *                     .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Configuration Recorder using the name. For example:
 * 
 * ```sh
 *  $ pulumi import aws:chime/voiceConnectorGroup:VoiceConnectorGroup default example
 * ```
 * 
 */
@ResourceType(type="aws:chime/voiceConnectorGroup:VoiceConnectorGroup")
public class VoiceConnectorGroup extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Chime Voice Connectors to route inbound calls to.
     * 
     */
    @Export(name="connectors", refs={List.class,VoiceConnectorGroupConnector.class}, tree="[0,1]")
    private Output</* @Nullable */ List<VoiceConnectorGroupConnector>> connectors;

    /**
     * @return The Amazon Chime Voice Connectors to route inbound calls to.
     * 
     */
    public Output<Optional<List<VoiceConnectorGroupConnector>>> connectors() {
        return Codegen.optional(this.connectors);
    }
    /**
     * The name of the Amazon Chime Voice Connector group.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the Amazon Chime Voice Connector group.
     * 
     */
    public Output<String> name() {
        return this.name;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public VoiceConnectorGroup(String name) {
        this(name, VoiceConnectorGroupArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public VoiceConnectorGroup(String name, @Nullable VoiceConnectorGroupArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public VoiceConnectorGroup(String name, @Nullable VoiceConnectorGroupArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:chime/voiceConnectorGroup:VoiceConnectorGroup", name, args == null ? VoiceConnectorGroupArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private VoiceConnectorGroup(String name, Output<String> id, @Nullable VoiceConnectorGroupState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:chime/voiceConnectorGroup:VoiceConnectorGroup", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static VoiceConnectorGroup get(String name, Output<String> id, @Nullable VoiceConnectorGroupState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new VoiceConnectorGroup(name, id, state, options);
    }
}
