// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cfg;

import com.pulumi.aws.cfg.inputs.RuleScopeArgs;
import com.pulumi.aws.cfg.inputs.RuleSourceArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class RuleArgs extends com.pulumi.resources.ResourceArgs {

    public static final RuleArgs Empty = new RuleArgs();

    /**
     * Description of the rule
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Description of the rule
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * A string in JSON format that is passed to the AWS Config rule Lambda function.
     * 
     */
    @Import(name="inputParameters")
    private @Nullable Output<String> inputParameters;

    /**
     * @return A string in JSON format that is passed to the AWS Config rule Lambda function.
     * 
     */
    public Optional<Output<String>> inputParameters() {
        return Optional.ofNullable(this.inputParameters);
    }

    /**
     * The maximum frequency with which AWS Config runs evaluations for a rule.
     * 
     */
    @Import(name="maximumExecutionFrequency")
    private @Nullable Output<String> maximumExecutionFrequency;

    /**
     * @return The maximum frequency with which AWS Config runs evaluations for a rule.
     * 
     */
    public Optional<Output<String>> maximumExecutionFrequency() {
        return Optional.ofNullable(this.maximumExecutionFrequency);
    }

    /**
     * The name of the rule
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the rule
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Scope defines which resources can trigger an evaluation for the rule. See Source Below.
     * 
     */
    @Import(name="scope")
    private @Nullable Output<RuleScopeArgs> scope;

    /**
     * @return Scope defines which resources can trigger an evaluation for the rule. See Source Below.
     * 
     */
    public Optional<Output<RuleScopeArgs>> scope() {
        return Optional.ofNullable(this.scope);
    }

    /**
     * Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Scope Below.
     * 
     */
    @Import(name="source", required=true)
    private Output<RuleSourceArgs> source;

    /**
     * @return Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Scope Below.
     * 
     */
    public Output<RuleSourceArgs> source() {
        return this.source;
    }

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private RuleArgs() {}

    private RuleArgs(RuleArgs $) {
        this.description = $.description;
        this.inputParameters = $.inputParameters;
        this.maximumExecutionFrequency = $.maximumExecutionFrequency;
        this.name = $.name;
        this.scope = $.scope;
        this.source = $.source;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(RuleArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private RuleArgs $;

        public Builder() {
            $ = new RuleArgs();
        }

        public Builder(RuleArgs defaults) {
            $ = new RuleArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param description Description of the rule
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Description of the rule
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param inputParameters A string in JSON format that is passed to the AWS Config rule Lambda function.
         * 
         * @return builder
         * 
         */
        public Builder inputParameters(@Nullable Output<String> inputParameters) {
            $.inputParameters = inputParameters;
            return this;
        }

        /**
         * @param inputParameters A string in JSON format that is passed to the AWS Config rule Lambda function.
         * 
         * @return builder
         * 
         */
        public Builder inputParameters(String inputParameters) {
            return inputParameters(Output.of(inputParameters));
        }

        /**
         * @param maximumExecutionFrequency The maximum frequency with which AWS Config runs evaluations for a rule.
         * 
         * @return builder
         * 
         */
        public Builder maximumExecutionFrequency(@Nullable Output<String> maximumExecutionFrequency) {
            $.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        /**
         * @param maximumExecutionFrequency The maximum frequency with which AWS Config runs evaluations for a rule.
         * 
         * @return builder
         * 
         */
        public Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            return maximumExecutionFrequency(Output.of(maximumExecutionFrequency));
        }

        /**
         * @param name The name of the rule
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the rule
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param scope Scope defines which resources can trigger an evaluation for the rule. See Source Below.
         * 
         * @return builder
         * 
         */
        public Builder scope(@Nullable Output<RuleScopeArgs> scope) {
            $.scope = scope;
            return this;
        }

        /**
         * @param scope Scope defines which resources can trigger an evaluation for the rule. See Source Below.
         * 
         * @return builder
         * 
         */
        public Builder scope(RuleScopeArgs scope) {
            return scope(Output.of(scope));
        }

        /**
         * @param source Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Scope Below.
         * 
         * @return builder
         * 
         */
        public Builder source(Output<RuleSourceArgs> source) {
            $.source = source;
            return this;
        }

        /**
         * @param source Source specifies the rule owner, the rule identifier, and the notifications that cause the function to evaluate your AWS resources. See Scope Below.
         * 
         * @return builder
         * 
         */
        public Builder source(RuleSourceArgs source) {
            return source(Output.of(source));
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public RuleArgs build() {
            $.source = Objects.requireNonNull($.source, "expected parameter 'source' to be non-null");
            return $;
        }
    }

}
