// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cfg;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.cfg.RemediationConfigurationArgs;
import com.pulumi.aws.cfg.inputs.RemediationConfigurationState;
import com.pulumi.aws.cfg.outputs.RemediationConfigurationExecutionControls;
import com.pulumi.aws.cfg.outputs.RemediationConfigurationParameter;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an AWS Config Remediation Configuration.
 * 
 * &gt; **Note:** Config Remediation Configuration requires an existing Config Rule to be present.
 * 
 * ## Example Usage
 * 
 * AWS managed rules can be used by setting the source owner to `AWS` and the source identifier to the name of the managed rule. More information about AWS managed rules can be found in the [AWS Config Developer Guide](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cfg.Rule;
 * import com.pulumi.aws.cfg.RuleArgs;
 * import com.pulumi.aws.cfg.inputs.RuleSourceArgs;
 * import com.pulumi.aws.cfg.RemediationConfiguration;
 * import com.pulumi.aws.cfg.RemediationConfigurationArgs;
 * import com.pulumi.aws.cfg.inputs.RemediationConfigurationParameterArgs;
 * import com.pulumi.aws.cfg.inputs.RemediationConfigurationExecutionControlsArgs;
 * import com.pulumi.aws.cfg.inputs.RemediationConfigurationExecutionControlsSsmControlsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var thisRule = new Rule(&#34;thisRule&#34;, RuleArgs.builder()        
 *             .source(RuleSourceArgs.builder()
 *                 .owner(&#34;AWS&#34;)
 *                 .sourceIdentifier(&#34;S3_BUCKET_VERSIONING_ENABLED&#34;)
 *                 .build())
 *             .build());
 * 
 *         var thisRemediationConfiguration = new RemediationConfiguration(&#34;thisRemediationConfiguration&#34;, RemediationConfigurationArgs.builder()        
 *             .configRuleName(thisRule.name())
 *             .resourceType(&#34;AWS::S3::Bucket&#34;)
 *             .targetType(&#34;SSM_DOCUMENT&#34;)
 *             .targetId(&#34;AWS-EnableS3BucketEncryption&#34;)
 *             .targetVersion(&#34;1&#34;)
 *             .parameters(            
 *                 RemediationConfigurationParameterArgs.builder()
 *                     .name(&#34;AutomationAssumeRole&#34;)
 *                     .staticValue(&#34;arn:aws:iam::875924563244:role/security_config&#34;)
 *                     .build(),
 *                 RemediationConfigurationParameterArgs.builder()
 *                     .name(&#34;BucketName&#34;)
 *                     .resourceValue(&#34;RESOURCE_ID&#34;)
 *                     .build(),
 *                 RemediationConfigurationParameterArgs.builder()
 *                     .name(&#34;SSEAlgorithm&#34;)
 *                     .staticValue(&#34;AES256&#34;)
 *                     .build())
 *             .automatic(true)
 *             .maximumAutomaticAttempts(10)
 *             .retryAttemptSeconds(600)
 *             .executionControls(RemediationConfigurationExecutionControlsArgs.builder()
 *                 .ssmControls(RemediationConfigurationExecutionControlsSsmControlsArgs.builder()
 *                     .concurrentExecutionRatePercentage(25)
 *                     .errorPercentage(20)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Remediation Configurations using the name config_rule_name. For example:
 * 
 * ```sh
 *  $ pulumi import aws:cfg/remediationConfiguration:RemediationConfiguration this example
 * ```
 * 
 */
@ResourceType(type="aws:cfg/remediationConfiguration:RemediationConfiguration")
public class RemediationConfiguration extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the Config Remediation Configuration.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the Config Remediation Configuration.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Remediation is triggered automatically if `true`.
     * 
     */
    @Export(name="automatic", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> automatic;

    /**
     * @return Remediation is triggered automatically if `true`.
     * 
     */
    public Output<Optional<Boolean>> automatic() {
        return Codegen.optional(this.automatic);
    }
    /**
     * Name of the AWS Config rule.
     * 
     */
    @Export(name="configRuleName", refs={String.class}, tree="[0]")
    private Output<String> configRuleName;

    /**
     * @return Name of the AWS Config rule.
     * 
     */
    public Output<String> configRuleName() {
        return this.configRuleName;
    }
    /**
     * Configuration block for execution controls. See below.
     * 
     */
    @Export(name="executionControls", refs={RemediationConfigurationExecutionControls.class}, tree="[0]")
    private Output</* @Nullable */ RemediationConfigurationExecutionControls> executionControls;

    /**
     * @return Configuration block for execution controls. See below.
     * 
     */
    public Output<Optional<RemediationConfigurationExecutionControls>> executionControls() {
        return Codegen.optional(this.executionControls);
    }
    /**
     * Maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.
     * 
     */
    @Export(name="maximumAutomaticAttempts", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> maximumAutomaticAttempts;

    /**
     * @return Maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.
     * 
     */
    public Output<Optional<Integer>> maximumAutomaticAttempts() {
        return Codegen.optional(this.maximumAutomaticAttempts);
    }
    /**
     * Can be specified multiple times for each parameter. Each parameter block supports arguments below.
     * 
     */
    @Export(name="parameters", refs={List.class,RemediationConfigurationParameter.class}, tree="[0,1]")
    private Output</* @Nullable */ List<RemediationConfigurationParameter>> parameters;

    /**
     * @return Can be specified multiple times for each parameter. Each parameter block supports arguments below.
     * 
     */
    public Output<Optional<List<RemediationConfigurationParameter>>> parameters() {
        return Codegen.optional(this.parameters);
    }
    /**
     * Type of resource.
     * 
     */
    @Export(name="resourceType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> resourceType;

    /**
     * @return Type of resource.
     * 
     */
    public Output<Optional<String>> resourceType() {
        return Codegen.optional(this.resourceType);
    }
    /**
     * Maximum time in seconds that AWS Config runs auto-remediation. If you do not select a number, the default is 60 seconds.
     * 
     */
    @Export(name="retryAttemptSeconds", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> retryAttemptSeconds;

    /**
     * @return Maximum time in seconds that AWS Config runs auto-remediation. If you do not select a number, the default is 60 seconds.
     * 
     */
    public Output<Optional<Integer>> retryAttemptSeconds() {
        return Codegen.optional(this.retryAttemptSeconds);
    }
    /**
     * Target ID is the name of the public document.
     * 
     */
    @Export(name="targetId", refs={String.class}, tree="[0]")
    private Output<String> targetId;

    /**
     * @return Target ID is the name of the public document.
     * 
     */
    public Output<String> targetId() {
        return this.targetId;
    }
    /**
     * Type of the target. Target executes remediation. For example, SSM document.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="targetType", refs={String.class}, tree="[0]")
    private Output<String> targetType;

    /**
     * @return Type of the target. Target executes remediation. For example, SSM document.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> targetType() {
        return this.targetType;
    }
    /**
     * Version of the target. For example, version of the SSM document
     * 
     */
    @Export(name="targetVersion", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> targetVersion;

    /**
     * @return Version of the target. For example, version of the SSM document
     * 
     */
    public Output<Optional<String>> targetVersion() {
        return Codegen.optional(this.targetVersion);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public RemediationConfiguration(String name) {
        this(name, RemediationConfigurationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public RemediationConfiguration(String name, RemediationConfigurationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public RemediationConfiguration(String name, RemediationConfigurationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cfg/remediationConfiguration:RemediationConfiguration", name, args == null ? RemediationConfigurationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private RemediationConfiguration(String name, Output<String> id, @Nullable RemediationConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cfg/remediationConfiguration:RemediationConfiguration", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static RemediationConfiguration get(String name, Output<String> id, @Nullable RemediationConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new RemediationConfiguration(name, id, state, options);
    }
}
