// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cfg;

import com.pulumi.aws.cfg.inputs.DeliveryChannelSnapshotDeliveryPropertiesArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class DeliveryChannelArgs extends com.pulumi.resources.ResourceArgs {

    public static final DeliveryChannelArgs Empty = new DeliveryChannelArgs();

    /**
     * The name of the delivery channel. Defaults to `default`. Changing it recreates the resource.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the delivery channel. Defaults to `default`. Changing it recreates the resource.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The name of the S3 bucket used to store the configuration history.
     * 
     */
    @Import(name="s3BucketName", required=true)
    private Output<String> s3BucketName;

    /**
     * @return The name of the S3 bucket used to store the configuration history.
     * 
     */
    public Output<String> s3BucketName() {
        return this.s3BucketName;
    }

    /**
     * The prefix for the specified S3 bucket.
     * 
     */
    @Import(name="s3KeyPrefix")
    private @Nullable Output<String> s3KeyPrefix;

    /**
     * @return The prefix for the specified S3 bucket.
     * 
     */
    public Optional<Output<String>> s3KeyPrefix() {
        return Optional.ofNullable(this.s3KeyPrefix);
    }

    /**
     * The ARN of the AWS KMS key used to encrypt objects delivered by AWS Config. Must belong to the same Region as the destination S3 bucket.
     * 
     */
    @Import(name="s3KmsKeyArn")
    private @Nullable Output<String> s3KmsKeyArn;

    /**
     * @return The ARN of the AWS KMS key used to encrypt objects delivered by AWS Config. Must belong to the same Region as the destination S3 bucket.
     * 
     */
    public Optional<Output<String>> s3KmsKeyArn() {
        return Optional.ofNullable(this.s3KmsKeyArn);
    }

    /**
     * Options for how AWS Config delivers configuration snapshots. See below
     * 
     */
    @Import(name="snapshotDeliveryProperties")
    private @Nullable Output<DeliveryChannelSnapshotDeliveryPropertiesArgs> snapshotDeliveryProperties;

    /**
     * @return Options for how AWS Config delivers configuration snapshots. See below
     * 
     */
    public Optional<Output<DeliveryChannelSnapshotDeliveryPropertiesArgs>> snapshotDeliveryProperties() {
        return Optional.ofNullable(this.snapshotDeliveryProperties);
    }

    /**
     * The ARN of the SNS topic that AWS Config delivers notifications to.
     * 
     */
    @Import(name="snsTopicArn")
    private @Nullable Output<String> snsTopicArn;

    /**
     * @return The ARN of the SNS topic that AWS Config delivers notifications to.
     * 
     */
    public Optional<Output<String>> snsTopicArn() {
        return Optional.ofNullable(this.snsTopicArn);
    }

    private DeliveryChannelArgs() {}

    private DeliveryChannelArgs(DeliveryChannelArgs $) {
        this.name = $.name;
        this.s3BucketName = $.s3BucketName;
        this.s3KeyPrefix = $.s3KeyPrefix;
        this.s3KmsKeyArn = $.s3KmsKeyArn;
        this.snapshotDeliveryProperties = $.snapshotDeliveryProperties;
        this.snsTopicArn = $.snsTopicArn;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DeliveryChannelArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DeliveryChannelArgs $;

        public Builder() {
            $ = new DeliveryChannelArgs();
        }

        public Builder(DeliveryChannelArgs defaults) {
            $ = new DeliveryChannelArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param name The name of the delivery channel. Defaults to `default`. Changing it recreates the resource.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the delivery channel. Defaults to `default`. Changing it recreates the resource.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param s3BucketName The name of the S3 bucket used to store the configuration history.
         * 
         * @return builder
         * 
         */
        public Builder s3BucketName(Output<String> s3BucketName) {
            $.s3BucketName = s3BucketName;
            return this;
        }

        /**
         * @param s3BucketName The name of the S3 bucket used to store the configuration history.
         * 
         * @return builder
         * 
         */
        public Builder s3BucketName(String s3BucketName) {
            return s3BucketName(Output.of(s3BucketName));
        }

        /**
         * @param s3KeyPrefix The prefix for the specified S3 bucket.
         * 
         * @return builder
         * 
         */
        public Builder s3KeyPrefix(@Nullable Output<String> s3KeyPrefix) {
            $.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        /**
         * @param s3KeyPrefix The prefix for the specified S3 bucket.
         * 
         * @return builder
         * 
         */
        public Builder s3KeyPrefix(String s3KeyPrefix) {
            return s3KeyPrefix(Output.of(s3KeyPrefix));
        }

        /**
         * @param s3KmsKeyArn The ARN of the AWS KMS key used to encrypt objects delivered by AWS Config. Must belong to the same Region as the destination S3 bucket.
         * 
         * @return builder
         * 
         */
        public Builder s3KmsKeyArn(@Nullable Output<String> s3KmsKeyArn) {
            $.s3KmsKeyArn = s3KmsKeyArn;
            return this;
        }

        /**
         * @param s3KmsKeyArn The ARN of the AWS KMS key used to encrypt objects delivered by AWS Config. Must belong to the same Region as the destination S3 bucket.
         * 
         * @return builder
         * 
         */
        public Builder s3KmsKeyArn(String s3KmsKeyArn) {
            return s3KmsKeyArn(Output.of(s3KmsKeyArn));
        }

        /**
         * @param snapshotDeliveryProperties Options for how AWS Config delivers configuration snapshots. See below
         * 
         * @return builder
         * 
         */
        public Builder snapshotDeliveryProperties(@Nullable Output<DeliveryChannelSnapshotDeliveryPropertiesArgs> snapshotDeliveryProperties) {
            $.snapshotDeliveryProperties = snapshotDeliveryProperties;
            return this;
        }

        /**
         * @param snapshotDeliveryProperties Options for how AWS Config delivers configuration snapshots. See below
         * 
         * @return builder
         * 
         */
        public Builder snapshotDeliveryProperties(DeliveryChannelSnapshotDeliveryPropertiesArgs snapshotDeliveryProperties) {
            return snapshotDeliveryProperties(Output.of(snapshotDeliveryProperties));
        }

        /**
         * @param snsTopicArn The ARN of the SNS topic that AWS Config delivers notifications to.
         * 
         * @return builder
         * 
         */
        public Builder snsTopicArn(@Nullable Output<String> snsTopicArn) {
            $.snsTopicArn = snsTopicArn;
            return this;
        }

        /**
         * @param snsTopicArn The ARN of the SNS topic that AWS Config delivers notifications to.
         * 
         * @return builder
         * 
         */
        public Builder snsTopicArn(String snsTopicArn) {
            return snsTopicArn(Output.of(snsTopicArn));
        }

        public DeliveryChannelArgs build() {
            $.s3BucketName = Objects.requireNonNull($.s3BucketName, "expected parameter 's3BucketName' to be non-null");
            return $;
        }
    }

}
