// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.budgets;

import com.pulumi.aws.budgets.inputs.BudgetAutoAdjustDataArgs;
import com.pulumi.aws.budgets.inputs.BudgetCostFilterArgs;
import com.pulumi.aws.budgets.inputs.BudgetCostTypesArgs;
import com.pulumi.aws.budgets.inputs.BudgetNotificationArgs;
import com.pulumi.aws.budgets.inputs.BudgetPlannedLimitArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BudgetArgs extends com.pulumi.resources.ResourceArgs {

    public static final BudgetArgs Empty = new BudgetArgs();

    /**
     * The ID of the target account for budget. Will use current user&#39;s account_id by default if omitted.
     * 
     */
    @Import(name="accountId")
    private @Nullable Output<String> accountId;

    /**
     * @return The ID of the target account for budget. Will use current user&#39;s account_id by default if omitted.
     * 
     */
    public Optional<Output<String>> accountId() {
        return Optional.ofNullable(this.accountId);
    }

    /**
     * Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
     * 
     */
    @Import(name="autoAdjustData")
    private @Nullable Output<BudgetAutoAdjustDataArgs> autoAdjustData;

    /**
     * @return Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
     * 
     */
    public Optional<Output<BudgetAutoAdjustDataArgs>> autoAdjustData() {
        return Optional.ofNullable(this.autoAdjustData);
    }

    /**
     * Whether this budget tracks monetary cost or usage.
     * 
     */
    @Import(name="budgetType", required=true)
    private Output<String> budgetType;

    /**
     * @return Whether this budget tracks monetary cost or usage.
     * 
     */
    public Output<String> budgetType() {
        return this.budgetType;
    }

    /**
     * A list of CostFilter name/values pair to apply to budget.
     * 
     */
    @Import(name="costFilters")
    private @Nullable Output<List<BudgetCostFilterArgs>> costFilters;

    /**
     * @return A list of CostFilter name/values pair to apply to budget.
     * 
     */
    public Optional<Output<List<BudgetCostFilterArgs>>> costFilters() {
        return Optional.ofNullable(this.costFilters);
    }

    /**
     * Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
     * 
     */
    @Import(name="costTypes")
    private @Nullable Output<BudgetCostTypesArgs> costTypes;

    /**
     * @return Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
     * 
     */
    public Optional<Output<BudgetCostTypesArgs>> costTypes() {
        return Optional.ofNullable(this.costTypes);
    }

    /**
     * The amount of cost or usage being measured for a budget.
     * 
     */
    @Import(name="limitAmount")
    private @Nullable Output<String> limitAmount;

    /**
     * @return The amount of cost or usage being measured for a budget.
     * 
     */
    public Optional<Output<String>> limitAmount() {
        return Optional.ofNullable(this.limitAmount);
    }

    /**
     * The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
     * 
     */
    @Import(name="limitUnit")
    private @Nullable Output<String> limitUnit;

    /**
     * @return The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
     * 
     */
    public Optional<Output<String>> limitUnit() {
        return Optional.ofNullable(this.limitUnit);
    }

    /**
     * The name of a budget. Unique within accounts.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of a budget. Unique within accounts.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The prefix of the name of a budget. Unique within accounts.
     * 
     */
    @Import(name="namePrefix")
    private @Nullable Output<String> namePrefix;

    /**
     * @return The prefix of the name of a budget. Unique within accounts.
     * 
     */
    public Optional<Output<String>> namePrefix() {
        return Optional.ofNullable(this.namePrefix);
    }

    /**
     * Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
     * 
     */
    @Import(name="notifications")
    private @Nullable Output<List<BudgetNotificationArgs>> notifications;

    /**
     * @return Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
     * 
     */
    public Optional<Output<List<BudgetNotificationArgs>>> notifications() {
        return Optional.ofNullable(this.notifications);
    }

    /**
     * Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
     * 
     */
    @Import(name="plannedLimits")
    private @Nullable Output<List<BudgetPlannedLimitArgs>> plannedLimits;

    /**
     * @return Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
     * 
     */
    public Optional<Output<List<BudgetPlannedLimitArgs>>> plannedLimits() {
        return Optional.ofNullable(this.plannedLimits);
    }

    /**
     * The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
     * 
     */
    @Import(name="timePeriodEnd")
    private @Nullable Output<String> timePeriodEnd;

    /**
     * @return The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
     * 
     */
    public Optional<Output<String>> timePeriodEnd() {
        return Optional.ofNullable(this.timePeriodEnd);
    }

    /**
     * The start of the time period covered by the budget. If you don&#39;t specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
     * 
     */
    @Import(name="timePeriodStart")
    private @Nullable Output<String> timePeriodStart;

    /**
     * @return The start of the time period covered by the budget. If you don&#39;t specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
     * 
     */
    public Optional<Output<String>> timePeriodStart() {
        return Optional.ofNullable(this.timePeriodStart);
    }

    /**
     * The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
     * 
     */
    @Import(name="timeUnit", required=true)
    private Output<String> timeUnit;

    /**
     * @return The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
     * 
     */
    public Output<String> timeUnit() {
        return this.timeUnit;
    }

    private BudgetArgs() {}

    private BudgetArgs(BudgetArgs $) {
        this.accountId = $.accountId;
        this.autoAdjustData = $.autoAdjustData;
        this.budgetType = $.budgetType;
        this.costFilters = $.costFilters;
        this.costTypes = $.costTypes;
        this.limitAmount = $.limitAmount;
        this.limitUnit = $.limitUnit;
        this.name = $.name;
        this.namePrefix = $.namePrefix;
        this.notifications = $.notifications;
        this.plannedLimits = $.plannedLimits;
        this.timePeriodEnd = $.timePeriodEnd;
        this.timePeriodStart = $.timePeriodStart;
        this.timeUnit = $.timeUnit;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BudgetArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BudgetArgs $;

        public Builder() {
            $ = new BudgetArgs();
        }

        public Builder(BudgetArgs defaults) {
            $ = new BudgetArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param accountId The ID of the target account for budget. Will use current user&#39;s account_id by default if omitted.
         * 
         * @return builder
         * 
         */
        public Builder accountId(@Nullable Output<String> accountId) {
            $.accountId = accountId;
            return this;
        }

        /**
         * @param accountId The ID of the target account for budget. Will use current user&#39;s account_id by default if omitted.
         * 
         * @return builder
         * 
         */
        public Builder accountId(String accountId) {
            return accountId(Output.of(accountId));
        }

        /**
         * @param autoAdjustData Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
         * 
         * @return builder
         * 
         */
        public Builder autoAdjustData(@Nullable Output<BudgetAutoAdjustDataArgs> autoAdjustData) {
            $.autoAdjustData = autoAdjustData;
            return this;
        }

        /**
         * @param autoAdjustData Object containing [AutoAdjustData] which determines the budget amount for an auto-adjusting budget.
         * 
         * @return builder
         * 
         */
        public Builder autoAdjustData(BudgetAutoAdjustDataArgs autoAdjustData) {
            return autoAdjustData(Output.of(autoAdjustData));
        }

        /**
         * @param budgetType Whether this budget tracks monetary cost or usage.
         * 
         * @return builder
         * 
         */
        public Builder budgetType(Output<String> budgetType) {
            $.budgetType = budgetType;
            return this;
        }

        /**
         * @param budgetType Whether this budget tracks monetary cost or usage.
         * 
         * @return builder
         * 
         */
        public Builder budgetType(String budgetType) {
            return budgetType(Output.of(budgetType));
        }

        /**
         * @param costFilters A list of CostFilter name/values pair to apply to budget.
         * 
         * @return builder
         * 
         */
        public Builder costFilters(@Nullable Output<List<BudgetCostFilterArgs>> costFilters) {
            $.costFilters = costFilters;
            return this;
        }

        /**
         * @param costFilters A list of CostFilter name/values pair to apply to budget.
         * 
         * @return builder
         * 
         */
        public Builder costFilters(List<BudgetCostFilterArgs> costFilters) {
            return costFilters(Output.of(costFilters));
        }

        /**
         * @param costFilters A list of CostFilter name/values pair to apply to budget.
         * 
         * @return builder
         * 
         */
        public Builder costFilters(BudgetCostFilterArgs... costFilters) {
            return costFilters(List.of(costFilters));
        }

        /**
         * @param costTypes Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
         * 
         * @return builder
         * 
         */
        public Builder costTypes(@Nullable Output<BudgetCostTypesArgs> costTypes) {
            $.costTypes = costTypes;
            return this;
        }

        /**
         * @param costTypes Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
         * 
         * @return builder
         * 
         */
        public Builder costTypes(BudgetCostTypesArgs costTypes) {
            return costTypes(Output.of(costTypes));
        }

        /**
         * @param limitAmount The amount of cost or usage being measured for a budget.
         * 
         * @return builder
         * 
         */
        public Builder limitAmount(@Nullable Output<String> limitAmount) {
            $.limitAmount = limitAmount;
            return this;
        }

        /**
         * @param limitAmount The amount of cost or usage being measured for a budget.
         * 
         * @return builder
         * 
         */
        public Builder limitAmount(String limitAmount) {
            return limitAmount(Output.of(limitAmount));
        }

        /**
         * @param limitUnit The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
         * 
         * @return builder
         * 
         */
        public Builder limitUnit(@Nullable Output<String> limitUnit) {
            $.limitUnit = limitUnit;
            return this;
        }

        /**
         * @param limitUnit The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
         * 
         * @return builder
         * 
         */
        public Builder limitUnit(String limitUnit) {
            return limitUnit(Output.of(limitUnit));
        }

        /**
         * @param name The name of a budget. Unique within accounts.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of a budget. Unique within accounts.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param namePrefix The prefix of the name of a budget. Unique within accounts.
         * 
         * @return builder
         * 
         */
        public Builder namePrefix(@Nullable Output<String> namePrefix) {
            $.namePrefix = namePrefix;
            return this;
        }

        /**
         * @param namePrefix The prefix of the name of a budget. Unique within accounts.
         * 
         * @return builder
         * 
         */
        public Builder namePrefix(String namePrefix) {
            return namePrefix(Output.of(namePrefix));
        }

        /**
         * @param notifications Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
         * 
         * @return builder
         * 
         */
        public Builder notifications(@Nullable Output<List<BudgetNotificationArgs>> notifications) {
            $.notifications = notifications;
            return this;
        }

        /**
         * @param notifications Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
         * 
         * @return builder
         * 
         */
        public Builder notifications(List<BudgetNotificationArgs> notifications) {
            return notifications(Output.of(notifications));
        }

        /**
         * @param notifications Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
         * 
         * @return builder
         * 
         */
        public Builder notifications(BudgetNotificationArgs... notifications) {
            return notifications(List.of(notifications));
        }

        /**
         * @param plannedLimits Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
         * 
         * @return builder
         * 
         */
        public Builder plannedLimits(@Nullable Output<List<BudgetPlannedLimitArgs>> plannedLimits) {
            $.plannedLimits = plannedLimits;
            return this;
        }

        /**
         * @param plannedLimits Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
         * 
         * @return builder
         * 
         */
        public Builder plannedLimits(List<BudgetPlannedLimitArgs> plannedLimits) {
            return plannedLimits(Output.of(plannedLimits));
        }

        /**
         * @param plannedLimits Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
         * 
         * @return builder
         * 
         */
        public Builder plannedLimits(BudgetPlannedLimitArgs... plannedLimits) {
            return plannedLimits(List.of(plannedLimits));
        }

        /**
         * @param timePeriodEnd The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
         * 
         * @return builder
         * 
         */
        public Builder timePeriodEnd(@Nullable Output<String> timePeriodEnd) {
            $.timePeriodEnd = timePeriodEnd;
            return this;
        }

        /**
         * @param timePeriodEnd The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
         * 
         * @return builder
         * 
         */
        public Builder timePeriodEnd(String timePeriodEnd) {
            return timePeriodEnd(Output.of(timePeriodEnd));
        }

        /**
         * @param timePeriodStart The start of the time period covered by the budget. If you don&#39;t specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
         * 
         * @return builder
         * 
         */
        public Builder timePeriodStart(@Nullable Output<String> timePeriodStart) {
            $.timePeriodStart = timePeriodStart;
            return this;
        }

        /**
         * @param timePeriodStart The start of the time period covered by the budget. If you don&#39;t specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
         * 
         * @return builder
         * 
         */
        public Builder timePeriodStart(String timePeriodStart) {
            return timePeriodStart(Output.of(timePeriodStart));
        }

        /**
         * @param timeUnit The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
         * 
         * @return builder
         * 
         */
        public Builder timeUnit(Output<String> timeUnit) {
            $.timeUnit = timeUnit;
            return this;
        }

        /**
         * @param timeUnit The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
         * 
         * @return builder
         * 
         */
        public Builder timeUnit(String timeUnit) {
            return timeUnit(Output.of(timeUnit));
        }

        public BudgetArgs build() {
            $.budgetType = Objects.requireNonNull($.budgetType, "expected parameter 'budgetType' to be non-null");
            $.timeUnit = Objects.requireNonNull($.timeUnit, "expected parameter 'timeUnit' to be non-null");
            return $;
        }
    }

}
