// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.budgets;

import com.pulumi.aws.budgets.inputs.BudgetActionActionThresholdArgs;
import com.pulumi.aws.budgets.inputs.BudgetActionDefinitionArgs;
import com.pulumi.aws.budgets.inputs.BudgetActionSubscriberArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BudgetActionArgs extends com.pulumi.resources.ResourceArgs {

    public static final BudgetActionArgs Empty = new BudgetActionArgs();

    /**
     * The ID of the target account for budget. Will use current user&#39;s account_id by default if omitted.
     * 
     */
    @Import(name="accountId")
    private @Nullable Output<String> accountId;

    /**
     * @return The ID of the target account for budget. Will use current user&#39;s account_id by default if omitted.
     * 
     */
    public Optional<Output<String>> accountId() {
        return Optional.ofNullable(this.accountId);
    }

    /**
     * The trigger threshold of the action. See Action Threshold.
     * 
     */
    @Import(name="actionThreshold", required=true)
    private Output<BudgetActionActionThresholdArgs> actionThreshold;

    /**
     * @return The trigger threshold of the action. See Action Threshold.
     * 
     */
    public Output<BudgetActionActionThresholdArgs> actionThreshold() {
        return this.actionThreshold;
    }

    /**
     * The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
     * 
     */
    @Import(name="actionType", required=true)
    private Output<String> actionType;

    /**
     * @return The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
     * 
     */
    public Output<String> actionType() {
        return this.actionType;
    }

    /**
     * This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
     * 
     */
    @Import(name="approvalModel", required=true)
    private Output<String> approvalModel;

    /**
     * @return This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
     * 
     */
    public Output<String> approvalModel() {
        return this.approvalModel;
    }

    /**
     * The name of a budget.
     * 
     */
    @Import(name="budgetName", required=true)
    private Output<String> budgetName;

    /**
     * @return The name of a budget.
     * 
     */
    public Output<String> budgetName() {
        return this.budgetName;
    }

    /**
     * Specifies all of the type-specific parameters. See Definition.
     * 
     */
    @Import(name="definition", required=true)
    private Output<BudgetActionDefinitionArgs> definition;

    /**
     * @return Specifies all of the type-specific parameters. See Definition.
     * 
     */
    public Output<BudgetActionDefinitionArgs> definition() {
        return this.definition;
    }

    /**
     * The role passed for action execution and reversion. Roles and actions must be in the same account.
     * 
     */
    @Import(name="executionRoleArn", required=true)
    private Output<String> executionRoleArn;

    /**
     * @return The role passed for action execution and reversion. Roles and actions must be in the same account.
     * 
     */
    public Output<String> executionRoleArn() {
        return this.executionRoleArn;
    }

    /**
     * The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
     * 
     */
    @Import(name="notificationType", required=true)
    private Output<String> notificationType;

    /**
     * @return The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
     * 
     */
    public Output<String> notificationType() {
        return this.notificationType;
    }

    /**
     * A list of subscribers. See Subscriber.
     * 
     */
    @Import(name="subscribers", required=true)
    private Output<List<BudgetActionSubscriberArgs>> subscribers;

    /**
     * @return A list of subscribers. See Subscriber.
     * 
     */
    public Output<List<BudgetActionSubscriberArgs>> subscribers() {
        return this.subscribers;
    }

    private BudgetActionArgs() {}

    private BudgetActionArgs(BudgetActionArgs $) {
        this.accountId = $.accountId;
        this.actionThreshold = $.actionThreshold;
        this.actionType = $.actionType;
        this.approvalModel = $.approvalModel;
        this.budgetName = $.budgetName;
        this.definition = $.definition;
        this.executionRoleArn = $.executionRoleArn;
        this.notificationType = $.notificationType;
        this.subscribers = $.subscribers;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BudgetActionArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BudgetActionArgs $;

        public Builder() {
            $ = new BudgetActionArgs();
        }

        public Builder(BudgetActionArgs defaults) {
            $ = new BudgetActionArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param accountId The ID of the target account for budget. Will use current user&#39;s account_id by default if omitted.
         * 
         * @return builder
         * 
         */
        public Builder accountId(@Nullable Output<String> accountId) {
            $.accountId = accountId;
            return this;
        }

        /**
         * @param accountId The ID of the target account for budget. Will use current user&#39;s account_id by default if omitted.
         * 
         * @return builder
         * 
         */
        public Builder accountId(String accountId) {
            return accountId(Output.of(accountId));
        }

        /**
         * @param actionThreshold The trigger threshold of the action. See Action Threshold.
         * 
         * @return builder
         * 
         */
        public Builder actionThreshold(Output<BudgetActionActionThresholdArgs> actionThreshold) {
            $.actionThreshold = actionThreshold;
            return this;
        }

        /**
         * @param actionThreshold The trigger threshold of the action. See Action Threshold.
         * 
         * @return builder
         * 
         */
        public Builder actionThreshold(BudgetActionActionThresholdArgs actionThreshold) {
            return actionThreshold(Output.of(actionThreshold));
        }

        /**
         * @param actionType The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
         * 
         * @return builder
         * 
         */
        public Builder actionType(Output<String> actionType) {
            $.actionType = actionType;
            return this;
        }

        /**
         * @param actionType The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
         * 
         * @return builder
         * 
         */
        public Builder actionType(String actionType) {
            return actionType(Output.of(actionType));
        }

        /**
         * @param approvalModel This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
         * 
         * @return builder
         * 
         */
        public Builder approvalModel(Output<String> approvalModel) {
            $.approvalModel = approvalModel;
            return this;
        }

        /**
         * @param approvalModel This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
         * 
         * @return builder
         * 
         */
        public Builder approvalModel(String approvalModel) {
            return approvalModel(Output.of(approvalModel));
        }

        /**
         * @param budgetName The name of a budget.
         * 
         * @return builder
         * 
         */
        public Builder budgetName(Output<String> budgetName) {
            $.budgetName = budgetName;
            return this;
        }

        /**
         * @param budgetName The name of a budget.
         * 
         * @return builder
         * 
         */
        public Builder budgetName(String budgetName) {
            return budgetName(Output.of(budgetName));
        }

        /**
         * @param definition Specifies all of the type-specific parameters. See Definition.
         * 
         * @return builder
         * 
         */
        public Builder definition(Output<BudgetActionDefinitionArgs> definition) {
            $.definition = definition;
            return this;
        }

        /**
         * @param definition Specifies all of the type-specific parameters. See Definition.
         * 
         * @return builder
         * 
         */
        public Builder definition(BudgetActionDefinitionArgs definition) {
            return definition(Output.of(definition));
        }

        /**
         * @param executionRoleArn The role passed for action execution and reversion. Roles and actions must be in the same account.
         * 
         * @return builder
         * 
         */
        public Builder executionRoleArn(Output<String> executionRoleArn) {
            $.executionRoleArn = executionRoleArn;
            return this;
        }

        /**
         * @param executionRoleArn The role passed for action execution and reversion. Roles and actions must be in the same account.
         * 
         * @return builder
         * 
         */
        public Builder executionRoleArn(String executionRoleArn) {
            return executionRoleArn(Output.of(executionRoleArn));
        }

        /**
         * @param notificationType The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
         * 
         * @return builder
         * 
         */
        public Builder notificationType(Output<String> notificationType) {
            $.notificationType = notificationType;
            return this;
        }

        /**
         * @param notificationType The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
         * 
         * @return builder
         * 
         */
        public Builder notificationType(String notificationType) {
            return notificationType(Output.of(notificationType));
        }

        /**
         * @param subscribers A list of subscribers. See Subscriber.
         * 
         * @return builder
         * 
         */
        public Builder subscribers(Output<List<BudgetActionSubscriberArgs>> subscribers) {
            $.subscribers = subscribers;
            return this;
        }

        /**
         * @param subscribers A list of subscribers. See Subscriber.
         * 
         * @return builder
         * 
         */
        public Builder subscribers(List<BudgetActionSubscriberArgs> subscribers) {
            return subscribers(Output.of(subscribers));
        }

        /**
         * @param subscribers A list of subscribers. See Subscriber.
         * 
         * @return builder
         * 
         */
        public Builder subscribers(BudgetActionSubscriberArgs... subscribers) {
            return subscribers(List.of(subscribers));
        }

        public BudgetActionArgs build() {
            $.actionThreshold = Objects.requireNonNull($.actionThreshold, "expected parameter 'actionThreshold' to be non-null");
            $.actionType = Objects.requireNonNull($.actionType, "expected parameter 'actionType' to be non-null");
            $.approvalModel = Objects.requireNonNull($.approvalModel, "expected parameter 'approvalModel' to be non-null");
            $.budgetName = Objects.requireNonNull($.budgetName, "expected parameter 'budgetName' to be non-null");
            $.definition = Objects.requireNonNull($.definition, "expected parameter 'definition' to be non-null");
            $.executionRoleArn = Objects.requireNonNull($.executionRoleArn, "expected parameter 'executionRoleArn' to be non-null");
            $.notificationType = Objects.requireNonNull($.notificationType, "expected parameter 'notificationType' to be non-null");
            $.subscribers = Objects.requireNonNull($.subscribers, "expected parameter 'subscribers' to be non-null");
            return $;
        }
    }

}
