// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.budgets;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.budgets.BudgetActionArgs;
import com.pulumi.aws.budgets.inputs.BudgetActionState;
import com.pulumi.aws.budgets.outputs.BudgetActionActionThreshold;
import com.pulumi.aws.budgets.outputs.BudgetActionDefinition;
import com.pulumi.aws.budgets.outputs.BudgetActionSubscriber;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import javax.annotation.Nullable;

/**
 * Provides a budget action resource. Budget actions are cost savings controls that run either automatically on your behalf or by using a workflow approval process.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.budgets.Budget;
 * import com.pulumi.aws.budgets.BudgetArgs;
 * import com.pulumi.aws.budgets.BudgetAction;
 * import com.pulumi.aws.budgets.BudgetActionArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetActionActionThresholdArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetActionDefinitionArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetActionDefinitionIamActionDefinitionArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetActionSubscriberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect(&#34;Allow&#34;)
 *                 .actions(&#34;ec2:Describe*&#34;)
 *                 .resources(&#34;*&#34;)
 *                 .build())
 *             .build());
 * 
 *         var examplePolicy = new Policy(&#34;examplePolicy&#34;, PolicyArgs.builder()        
 *             .description(&#34;My example policy&#34;)
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json()))
 *             .build());
 * 
 *         final var current = AwsFunctions.getPartition();
 * 
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect(&#34;Allow&#34;)
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type(&#34;Service&#34;)
 *                     .identifiers(String.format(&#34;budgets.%s&#34;, current.applyValue(getPartitionResult -&gt; getPartitionResult.dnsSuffix())))
 *                     .build())
 *                 .actions(&#34;sts:AssumeRole&#34;)
 *                 .build())
 *             .build());
 * 
 *         var exampleRole = new Role(&#34;exampleRole&#34;, RoleArgs.builder()        
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json()))
 *             .build());
 * 
 *         var exampleBudget = new Budget(&#34;exampleBudget&#34;, BudgetArgs.builder()        
 *             .budgetType(&#34;USAGE&#34;)
 *             .limitAmount(&#34;10.0&#34;)
 *             .limitUnit(&#34;dollars&#34;)
 *             .timePeriodStart(&#34;2006-01-02_15:04&#34;)
 *             .timeUnit(&#34;MONTHLY&#34;)
 *             .build());
 * 
 *         var exampleBudgetAction = new BudgetAction(&#34;exampleBudgetAction&#34;, BudgetActionArgs.builder()        
 *             .budgetName(exampleBudget.name())
 *             .actionType(&#34;APPLY_IAM_POLICY&#34;)
 *             .approvalModel(&#34;AUTOMATIC&#34;)
 *             .notificationType(&#34;ACTUAL&#34;)
 *             .executionRoleArn(exampleRole.arn())
 *             .actionThreshold(BudgetActionActionThresholdArgs.builder()
 *                 .actionThresholdType(&#34;ABSOLUTE_VALUE&#34;)
 *                 .actionThresholdValue(100)
 *                 .build())
 *             .definition(BudgetActionDefinitionArgs.builder()
 *                 .iamActionDefinition(BudgetActionDefinitionIamActionDefinitionArgs.builder()
 *                     .policyArn(examplePolicy.arn())
 *                     .roles(exampleRole.name())
 *                     .build())
 *                 .build())
 *             .subscribers(BudgetActionSubscriberArgs.builder()
 *                 .address(&#34;example@example.example&#34;)
 *                 .subscriptionType(&#34;EMAIL&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import budget actions using `AccountID:ActionID:BudgetName`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:budgets/budgetAction:BudgetAction myBudget 123456789012:some-id:myBudget
 * ```
 * 
 */
@ResourceType(type="aws:budgets/budgetAction:BudgetAction")
public class BudgetAction extends com.pulumi.resources.CustomResource {
    /**
     * The ID of the target account for budget. Will use current user&#39;s account_id by default if omitted.
     * 
     */
    @Export(name="accountId", refs={String.class}, tree="[0]")
    private Output<String> accountId;

    /**
     * @return The ID of the target account for budget. Will use current user&#39;s account_id by default if omitted.
     * 
     */
    public Output<String> accountId() {
        return this.accountId;
    }
    /**
     * The id of the budget action.
     * 
     */
    @Export(name="actionId", refs={String.class}, tree="[0]")
    private Output<String> actionId;

    /**
     * @return The id of the budget action.
     * 
     */
    public Output<String> actionId() {
        return this.actionId;
    }
    /**
     * The trigger threshold of the action. See Action Threshold.
     * 
     */
    @Export(name="actionThreshold", refs={BudgetActionActionThreshold.class}, tree="[0]")
    private Output<BudgetActionActionThreshold> actionThreshold;

    /**
     * @return The trigger threshold of the action. See Action Threshold.
     * 
     */
    public Output<BudgetActionActionThreshold> actionThreshold() {
        return this.actionThreshold;
    }
    /**
     * The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
     * 
     */
    @Export(name="actionType", refs={String.class}, tree="[0]")
    private Output<String> actionType;

    /**
     * @return The type of action. This defines the type of tasks that can be carried out by this action. This field also determines the format for definition. Valid values are `APPLY_IAM_POLICY`, `APPLY_SCP_POLICY`, and `RUN_SSM_DOCUMENTS`.
     * 
     */
    public Output<String> actionType() {
        return this.actionType;
    }
    /**
     * This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
     * 
     */
    @Export(name="approvalModel", refs={String.class}, tree="[0]")
    private Output<String> approvalModel;

    /**
     * @return This specifies if the action needs manual or automatic approval. Valid values are `AUTOMATIC` and `MANUAL`.
     * 
     */
    public Output<String> approvalModel() {
        return this.approvalModel;
    }
    /**
     * The ARN of the budget action.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The ARN of the budget action.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The name of a budget.
     * 
     */
    @Export(name="budgetName", refs={String.class}, tree="[0]")
    private Output<String> budgetName;

    /**
     * @return The name of a budget.
     * 
     */
    public Output<String> budgetName() {
        return this.budgetName;
    }
    /**
     * Specifies all of the type-specific parameters. See Definition.
     * 
     */
    @Export(name="definition", refs={BudgetActionDefinition.class}, tree="[0]")
    private Output<BudgetActionDefinition> definition;

    /**
     * @return Specifies all of the type-specific parameters. See Definition.
     * 
     */
    public Output<BudgetActionDefinition> definition() {
        return this.definition;
    }
    /**
     * The role passed for action execution and reversion. Roles and actions must be in the same account.
     * 
     */
    @Export(name="executionRoleArn", refs={String.class}, tree="[0]")
    private Output<String> executionRoleArn;

    /**
     * @return The role passed for action execution and reversion. Roles and actions must be in the same account.
     * 
     */
    public Output<String> executionRoleArn() {
        return this.executionRoleArn;
    }
    /**
     * The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
     * 
     */
    @Export(name="notificationType", refs={String.class}, tree="[0]")
    private Output<String> notificationType;

    /**
     * @return The type of a notification. Valid values are `ACTUAL` or `FORECASTED`.
     * 
     */
    public Output<String> notificationType() {
        return this.notificationType;
    }
    /**
     * The status of the budget action.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return The status of the budget action.
     * 
     */
    public Output<String> status() {
        return this.status;
    }
    /**
     * A list of subscribers. See Subscriber.
     * 
     */
    @Export(name="subscribers", refs={List.class,BudgetActionSubscriber.class}, tree="[0,1]")
    private Output<List<BudgetActionSubscriber>> subscribers;

    /**
     * @return A list of subscribers. See Subscriber.
     * 
     */
    public Output<List<BudgetActionSubscriber>> subscribers() {
        return this.subscribers;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public BudgetAction(String name) {
        this(name, BudgetActionArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public BudgetAction(String name, BudgetActionArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public BudgetAction(String name, BudgetActionArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:budgets/budgetAction:BudgetAction", name, args == null ? BudgetActionArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private BudgetAction(String name, Output<String> id, @Nullable BudgetActionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:budgets/budgetAction:BudgetAction", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static BudgetAction get(String name, Output<String> id, @Nullable BudgetActionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new BudgetAction(name, id, state, options);
    }
}
