// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.batch.inputs;

import com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesEc2ConfigurationArgs;
import com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesLaunchTemplateArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ComputeEnvironmentComputeResourcesArgs extends com.pulumi.resources.ResourceArgs {

    public static final ComputeEnvironmentComputeResourcesArgs Empty = new ComputeEnvironmentComputeResourcesArgs();

    /**
     * The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated. Valid items are `BEST_FIT_PROGRESSIVE`, `SPOT_CAPACITY_OPTIMIZED` or `BEST_FIT`. Defaults to `BEST_FIT`. See [AWS docs](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) for details. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    @Import(name="allocationStrategy")
    private @Nullable Output<String> allocationStrategy;

    /**
     * @return The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated. Valid items are `BEST_FIT_PROGRESSIVE`, `SPOT_CAPACITY_OPTIMIZED` or `BEST_FIT`. Defaults to `BEST_FIT`. See [AWS docs](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) for details. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    public Optional<Output<String>> allocationStrategy() {
        return Optional.ofNullable(this.allocationStrategy);
    }

    /**
     * Integer of maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20% (`20`), then the Spot price must be below 20% of the current On-Demand price for that EC2 instance. If you leave this field empty, the default value is 100% of the On-Demand price. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    @Import(name="bidPercentage")
    private @Nullable Output<Integer> bidPercentage;

    /**
     * @return Integer of maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20% (`20`), then the Spot price must be below 20% of the current On-Demand price for that EC2 instance. If you leave this field empty, the default value is 100% of the On-Demand price. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    public Optional<Output<Integer>> bidPercentage() {
        return Optional.ofNullable(this.bidPercentage);
    }

    /**
     * The desired number of EC2 vCPUS in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    @Import(name="desiredVcpus")
    private @Nullable Output<Integer> desiredVcpus;

    /**
     * @return The desired number of EC2 vCPUS in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    public Optional<Output<Integer>> desiredVcpus() {
        return Optional.ofNullable(this.desiredVcpus);
    }

    /**
     * Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn&#39;t specified, the default is ECS_AL2. This parameter isn&#39;t applicable to jobs that are running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    @Import(name="ec2Configurations")
    private @Nullable Output<List<ComputeEnvironmentComputeResourcesEc2ConfigurationArgs>> ec2Configurations;

    /**
     * @return Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn&#39;t specified, the default is ECS_AL2. This parameter isn&#39;t applicable to jobs that are running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    public Optional<Output<List<ComputeEnvironmentComputeResourcesEc2ConfigurationArgs>>> ec2Configurations() {
        return Optional.ofNullable(this.ec2Configurations);
    }

    /**
     * The EC2 key pair that is used for instances launched in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    @Import(name="ec2KeyPair")
    private @Nullable Output<String> ec2KeyPair;

    /**
     * @return The EC2 key pair that is used for instances launched in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    public Optional<Output<String>> ec2KeyPair() {
        return Optional.ofNullable(this.ec2KeyPair);
    }

    /**
     * The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified. (Deprecated, use `ec2_configuration` `image_id_override` instead)
     * 
     */
    @Import(name="imageId")
    private @Nullable Output<String> imageId;

    /**
     * @return The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified. (Deprecated, use `ec2_configuration` `image_id_override` instead)
     * 
     */
    public Optional<Output<String>> imageId() {
        return Optional.ofNullable(this.imageId);
    }

    /**
     * The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    @Import(name="instanceRole")
    private @Nullable Output<String> instanceRole;

    /**
     * @return The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    public Optional<Output<String>> instanceRole() {
        return Optional.ofNullable(this.instanceRole);
    }

    /**
     * A list of instance types that may be launched. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    @Import(name="instanceTypes")
    private @Nullable Output<List<String>> instanceTypes;

    /**
     * @return A list of instance types that may be launched. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    public Optional<Output<List<String>>> instanceTypes() {
        return Optional.ofNullable(this.instanceTypes);
    }

    /**
     * The launch template to use for your compute resources. See details below. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    @Import(name="launchTemplate")
    private @Nullable Output<ComputeEnvironmentComputeResourcesLaunchTemplateArgs> launchTemplate;

    /**
     * @return The launch template to use for your compute resources. See details below. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    public Optional<Output<ComputeEnvironmentComputeResourcesLaunchTemplateArgs>> launchTemplate() {
        return Optional.ofNullable(this.launchTemplate);
    }

    /**
     * The maximum number of EC2 vCPUs that an environment can reach.
     * 
     */
    @Import(name="maxVcpus", required=true)
    private Output<Integer> maxVcpus;

    /**
     * @return The maximum number of EC2 vCPUs that an environment can reach.
     * 
     */
    public Output<Integer> maxVcpus() {
        return this.maxVcpus;
    }

    /**
     * The minimum number of EC2 vCPUs that an environment should maintain. For `EC2` or `SPOT` compute environments, if the parameter is not explicitly defined, a `0` default value will be set. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    @Import(name="minVcpus")
    private @Nullable Output<Integer> minVcpus;

    /**
     * @return The minimum number of EC2 vCPUs that an environment should maintain. For `EC2` or `SPOT` compute environments, if the parameter is not explicitly defined, a `0` default value will be set. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    public Optional<Output<Integer>> minVcpus() {
        return Optional.ofNullable(this.minVcpus);
    }

    /**
     * The Amazon EC2 placement group to associate with your compute resources.
     * 
     */
    @Import(name="placementGroup")
    private @Nullable Output<String> placementGroup;

    /**
     * @return The Amazon EC2 placement group to associate with your compute resources.
     * 
     */
    public Optional<Output<String>> placementGroup() {
        return Optional.ofNullable(this.placementGroup);
    }

    /**
     * A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
     * 
     */
    @Import(name="securityGroupIds")
    private @Nullable Output<List<String>> securityGroupIds;

    /**
     * @return A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
     * 
     */
    public Optional<Output<List<String>>> securityGroupIds() {
        return Optional.ofNullable(this.securityGroupIds);
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment. This parameter is required for SPOT compute environments. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    @Import(name="spotIamFleetRole")
    private @Nullable Output<String> spotIamFleetRole;

    /**
     * @return The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment. This parameter is required for SPOT compute environments. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    public Optional<Output<String>> spotIamFleetRole() {
        return Optional.ofNullable(this.spotIamFleetRole);
    }

    /**
     * A list of VPC subnets into which the compute resources are launched.
     * 
     */
    @Import(name="subnets", required=true)
    private Output<List<String>> subnets;

    /**
     * @return A list of VPC subnets into which the compute resources are launched.
     * 
     */
    public Output<List<String>> subnets() {
        return this.subnets;
    }

    /**
     * Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The type of compute environment. Valid items are `EC2`, `SPOT`, `FARGATE` or `FARGATE_SPOT`.
     * 
     */
    @Import(name="type", required=true)
    private Output<String> type;

    /**
     * @return The type of compute environment. Valid items are `EC2`, `SPOT`, `FARGATE` or `FARGATE_SPOT`.
     * 
     */
    public Output<String> type() {
        return this.type;
    }

    private ComputeEnvironmentComputeResourcesArgs() {}

    private ComputeEnvironmentComputeResourcesArgs(ComputeEnvironmentComputeResourcesArgs $) {
        this.allocationStrategy = $.allocationStrategy;
        this.bidPercentage = $.bidPercentage;
        this.desiredVcpus = $.desiredVcpus;
        this.ec2Configurations = $.ec2Configurations;
        this.ec2KeyPair = $.ec2KeyPair;
        this.imageId = $.imageId;
        this.instanceRole = $.instanceRole;
        this.instanceTypes = $.instanceTypes;
        this.launchTemplate = $.launchTemplate;
        this.maxVcpus = $.maxVcpus;
        this.minVcpus = $.minVcpus;
        this.placementGroup = $.placementGroup;
        this.securityGroupIds = $.securityGroupIds;
        this.spotIamFleetRole = $.spotIamFleetRole;
        this.subnets = $.subnets;
        this.tags = $.tags;
        this.type = $.type;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ComputeEnvironmentComputeResourcesArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ComputeEnvironmentComputeResourcesArgs $;

        public Builder() {
            $ = new ComputeEnvironmentComputeResourcesArgs();
        }

        public Builder(ComputeEnvironmentComputeResourcesArgs defaults) {
            $ = new ComputeEnvironmentComputeResourcesArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param allocationStrategy The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated. Valid items are `BEST_FIT_PROGRESSIVE`, `SPOT_CAPACITY_OPTIMIZED` or `BEST_FIT`. Defaults to `BEST_FIT`. See [AWS docs](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) for details. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder allocationStrategy(@Nullable Output<String> allocationStrategy) {
            $.allocationStrategy = allocationStrategy;
            return this;
        }

        /**
         * @param allocationStrategy The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated. Valid items are `BEST_FIT_PROGRESSIVE`, `SPOT_CAPACITY_OPTIMIZED` or `BEST_FIT`. Defaults to `BEST_FIT`. See [AWS docs](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) for details. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder allocationStrategy(String allocationStrategy) {
            return allocationStrategy(Output.of(allocationStrategy));
        }

        /**
         * @param bidPercentage Integer of maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20% (`20`), then the Spot price must be below 20% of the current On-Demand price for that EC2 instance. If you leave this field empty, the default value is 100% of the On-Demand price. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder bidPercentage(@Nullable Output<Integer> bidPercentage) {
            $.bidPercentage = bidPercentage;
            return this;
        }

        /**
         * @param bidPercentage Integer of maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20% (`20`), then the Spot price must be below 20% of the current On-Demand price for that EC2 instance. If you leave this field empty, the default value is 100% of the On-Demand price. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder bidPercentage(Integer bidPercentage) {
            return bidPercentage(Output.of(bidPercentage));
        }

        /**
         * @param desiredVcpus The desired number of EC2 vCPUS in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder desiredVcpus(@Nullable Output<Integer> desiredVcpus) {
            $.desiredVcpus = desiredVcpus;
            return this;
        }

        /**
         * @param desiredVcpus The desired number of EC2 vCPUS in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder desiredVcpus(Integer desiredVcpus) {
            return desiredVcpus(Output.of(desiredVcpus));
        }

        /**
         * @param ec2Configurations Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn&#39;t specified, the default is ECS_AL2. This parameter isn&#39;t applicable to jobs that are running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder ec2Configurations(@Nullable Output<List<ComputeEnvironmentComputeResourcesEc2ConfigurationArgs>> ec2Configurations) {
            $.ec2Configurations = ec2Configurations;
            return this;
        }

        /**
         * @param ec2Configurations Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn&#39;t specified, the default is ECS_AL2. This parameter isn&#39;t applicable to jobs that are running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder ec2Configurations(List<ComputeEnvironmentComputeResourcesEc2ConfigurationArgs> ec2Configurations) {
            return ec2Configurations(Output.of(ec2Configurations));
        }

        /**
         * @param ec2Configurations Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn&#39;t specified, the default is ECS_AL2. This parameter isn&#39;t applicable to jobs that are running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder ec2Configurations(ComputeEnvironmentComputeResourcesEc2ConfigurationArgs... ec2Configurations) {
            return ec2Configurations(List.of(ec2Configurations));
        }

        /**
         * @param ec2KeyPair The EC2 key pair that is used for instances launched in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder ec2KeyPair(@Nullable Output<String> ec2KeyPair) {
            $.ec2KeyPair = ec2KeyPair;
            return this;
        }

        /**
         * @param ec2KeyPair The EC2 key pair that is used for instances launched in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder ec2KeyPair(String ec2KeyPair) {
            return ec2KeyPair(Output.of(ec2KeyPair));
        }

        /**
         * @param imageId The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified. (Deprecated, use `ec2_configuration` `image_id_override` instead)
         * 
         * @return builder
         * 
         */
        public Builder imageId(@Nullable Output<String> imageId) {
            $.imageId = imageId;
            return this;
        }

        /**
         * @param imageId The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified. (Deprecated, use `ec2_configuration` `image_id_override` instead)
         * 
         * @return builder
         * 
         */
        public Builder imageId(String imageId) {
            return imageId(Output.of(imageId));
        }

        /**
         * @param instanceRole The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder instanceRole(@Nullable Output<String> instanceRole) {
            $.instanceRole = instanceRole;
            return this;
        }

        /**
         * @param instanceRole The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder instanceRole(String instanceRole) {
            return instanceRole(Output.of(instanceRole));
        }

        /**
         * @param instanceTypes A list of instance types that may be launched. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder instanceTypes(@Nullable Output<List<String>> instanceTypes) {
            $.instanceTypes = instanceTypes;
            return this;
        }

        /**
         * @param instanceTypes A list of instance types that may be launched. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder instanceTypes(List<String> instanceTypes) {
            return instanceTypes(Output.of(instanceTypes));
        }

        /**
         * @param instanceTypes A list of instance types that may be launched. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder instanceTypes(String... instanceTypes) {
            return instanceTypes(List.of(instanceTypes));
        }

        /**
         * @param launchTemplate The launch template to use for your compute resources. See details below. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder launchTemplate(@Nullable Output<ComputeEnvironmentComputeResourcesLaunchTemplateArgs> launchTemplate) {
            $.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * @param launchTemplate The launch template to use for your compute resources. See details below. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder launchTemplate(ComputeEnvironmentComputeResourcesLaunchTemplateArgs launchTemplate) {
            return launchTemplate(Output.of(launchTemplate));
        }

        /**
         * @param maxVcpus The maximum number of EC2 vCPUs that an environment can reach.
         * 
         * @return builder
         * 
         */
        public Builder maxVcpus(Output<Integer> maxVcpus) {
            $.maxVcpus = maxVcpus;
            return this;
        }

        /**
         * @param maxVcpus The maximum number of EC2 vCPUs that an environment can reach.
         * 
         * @return builder
         * 
         */
        public Builder maxVcpus(Integer maxVcpus) {
            return maxVcpus(Output.of(maxVcpus));
        }

        /**
         * @param minVcpus The minimum number of EC2 vCPUs that an environment should maintain. For `EC2` or `SPOT` compute environments, if the parameter is not explicitly defined, a `0` default value will be set. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder minVcpus(@Nullable Output<Integer> minVcpus) {
            $.minVcpus = minVcpus;
            return this;
        }

        /**
         * @param minVcpus The minimum number of EC2 vCPUs that an environment should maintain. For `EC2` or `SPOT` compute environments, if the parameter is not explicitly defined, a `0` default value will be set. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder minVcpus(Integer minVcpus) {
            return minVcpus(Output.of(minVcpus));
        }

        /**
         * @param placementGroup The Amazon EC2 placement group to associate with your compute resources.
         * 
         * @return builder
         * 
         */
        public Builder placementGroup(@Nullable Output<String> placementGroup) {
            $.placementGroup = placementGroup;
            return this;
        }

        /**
         * @param placementGroup The Amazon EC2 placement group to associate with your compute resources.
         * 
         * @return builder
         * 
         */
        public Builder placementGroup(String placementGroup) {
            return placementGroup(Output.of(placementGroup));
        }

        /**
         * @param securityGroupIds A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(@Nullable Output<List<String>> securityGroupIds) {
            $.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * @param securityGroupIds A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(List<String> securityGroupIds) {
            return securityGroupIds(Output.of(securityGroupIds));
        }

        /**
         * @param securityGroupIds A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(String... securityGroupIds) {
            return securityGroupIds(List.of(securityGroupIds));
        }

        /**
         * @param spotIamFleetRole The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment. This parameter is required for SPOT compute environments. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder spotIamFleetRole(@Nullable Output<String> spotIamFleetRole) {
            $.spotIamFleetRole = spotIamFleetRole;
            return this;
        }

        /**
         * @param spotIamFleetRole The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment. This parameter is required for SPOT compute environments. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder spotIamFleetRole(String spotIamFleetRole) {
            return spotIamFleetRole(Output.of(spotIamFleetRole));
        }

        /**
         * @param subnets A list of VPC subnets into which the compute resources are launched.
         * 
         * @return builder
         * 
         */
        public Builder subnets(Output<List<String>> subnets) {
            $.subnets = subnets;
            return this;
        }

        /**
         * @param subnets A list of VPC subnets into which the compute resources are launched.
         * 
         * @return builder
         * 
         */
        public Builder subnets(List<String> subnets) {
            return subnets(Output.of(subnets));
        }

        /**
         * @param subnets A list of VPC subnets into which the compute resources are launched.
         * 
         * @return builder
         * 
         */
        public Builder subnets(String... subnets) {
            return subnets(List.of(subnets));
        }

        /**
         * @param tags Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn&#39;t applicable to jobs running on Fargate resources, and shouldn&#39;t be specified.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param type The type of compute environment. Valid items are `EC2`, `SPOT`, `FARGATE` or `FARGATE_SPOT`.
         * 
         * @return builder
         * 
         */
        public Builder type(Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type The type of compute environment. Valid items are `EC2`, `SPOT`, `FARGATE` or `FARGATE_SPOT`.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        public ComputeEnvironmentComputeResourcesArgs build() {
            $.maxVcpus = Objects.requireNonNull($.maxVcpus, "expected parameter 'maxVcpus' to be non-null");
            $.subnets = Objects.requireNonNull($.subnets, "expected parameter 'subnets' to be non-null");
            $.type = Objects.requireNonNull($.type, "expected parameter 'type' to be non-null");
            return $;
        }
    }

}
