// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.backup.inputs;

import com.pulumi.aws.backup.inputs.SelectionConditionArgs;
import com.pulumi.aws.backup.inputs.SelectionSelectionTagArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SelectionState extends com.pulumi.resources.ResourceArgs {

    public static final SelectionState Empty = new SelectionState();

    /**
     * A list of conditions that you define to assign resources to your backup plans using tags.
     * 
     */
    @Import(name="conditions")
    private @Nullable Output<List<SelectionConditionArgs>> conditions;

    /**
     * @return A list of conditions that you define to assign resources to your backup plans using tags.
     * 
     */
    public Optional<Output<List<SelectionConditionArgs>>> conditions() {
        return Optional.ofNullable(this.conditions);
    }

    /**
     * The ARN of the IAM role that AWS Backup uses to authenticate when restoring and backing up the target resource. See the [AWS Backup Developer Guide](https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#managed-policies) for additional information about using AWS managed policies or creating custom policies attached to the IAM role.
     * 
     */
    @Import(name="iamRoleArn")
    private @Nullable Output<String> iamRoleArn;

    /**
     * @return The ARN of the IAM role that AWS Backup uses to authenticate when restoring and backing up the target resource. See the [AWS Backup Developer Guide](https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#managed-policies) for additional information about using AWS managed policies or creating custom policies attached to the IAM role.
     * 
     */
    public Optional<Output<String>> iamRoleArn() {
        return Optional.ofNullable(this.iamRoleArn);
    }

    /**
     * The display name of a resource selection document.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The display name of a resource selection document.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to exclude from a backup plan.
     * 
     */
    @Import(name="notResources")
    private @Nullable Output<List<String>> notResources;

    /**
     * @return An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to exclude from a backup plan.
     * 
     */
    public Optional<Output<List<String>>> notResources() {
        return Optional.ofNullable(this.notResources);
    }

    /**
     * The backup plan ID to be associated with the selection of resources.
     * 
     */
    @Import(name="planId")
    private @Nullable Output<String> planId;

    /**
     * @return The backup plan ID to be associated with the selection of resources.
     * 
     */
    public Optional<Output<String>> planId() {
        return Optional.ofNullable(this.planId);
    }

    /**
     * An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to assign to a backup plan.
     * 
     */
    @Import(name="resources")
    private @Nullable Output<List<String>> resources;

    /**
     * @return An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to assign to a backup plan.
     * 
     */
    public Optional<Output<List<String>>> resources() {
        return Optional.ofNullable(this.resources);
    }

    /**
     * Tag-based conditions used to specify a set of resources to assign to a backup plan.
     * 
     */
    @Import(name="selectionTags")
    private @Nullable Output<List<SelectionSelectionTagArgs>> selectionTags;

    /**
     * @return Tag-based conditions used to specify a set of resources to assign to a backup plan.
     * 
     */
    public Optional<Output<List<SelectionSelectionTagArgs>>> selectionTags() {
        return Optional.ofNullable(this.selectionTags);
    }

    private SelectionState() {}

    private SelectionState(SelectionState $) {
        this.conditions = $.conditions;
        this.iamRoleArn = $.iamRoleArn;
        this.name = $.name;
        this.notResources = $.notResources;
        this.planId = $.planId;
        this.resources = $.resources;
        this.selectionTags = $.selectionTags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SelectionState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SelectionState $;

        public Builder() {
            $ = new SelectionState();
        }

        public Builder(SelectionState defaults) {
            $ = new SelectionState(Objects.requireNonNull(defaults));
        }

        /**
         * @param conditions A list of conditions that you define to assign resources to your backup plans using tags.
         * 
         * @return builder
         * 
         */
        public Builder conditions(@Nullable Output<List<SelectionConditionArgs>> conditions) {
            $.conditions = conditions;
            return this;
        }

        /**
         * @param conditions A list of conditions that you define to assign resources to your backup plans using tags.
         * 
         * @return builder
         * 
         */
        public Builder conditions(List<SelectionConditionArgs> conditions) {
            return conditions(Output.of(conditions));
        }

        /**
         * @param conditions A list of conditions that you define to assign resources to your backup plans using tags.
         * 
         * @return builder
         * 
         */
        public Builder conditions(SelectionConditionArgs... conditions) {
            return conditions(List.of(conditions));
        }

        /**
         * @param iamRoleArn The ARN of the IAM role that AWS Backup uses to authenticate when restoring and backing up the target resource. See the [AWS Backup Developer Guide](https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#managed-policies) for additional information about using AWS managed policies or creating custom policies attached to the IAM role.
         * 
         * @return builder
         * 
         */
        public Builder iamRoleArn(@Nullable Output<String> iamRoleArn) {
            $.iamRoleArn = iamRoleArn;
            return this;
        }

        /**
         * @param iamRoleArn The ARN of the IAM role that AWS Backup uses to authenticate when restoring and backing up the target resource. See the [AWS Backup Developer Guide](https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#managed-policies) for additional information about using AWS managed policies or creating custom policies attached to the IAM role.
         * 
         * @return builder
         * 
         */
        public Builder iamRoleArn(String iamRoleArn) {
            return iamRoleArn(Output.of(iamRoleArn));
        }

        /**
         * @param name The display name of a resource selection document.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The display name of a resource selection document.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param notResources An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to exclude from a backup plan.
         * 
         * @return builder
         * 
         */
        public Builder notResources(@Nullable Output<List<String>> notResources) {
            $.notResources = notResources;
            return this;
        }

        /**
         * @param notResources An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to exclude from a backup plan.
         * 
         * @return builder
         * 
         */
        public Builder notResources(List<String> notResources) {
            return notResources(Output.of(notResources));
        }

        /**
         * @param notResources An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to exclude from a backup plan.
         * 
         * @return builder
         * 
         */
        public Builder notResources(String... notResources) {
            return notResources(List.of(notResources));
        }

        /**
         * @param planId The backup plan ID to be associated with the selection of resources.
         * 
         * @return builder
         * 
         */
        public Builder planId(@Nullable Output<String> planId) {
            $.planId = planId;
            return this;
        }

        /**
         * @param planId The backup plan ID to be associated with the selection of resources.
         * 
         * @return builder
         * 
         */
        public Builder planId(String planId) {
            return planId(Output.of(planId));
        }

        /**
         * @param resources An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to assign to a backup plan.
         * 
         * @return builder
         * 
         */
        public Builder resources(@Nullable Output<List<String>> resources) {
            $.resources = resources;
            return this;
        }

        /**
         * @param resources An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to assign to a backup plan.
         * 
         * @return builder
         * 
         */
        public Builder resources(List<String> resources) {
            return resources(Output.of(resources));
        }

        /**
         * @param resources An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to assign to a backup plan.
         * 
         * @return builder
         * 
         */
        public Builder resources(String... resources) {
            return resources(List.of(resources));
        }

        /**
         * @param selectionTags Tag-based conditions used to specify a set of resources to assign to a backup plan.
         * 
         * @return builder
         * 
         */
        public Builder selectionTags(@Nullable Output<List<SelectionSelectionTagArgs>> selectionTags) {
            $.selectionTags = selectionTags;
            return this;
        }

        /**
         * @param selectionTags Tag-based conditions used to specify a set of resources to assign to a backup plan.
         * 
         * @return builder
         * 
         */
        public Builder selectionTags(List<SelectionSelectionTagArgs> selectionTags) {
            return selectionTags(Output.of(selectionTags));
        }

        /**
         * @param selectionTags Tag-based conditions used to specify a set of resources to assign to a backup plan.
         * 
         * @return builder
         * 
         */
        public Builder selectionTags(SelectionSelectionTagArgs... selectionTags) {
            return selectionTags(List.of(selectionTags));
        }

        public SelectionState build() {
            return $;
        }
    }

}
