// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.backup;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.backup.VaultLockConfigurationArgs;
import com.pulumi.aws.backup.inputs.VaultLockConfigurationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an AWS Backup vault lock configuration resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.VaultLockConfiguration;
 * import com.pulumi.aws.backup.VaultLockConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new VaultLockConfiguration(&#34;test&#34;, VaultLockConfigurationArgs.builder()        
 *             .backupVaultName(&#34;example_backup_vault&#34;)
 *             .changeableForDays(3)
 *             .maxRetentionDays(1200)
 *             .minRetentionDays(7)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Backup vault lock configuration using the `name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:backup/vaultLockConfiguration:VaultLockConfiguration test TestVault
 * ```
 * 
 */
@ResourceType(type="aws:backup/vaultLockConfiguration:VaultLockConfiguration")
public class VaultLockConfiguration extends com.pulumi.resources.CustomResource {
    /**
     * The ARN of the vault.
     * 
     */
    @Export(name="backupVaultArn", refs={String.class}, tree="[0]")
    private Output<String> backupVaultArn;

    /**
     * @return The ARN of the vault.
     * 
     */
    public Output<String> backupVaultArn() {
        return this.backupVaultArn;
    }
    /**
     * Name of the backup vault to add a lock configuration for.
     * 
     */
    @Export(name="backupVaultName", refs={String.class}, tree="[0]")
    private Output<String> backupVaultName;

    /**
     * @return Name of the backup vault to add a lock configuration for.
     * 
     */
    public Output<String> backupVaultName() {
        return this.backupVaultName;
    }
    /**
     * The number of days before the lock date. If omitted creates a vault lock in `governance` mode, otherwise it will create a vault lock in `compliance` mode.
     * 
     */
    @Export(name="changeableForDays", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> changeableForDays;

    /**
     * @return The number of days before the lock date. If omitted creates a vault lock in `governance` mode, otherwise it will create a vault lock in `compliance` mode.
     * 
     */
    public Output<Optional<Integer>> changeableForDays() {
        return Codegen.optional(this.changeableForDays);
    }
    /**
     * The maximum retention period that the vault retains its recovery points.
     * 
     */
    @Export(name="maxRetentionDays", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> maxRetentionDays;

    /**
     * @return The maximum retention period that the vault retains its recovery points.
     * 
     */
    public Output<Optional<Integer>> maxRetentionDays() {
        return Codegen.optional(this.maxRetentionDays);
    }
    /**
     * The minimum retention period that the vault retains its recovery points.
     * 
     */
    @Export(name="minRetentionDays", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> minRetentionDays;

    /**
     * @return The minimum retention period that the vault retains its recovery points.
     * 
     */
    public Output<Optional<Integer>> minRetentionDays() {
        return Codegen.optional(this.minRetentionDays);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public VaultLockConfiguration(String name) {
        this(name, VaultLockConfigurationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public VaultLockConfiguration(String name, VaultLockConfigurationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public VaultLockConfiguration(String name, VaultLockConfigurationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:backup/vaultLockConfiguration:VaultLockConfiguration", name, args == null ? VaultLockConfigurationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private VaultLockConfiguration(String name, Output<String> id, @Nullable VaultLockConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:backup/vaultLockConfiguration:VaultLockConfiguration", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static VaultLockConfiguration get(String name, Output<String> id, @Nullable VaultLockConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new VaultLockConfiguration(name, id, state, options);
    }
}
