// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.backup;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.backup.ReportPlanArgs;
import com.pulumi.aws.backup.inputs.ReportPlanState;
import com.pulumi.aws.backup.outputs.ReportPlanReportDeliveryChannel;
import com.pulumi.aws.backup.outputs.ReportPlanReportSetting;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an AWS Backup Report Plan resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.ReportPlan;
 * import com.pulumi.aws.backup.ReportPlanArgs;
 * import com.pulumi.aws.backup.inputs.ReportPlanReportDeliveryChannelArgs;
 * import com.pulumi.aws.backup.inputs.ReportPlanReportSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new ReportPlan(&#34;example&#34;, ReportPlanArgs.builder()        
 *             .description(&#34;example description&#34;)
 *             .reportDeliveryChannel(ReportPlanReportDeliveryChannelArgs.builder()
 *                 .formats(                
 *                     &#34;CSV&#34;,
 *                     &#34;JSON&#34;)
 *                 .s3BucketName(&#34;example-bucket-name&#34;)
 *                 .build())
 *             .reportSetting(ReportPlanReportSettingArgs.builder()
 *                 .reportTemplate(&#34;RESTORE_JOB_REPORT&#34;)
 *                 .build())
 *             .tags(Map.of(&#34;Name&#34;, &#34;Example Report Plan&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Backup Report Plan using the `id` which corresponds to the name of the Backup Report Plan. For example:
 * 
 * ```sh
 *  $ pulumi import aws:backup/reportPlan:ReportPlan test &lt;id&gt;
 * ```
 * 
 */
@ResourceType(type="aws:backup/reportPlan:ReportPlan")
public class ReportPlan extends com.pulumi.resources.CustomResource {
    /**
     * The ARN of the backup report plan.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The ARN of the backup report plan.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC).
     * 
     */
    @Export(name="creationTime", refs={String.class}, tree="[0]")
    private Output<String> creationTime;

    /**
     * @return The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC).
     * 
     */
    public Output<String> creationTime() {
        return this.creationTime;
    }
    /**
     * The deployment status of a report plan. The statuses are: `CREATE_IN_PROGRESS` | `UPDATE_IN_PROGRESS` | `DELETE_IN_PROGRESS` | `COMPLETED`.
     * 
     */
    @Export(name="deploymentStatus", refs={String.class}, tree="[0]")
    private Output<String> deploymentStatus;

    /**
     * @return The deployment status of a report plan. The statuses are: `CREATE_IN_PROGRESS` | `UPDATE_IN_PROGRESS` | `DELETE_IN_PROGRESS` | `COMPLETED`.
     * 
     */
    public Output<String> deploymentStatus() {
        return this.deploymentStatus;
    }
    /**
     * The description of the report plan with a maximum of 1,024 characters
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return The description of the report plan with a maximum of 1,024 characters
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * The unique name of the report plan. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The unique name of the report plan. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * An object that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports. Detailed below.
     * 
     */
    @Export(name="reportDeliveryChannel", refs={ReportPlanReportDeliveryChannel.class}, tree="[0]")
    private Output<ReportPlanReportDeliveryChannel> reportDeliveryChannel;

    /**
     * @return An object that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports. Detailed below.
     * 
     */
    public Output<ReportPlanReportDeliveryChannel> reportDeliveryChannel() {
        return this.reportDeliveryChannel;
    }
    /**
     * An object that identifies the report template for the report. Reports are built using a report template. Detailed below.
     * 
     */
    @Export(name="reportSetting", refs={ReportPlanReportSetting.class}, tree="[0]")
    private Output<ReportPlanReportSetting> reportSetting;

    /**
     * @return An object that identifies the report template for the report. Reports are built using a report template. Detailed below.
     * 
     */
    public Output<ReportPlanReportSetting> reportSetting() {
        return this.reportSetting;
    }
    /**
     * Metadata that you can assign to help organize the report plans you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Metadata that you can assign to help organize the report plans you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ReportPlan(String name) {
        this(name, ReportPlanArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ReportPlan(String name, ReportPlanArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ReportPlan(String name, ReportPlanArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:backup/reportPlan:ReportPlan", name, args == null ? ReportPlanArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ReportPlan(String name, Output<String> id, @Nullable ReportPlanState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:backup/reportPlan:ReportPlan", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ReportPlan get(String name, Output<String> id, @Nullable ReportPlanState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ReportPlan(name, id, state, options);
    }
}
