// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.autoscalingplans;

import com.pulumi.aws.autoscalingplans.inputs.ScalingPlanApplicationSourceArgs;
import com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ScalingPlanArgs extends com.pulumi.resources.ResourceArgs {

    public static final ScalingPlanArgs Empty = new ScalingPlanArgs();

    /**
     * CloudFormation stack or set of tags. You can create one scaling plan per application source.
     * 
     */
    @Import(name="applicationSource", required=true)
    private Output<ScalingPlanApplicationSourceArgs> applicationSource;

    /**
     * @return CloudFormation stack or set of tags. You can create one scaling plan per application source.
     * 
     */
    public Output<ScalingPlanApplicationSourceArgs> applicationSource() {
        return this.applicationSource;
    }

    /**
     * Name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Scaling instructions. More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html).
     * 
     */
    @Import(name="scalingInstructions", required=true)
    private Output<List<ScalingPlanScalingInstructionArgs>> scalingInstructions;

    /**
     * @return Scaling instructions. More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html).
     * 
     */
    public Output<List<ScalingPlanScalingInstructionArgs>> scalingInstructions() {
        return this.scalingInstructions;
    }

    private ScalingPlanArgs() {}

    private ScalingPlanArgs(ScalingPlanArgs $) {
        this.applicationSource = $.applicationSource;
        this.name = $.name;
        this.scalingInstructions = $.scalingInstructions;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ScalingPlanArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ScalingPlanArgs $;

        public Builder() {
            $ = new ScalingPlanArgs();
        }

        public Builder(ScalingPlanArgs defaults) {
            $ = new ScalingPlanArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param applicationSource CloudFormation stack or set of tags. You can create one scaling plan per application source.
         * 
         * @return builder
         * 
         */
        public Builder applicationSource(Output<ScalingPlanApplicationSourceArgs> applicationSource) {
            $.applicationSource = applicationSource;
            return this;
        }

        /**
         * @param applicationSource CloudFormation stack or set of tags. You can create one scaling plan per application source.
         * 
         * @return builder
         * 
         */
        public Builder applicationSource(ScalingPlanApplicationSourceArgs applicationSource) {
            return applicationSource(Output.of(applicationSource));
        }

        /**
         * @param name Name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param scalingInstructions Scaling instructions. More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html).
         * 
         * @return builder
         * 
         */
        public Builder scalingInstructions(Output<List<ScalingPlanScalingInstructionArgs>> scalingInstructions) {
            $.scalingInstructions = scalingInstructions;
            return this;
        }

        /**
         * @param scalingInstructions Scaling instructions. More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html).
         * 
         * @return builder
         * 
         */
        public Builder scalingInstructions(List<ScalingPlanScalingInstructionArgs> scalingInstructions) {
            return scalingInstructions(Output.of(scalingInstructions));
        }

        /**
         * @param scalingInstructions Scaling instructions. More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html).
         * 
         * @return builder
         * 
         */
        public Builder scalingInstructions(ScalingPlanScalingInstructionArgs... scalingInstructions) {
            return scalingInstructions(List.of(scalingInstructions));
        }

        public ScalingPlanArgs build() {
            $.applicationSource = Objects.requireNonNull($.applicationSource, "expected parameter 'applicationSource' to be non-null");
            $.scalingInstructions = Objects.requireNonNull($.scalingInstructions, "expected parameter 'scalingInstructions' to be non-null");
            return $;
        }
    }

}
