// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.autoscaling.outputs;

import com.pulumi.aws.autoscaling.outputs.GroupInstanceRefreshPreferences;
import com.pulumi.core.annotations.CustomType;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GroupInstanceRefresh {
    /**
     * @return Override default parameters for Instance Refresh.
     * 
     */
    private @Nullable GroupInstanceRefreshPreferences preferences;
    /**
     * @return Strategy to use for instance refresh. The only allowed value is `Rolling`. See [StartInstanceRefresh Action](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_StartInstanceRefresh.html#API_StartInstanceRefresh_RequestParameters) for more information.
     * 
     */
    private String strategy;
    /**
     * @return Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
     * 
     * &gt; **NOTE:** A refresh is started when any of the following Auto Scaling Group properties change: `launch_configuration`, `launch_template`, `mixed_instances_policy`. Additional properties can be specified in the `triggers` property of `instance_refresh`.
     * 
     * &gt; **NOTE:** A refresh will not start when `version = &#34;$Latest&#34;` is configured in the `launch_template` block. To trigger the instance refresh when a launch template is changed, configure `version` to use the `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource.
     * 
     * &gt; **NOTE:** Auto Scaling Groups support up to one active instance refresh at a time. When this resource is updated, any existing refresh is cancelled.
     * 
     * &gt; **NOTE:** Depending on health check settings and group size, an instance refresh may take a long time or fail. This resource does not wait for the instance refresh to complete.
     * 
     */
    private @Nullable List<String> triggers;

    private GroupInstanceRefresh() {}
    /**
     * @return Override default parameters for Instance Refresh.
     * 
     */
    public Optional<GroupInstanceRefreshPreferences> preferences() {
        return Optional.ofNullable(this.preferences);
    }
    /**
     * @return Strategy to use for instance refresh. The only allowed value is `Rolling`. See [StartInstanceRefresh Action](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_StartInstanceRefresh.html#API_StartInstanceRefresh_RequestParameters) for more information.
     * 
     */
    public String strategy() {
        return this.strategy;
    }
    /**
     * @return Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
     * 
     * &gt; **NOTE:** A refresh is started when any of the following Auto Scaling Group properties change: `launch_configuration`, `launch_template`, `mixed_instances_policy`. Additional properties can be specified in the `triggers` property of `instance_refresh`.
     * 
     * &gt; **NOTE:** A refresh will not start when `version = &#34;$Latest&#34;` is configured in the `launch_template` block. To trigger the instance refresh when a launch template is changed, configure `version` to use the `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource.
     * 
     * &gt; **NOTE:** Auto Scaling Groups support up to one active instance refresh at a time. When this resource is updated, any existing refresh is cancelled.
     * 
     * &gt; **NOTE:** Depending on health check settings and group size, an instance refresh may take a long time or fail. This resource does not wait for the instance refresh to complete.
     * 
     */
    public List<String> triggers() {
        return this.triggers == null ? List.of() : this.triggers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GroupInstanceRefresh defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable GroupInstanceRefreshPreferences preferences;
        private String strategy;
        private @Nullable List<String> triggers;
        public Builder() {}
        public Builder(GroupInstanceRefresh defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.preferences = defaults.preferences;
    	      this.strategy = defaults.strategy;
    	      this.triggers = defaults.triggers;
        }

        @CustomType.Setter
        public Builder preferences(@Nullable GroupInstanceRefreshPreferences preferences) {
            this.preferences = preferences;
            return this;
        }
        @CustomType.Setter
        public Builder strategy(String strategy) {
            this.strategy = Objects.requireNonNull(strategy);
            return this;
        }
        @CustomType.Setter
        public Builder triggers(@Nullable List<String> triggers) {
            this.triggers = triggers;
            return this;
        }
        public Builder triggers(String... triggers) {
            return triggers(List.of(triggers));
        }
        public GroupInstanceRefresh build() {
            final var o = new GroupInstanceRefresh();
            o.preferences = preferences;
            o.strategy = strategy;
            o.triggers = triggers;
            return o;
        }
    }
}
