// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.autoscaling.inputs;

import com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshPreferencesArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class GroupInstanceRefreshArgs extends com.pulumi.resources.ResourceArgs {

    public static final GroupInstanceRefreshArgs Empty = new GroupInstanceRefreshArgs();

    /**
     * Override default parameters for Instance Refresh.
     * 
     */
    @Import(name="preferences")
    private @Nullable Output<GroupInstanceRefreshPreferencesArgs> preferences;

    /**
     * @return Override default parameters for Instance Refresh.
     * 
     */
    public Optional<Output<GroupInstanceRefreshPreferencesArgs>> preferences() {
        return Optional.ofNullable(this.preferences);
    }

    /**
     * Strategy to use for instance refresh. The only allowed value is `Rolling`. See [StartInstanceRefresh Action](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_StartInstanceRefresh.html#API_StartInstanceRefresh_RequestParameters) for more information.
     * 
     */
    @Import(name="strategy", required=true)
    private Output<String> strategy;

    /**
     * @return Strategy to use for instance refresh. The only allowed value is `Rolling`. See [StartInstanceRefresh Action](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_StartInstanceRefresh.html#API_StartInstanceRefresh_RequestParameters) for more information.
     * 
     */
    public Output<String> strategy() {
        return this.strategy;
    }

    /**
     * Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
     * 
     * &gt; **NOTE:** A refresh is started when any of the following Auto Scaling Group properties change: `launch_configuration`, `launch_template`, `mixed_instances_policy`. Additional properties can be specified in the `triggers` property of `instance_refresh`.
     * 
     * &gt; **NOTE:** A refresh will not start when `version = &#34;$Latest&#34;` is configured in the `launch_template` block. To trigger the instance refresh when a launch template is changed, configure `version` to use the `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource.
     * 
     * &gt; **NOTE:** Auto Scaling Groups support up to one active instance refresh at a time. When this resource is updated, any existing refresh is cancelled.
     * 
     * &gt; **NOTE:** Depending on health check settings and group size, an instance refresh may take a long time or fail. This resource does not wait for the instance refresh to complete.
     * 
     */
    @Import(name="triggers")
    private @Nullable Output<List<String>> triggers;

    /**
     * @return Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
     * 
     * &gt; **NOTE:** A refresh is started when any of the following Auto Scaling Group properties change: `launch_configuration`, `launch_template`, `mixed_instances_policy`. Additional properties can be specified in the `triggers` property of `instance_refresh`.
     * 
     * &gt; **NOTE:** A refresh will not start when `version = &#34;$Latest&#34;` is configured in the `launch_template` block. To trigger the instance refresh when a launch template is changed, configure `version` to use the `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource.
     * 
     * &gt; **NOTE:** Auto Scaling Groups support up to one active instance refresh at a time. When this resource is updated, any existing refresh is cancelled.
     * 
     * &gt; **NOTE:** Depending on health check settings and group size, an instance refresh may take a long time or fail. This resource does not wait for the instance refresh to complete.
     * 
     */
    public Optional<Output<List<String>>> triggers() {
        return Optional.ofNullable(this.triggers);
    }

    private GroupInstanceRefreshArgs() {}

    private GroupInstanceRefreshArgs(GroupInstanceRefreshArgs $) {
        this.preferences = $.preferences;
        this.strategy = $.strategy;
        this.triggers = $.triggers;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(GroupInstanceRefreshArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private GroupInstanceRefreshArgs $;

        public Builder() {
            $ = new GroupInstanceRefreshArgs();
        }

        public Builder(GroupInstanceRefreshArgs defaults) {
            $ = new GroupInstanceRefreshArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param preferences Override default parameters for Instance Refresh.
         * 
         * @return builder
         * 
         */
        public Builder preferences(@Nullable Output<GroupInstanceRefreshPreferencesArgs> preferences) {
            $.preferences = preferences;
            return this;
        }

        /**
         * @param preferences Override default parameters for Instance Refresh.
         * 
         * @return builder
         * 
         */
        public Builder preferences(GroupInstanceRefreshPreferencesArgs preferences) {
            return preferences(Output.of(preferences));
        }

        /**
         * @param strategy Strategy to use for instance refresh. The only allowed value is `Rolling`. See [StartInstanceRefresh Action](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_StartInstanceRefresh.html#API_StartInstanceRefresh_RequestParameters) for more information.
         * 
         * @return builder
         * 
         */
        public Builder strategy(Output<String> strategy) {
            $.strategy = strategy;
            return this;
        }

        /**
         * @param strategy Strategy to use for instance refresh. The only allowed value is `Rolling`. See [StartInstanceRefresh Action](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_StartInstanceRefresh.html#API_StartInstanceRefresh_RequestParameters) for more information.
         * 
         * @return builder
         * 
         */
        public Builder strategy(String strategy) {
            return strategy(Output.of(strategy));
        }

        /**
         * @param triggers Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
         * 
         * &gt; **NOTE:** A refresh is started when any of the following Auto Scaling Group properties change: `launch_configuration`, `launch_template`, `mixed_instances_policy`. Additional properties can be specified in the `triggers` property of `instance_refresh`.
         * 
         * &gt; **NOTE:** A refresh will not start when `version = &#34;$Latest&#34;` is configured in the `launch_template` block. To trigger the instance refresh when a launch template is changed, configure `version` to use the `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource.
         * 
         * &gt; **NOTE:** Auto Scaling Groups support up to one active instance refresh at a time. When this resource is updated, any existing refresh is cancelled.
         * 
         * &gt; **NOTE:** Depending on health check settings and group size, an instance refresh may take a long time or fail. This resource does not wait for the instance refresh to complete.
         * 
         * @return builder
         * 
         */
        public Builder triggers(@Nullable Output<List<String>> triggers) {
            $.triggers = triggers;
            return this;
        }

        /**
         * @param triggers Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
         * 
         * &gt; **NOTE:** A refresh is started when any of the following Auto Scaling Group properties change: `launch_configuration`, `launch_template`, `mixed_instances_policy`. Additional properties can be specified in the `triggers` property of `instance_refresh`.
         * 
         * &gt; **NOTE:** A refresh will not start when `version = &#34;$Latest&#34;` is configured in the `launch_template` block. To trigger the instance refresh when a launch template is changed, configure `version` to use the `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource.
         * 
         * &gt; **NOTE:** Auto Scaling Groups support up to one active instance refresh at a time. When this resource is updated, any existing refresh is cancelled.
         * 
         * &gt; **NOTE:** Depending on health check settings and group size, an instance refresh may take a long time or fail. This resource does not wait for the instance refresh to complete.
         * 
         * @return builder
         * 
         */
        public Builder triggers(List<String> triggers) {
            return triggers(Output.of(triggers));
        }

        /**
         * @param triggers Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
         * 
         * &gt; **NOTE:** A refresh is started when any of the following Auto Scaling Group properties change: `launch_configuration`, `launch_template`, `mixed_instances_policy`. Additional properties can be specified in the `triggers` property of `instance_refresh`.
         * 
         * &gt; **NOTE:** A refresh will not start when `version = &#34;$Latest&#34;` is configured in the `launch_template` block. To trigger the instance refresh when a launch template is changed, configure `version` to use the `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource.
         * 
         * &gt; **NOTE:** Auto Scaling Groups support up to one active instance refresh at a time. When this resource is updated, any existing refresh is cancelled.
         * 
         * &gt; **NOTE:** Depending on health check settings and group size, an instance refresh may take a long time or fail. This resource does not wait for the instance refresh to complete.
         * 
         * @return builder
         * 
         */
        public Builder triggers(String... triggers) {
            return triggers(List.of(triggers));
        }

        public GroupInstanceRefreshArgs build() {
            $.strategy = Objects.requireNonNull($.strategy, "expected parameter 'strategy' to be non-null");
            return $;
        }
    }

}
