// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.autoscaling;

import com.pulumi.aws.autoscaling.enums.MetricsGranularity;
import com.pulumi.aws.autoscaling.inputs.GroupInitialLifecycleHookArgs;
import com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshArgs;
import com.pulumi.aws.autoscaling.inputs.GroupLaunchTemplateArgs;
import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyArgs;
import com.pulumi.aws.autoscaling.inputs.GroupTagArgs;
import com.pulumi.aws.autoscaling.inputs.GroupTrafficSourceArgs;
import com.pulumi.aws.autoscaling.inputs.GroupWarmPoolArgs;
import com.pulumi.core.Either;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class GroupArgs extends com.pulumi.resources.ResourceArgs {

    public static final GroupArgs Empty = new GroupArgs();

    /**
     * A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
     * 
     */
    @Import(name="availabilityZones")
    private @Nullable Output<List<String>> availabilityZones;

    /**
     * @return A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
     * 
     */
    public Optional<Output<List<String>>> availabilityZones() {
        return Optional.ofNullable(this.availabilityZones);
    }

    /**
     * Whether capacity rebalance is enabled. Otherwise, capacity rebalance is disabled.
     * 
     */
    @Import(name="capacityRebalance")
    private @Nullable Output<Boolean> capacityRebalance;

    /**
     * @return Whether capacity rebalance is enabled. Otherwise, capacity rebalance is disabled.
     * 
     */
    public Optional<Output<Boolean>> capacityRebalance() {
        return Optional.ofNullable(this.capacityRebalance);
    }

    /**
     * Reserved.
     * 
     */
    @Import(name="context")
    private @Nullable Output<String> context;

    /**
     * @return Reserved.
     * 
     */
    public Optional<Output<String>> context() {
        return Optional.ofNullable(this.context);
    }

    /**
     * Amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
     * 
     */
    @Import(name="defaultCooldown")
    private @Nullable Output<Integer> defaultCooldown;

    /**
     * @return Amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
     * 
     */
    public Optional<Output<Integer>> defaultCooldown() {
        return Optional.ofNullable(this.defaultCooldown);
    }

    /**
     * Amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the InService state. (See [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html))
     * 
     */
    @Import(name="defaultInstanceWarmup")
    private @Nullable Output<Integer> defaultInstanceWarmup;

    /**
     * @return Amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the InService state. (See [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html))
     * 
     */
    public Optional<Output<Integer>> defaultInstanceWarmup() {
        return Optional.ofNullable(this.defaultInstanceWarmup);
    }

    /**
     * Number of Amazon EC2 instances that
     * should be running in the group. (See also Waiting for
     * Capacity below.)
     * 
     */
    @Import(name="desiredCapacity")
    private @Nullable Output<Integer> desiredCapacity;

    /**
     * @return Number of Amazon EC2 instances that
     * should be running in the group. (See also Waiting for
     * Capacity below.)
     * 
     */
    public Optional<Output<Integer>> desiredCapacity() {
        return Optional.ofNullable(this.desiredCapacity);
    }

    /**
     * The unit of measurement for the value specified for `desired_capacity`. Supported for attribute-based instance type selection only. Valid values: `&#34;units&#34;`, `&#34;vcpu&#34;`, `&#34;memory-mib&#34;`.
     * 
     */
    @Import(name="desiredCapacityType")
    private @Nullable Output<String> desiredCapacityType;

    /**
     * @return The unit of measurement for the value specified for `desired_capacity`. Supported for attribute-based instance type selection only. Valid values: `&#34;units&#34;`, `&#34;vcpu&#34;`, `&#34;memory-mib&#34;`.
     * 
     */
    public Optional<Output<String>> desiredCapacityType() {
        return Optional.ofNullable(this.desiredCapacityType);
    }

    /**
     * List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
     * 
     */
    @Import(name="enabledMetrics")
    private @Nullable Output<List<String>> enabledMetrics;

    /**
     * @return List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
     * 
     */
    public Optional<Output<List<String>>> enabledMetrics() {
        return Optional.ofNullable(this.enabledMetrics);
    }

    /**
     * Allows deleting the Auto Scaling Group without waiting
     * for all instances in the pool to terminate. You can force an Auto Scaling Group to delete
     * even if it&#39;s in the process of scaling a resource. Normally, this provider
     * drains all the instances before deleting the group. This bypasses that
     * behavior and potentially leaves resources dangling.
     * 
     */
    @Import(name="forceDelete")
    private @Nullable Output<Boolean> forceDelete;

    /**
     * @return Allows deleting the Auto Scaling Group without waiting
     * for all instances in the pool to terminate. You can force an Auto Scaling Group to delete
     * even if it&#39;s in the process of scaling a resource. Normally, this provider
     * drains all the instances before deleting the group. This bypasses that
     * behavior and potentially leaves resources dangling.
     * 
     */
    public Optional<Output<Boolean>> forceDelete() {
        return Optional.ofNullable(this.forceDelete);
    }

    @Import(name="forceDeleteWarmPool")
    private @Nullable Output<Boolean> forceDeleteWarmPool;

    public Optional<Output<Boolean>> forceDeleteWarmPool() {
        return Optional.ofNullable(this.forceDeleteWarmPool);
    }

    /**
     * Time (in seconds) after instance comes into service before checking health.
     * 
     */
    @Import(name="healthCheckGracePeriod")
    private @Nullable Output<Integer> healthCheckGracePeriod;

    /**
     * @return Time (in seconds) after instance comes into service before checking health.
     * 
     */
    public Optional<Output<Integer>> healthCheckGracePeriod() {
        return Optional.ofNullable(this.healthCheckGracePeriod);
    }

    /**
     * &#34;EC2&#34; or &#34;ELB&#34;. Controls how health checking is done.
     * 
     */
    @Import(name="healthCheckType")
    private @Nullable Output<String> healthCheckType;

    /**
     * @return &#34;EC2&#34; or &#34;ELB&#34;. Controls how health checking is done.
     * 
     */
    public Optional<Output<String>> healthCheckType() {
        return Optional.ofNullable(this.healthCheckType);
    }

    /**
     * Whether to ignore failed [Auto Scaling scaling activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) while waiting for capacity. The default is `false` -- failed scaling activities cause errors to be returned.
     * 
     */
    @Import(name="ignoreFailedScalingActivities")
    private @Nullable Output<Boolean> ignoreFailedScalingActivities;

    /**
     * @return Whether to ignore failed [Auto Scaling scaling activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) while waiting for capacity. The default is `false` -- failed scaling activities cause errors to be returned.
     * 
     */
    public Optional<Output<Boolean>> ignoreFailedScalingActivities() {
        return Optional.ofNullable(this.ignoreFailedScalingActivities);
    }

    /**
     * One or more
     * [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
     * to attach to the Auto Scaling Group **before** instances are launched. The
     * syntax is exactly the same as the separate
     * `aws.autoscaling.LifecycleHook`
     * resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
     * a new Auto Scaling Group. For all other use-cases, please use `aws.autoscaling.LifecycleHook` resource.
     * 
     */
    @Import(name="initialLifecycleHooks")
    private @Nullable Output<List<GroupInitialLifecycleHookArgs>> initialLifecycleHooks;

    /**
     * @return One or more
     * [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
     * to attach to the Auto Scaling Group **before** instances are launched. The
     * syntax is exactly the same as the separate
     * `aws.autoscaling.LifecycleHook`
     * resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
     * a new Auto Scaling Group. For all other use-cases, please use `aws.autoscaling.LifecycleHook` resource.
     * 
     */
    public Optional<Output<List<GroupInitialLifecycleHookArgs>>> initialLifecycleHooks() {
        return Optional.ofNullable(this.initialLifecycleHooks);
    }

    /**
     * If this block is configured, start an
     * [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
     * when this Auto Scaling Group is updated. Defined below.
     * 
     */
    @Import(name="instanceRefresh")
    private @Nullable Output<GroupInstanceRefreshArgs> instanceRefresh;

    /**
     * @return If this block is configured, start an
     * [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
     * when this Auto Scaling Group is updated. Defined below.
     * 
     */
    public Optional<Output<GroupInstanceRefreshArgs>> instanceRefresh() {
        return Optional.ofNullable(this.instanceRefresh);
    }

    /**
     * Name of the launch configuration to use.
     * 
     */
    @Import(name="launchConfiguration")
    private @Nullable Output<String> launchConfiguration;

    /**
     * @return Name of the launch configuration to use.
     * 
     */
    public Optional<Output<String>> launchConfiguration() {
        return Optional.ofNullable(this.launchConfiguration);
    }

    /**
     * Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
     * 
     */
    @Import(name="launchTemplate")
    private @Nullable Output<GroupLaunchTemplateArgs> launchTemplate;

    /**
     * @return Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
     * 
     */
    public Optional<Output<GroupLaunchTemplateArgs>> launchTemplate() {
        return Optional.ofNullable(this.launchTemplate);
    }

    /**
     * List of elastic load balancer names to add to the autoscaling
     * group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
     * 
     */
    @Import(name="loadBalancers")
    private @Nullable Output<List<String>> loadBalancers;

    /**
     * @return List of elastic load balancer names to add to the autoscaling
     * group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
     * 
     */
    public Optional<Output<List<String>>> loadBalancers() {
        return Optional.ofNullable(this.loadBalancers);
    }

    /**
     * Maximum amount of time, in seconds, that an instance can be in service, values must be either equal to 0 or between 86400 and 31536000 seconds.
     * 
     */
    @Import(name="maxInstanceLifetime")
    private @Nullable Output<Integer> maxInstanceLifetime;

    /**
     * @return Maximum amount of time, in seconds, that an instance can be in service, values must be either equal to 0 or between 86400 and 31536000 seconds.
     * 
     */
    public Optional<Output<Integer>> maxInstanceLifetime() {
        return Optional.ofNullable(this.maxInstanceLifetime);
    }

    /**
     * Maximum size of the Auto Scaling Group.
     * 
     */
    @Import(name="maxSize", required=true)
    private Output<Integer> maxSize;

    /**
     * @return Maximum size of the Auto Scaling Group.
     * 
     */
    public Output<Integer> maxSize() {
        return this.maxSize;
    }

    /**
     * Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
     * 
     */
    @Import(name="metricsGranularity")
    private @Nullable Output<Either<String,MetricsGranularity>> metricsGranularity;

    /**
     * @return Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
     * 
     */
    public Optional<Output<Either<String,MetricsGranularity>>> metricsGranularity() {
        return Optional.ofNullable(this.metricsGranularity);
    }

    /**
     * Setting this causes Pulumi to wait for
     * this number of instances from this Auto Scaling Group to show up healthy in the
     * ELB only on creation. Updates will not wait on ELB instance number changes.
     * (See also Waiting for Capacity below.)
     * 
     */
    @Import(name="minElbCapacity")
    private @Nullable Output<Integer> minElbCapacity;

    /**
     * @return Setting this causes Pulumi to wait for
     * this number of instances from this Auto Scaling Group to show up healthy in the
     * ELB only on creation. Updates will not wait on ELB instance number changes.
     * (See also Waiting for Capacity below.)
     * 
     */
    public Optional<Output<Integer>> minElbCapacity() {
        return Optional.ofNullable(this.minElbCapacity);
    }

    /**
     * Minimum size of the Auto Scaling Group.
     * (See also Waiting for Capacity below.)
     * 
     */
    @Import(name="minSize", required=true)
    private Output<Integer> minSize;

    /**
     * @return Minimum size of the Auto Scaling Group.
     * (See also Waiting for Capacity below.)
     * 
     */
    public Output<Integer> minSize() {
        return this.minSize;
    }

    /**
     * Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
     * 
     */
    @Import(name="mixedInstancesPolicy")
    private @Nullable Output<GroupMixedInstancesPolicyArgs> mixedInstancesPolicy;

    /**
     * @return Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
     * 
     */
    public Optional<Output<GroupMixedInstancesPolicyArgs>> mixedInstancesPolicy() {
        return Optional.ofNullable(this.mixedInstancesPolicy);
    }

    /**
     * Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     * 
     */
    @Import(name="namePrefix")
    private @Nullable Output<String> namePrefix;

    /**
     * @return Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     * 
     */
    public Optional<Output<String>> namePrefix() {
        return Optional.ofNullable(this.namePrefix);
    }

    /**
     * Name of the placement group into which you&#39;ll launch your instances, if any.
     * 
     */
    @Import(name="placementGroup")
    private @Nullable Output<String> placementGroup;

    /**
     * @return Name of the placement group into which you&#39;ll launch your instances, if any.
     * 
     */
    public Optional<Output<String>> placementGroup() {
        return Optional.ofNullable(this.placementGroup);
    }

    /**
     * Whether newly launched instances
     * are automatically protected from termination by Amazon EC2 Auto Scaling when
     * scaling in. For more information about preventing instances from terminating
     * on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
     * in the Amazon EC2 Auto Scaling User Guide.
     * 
     */
    @Import(name="protectFromScaleIn")
    private @Nullable Output<Boolean> protectFromScaleIn;

    /**
     * @return Whether newly launched instances
     * are automatically protected from termination by Amazon EC2 Auto Scaling when
     * scaling in. For more information about preventing instances from terminating
     * on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
     * in the Amazon EC2 Auto Scaling User Guide.
     * 
     */
    public Optional<Output<Boolean>> protectFromScaleIn() {
        return Optional.ofNullable(this.protectFromScaleIn);
    }

    /**
     * ARN of the service-linked role that the ASG will use to call other AWS services
     * 
     */
    @Import(name="serviceLinkedRoleArn")
    private @Nullable Output<String> serviceLinkedRoleArn;

    /**
     * @return ARN of the service-linked role that the ASG will use to call other AWS services
     * 
     */
    public Optional<Output<String>> serviceLinkedRoleArn() {
        return Optional.ofNullable(this.serviceLinkedRoleArn);
    }

    /**
     * List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
     * Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
     * 
     */
    @Import(name="suspendedProcesses")
    private @Nullable Output<List<String>> suspendedProcesses;

    /**
     * @return List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
     * Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
     * 
     */
    public Optional<Output<List<String>>> suspendedProcesses() {
        return Optional.ofNullable(this.suspendedProcesses);
    }

    /**
     * Configuration block(s) containing resource tags. See Tag below for more details.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<List<GroupTagArgs>> tags;

    /**
     * @return Configuration block(s) containing resource tags. See Tag below for more details.
     * 
     */
    public Optional<Output<List<GroupTagArgs>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Set of `aws.alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
     * 
     */
    @Import(name="targetGroupArns")
    private @Nullable Output<List<String>> targetGroupArns;

    /**
     * @return Set of `aws.alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
     * 
     */
    public Optional<Output<List<String>>> targetGroupArns() {
        return Optional.ofNullable(this.targetGroupArns);
    }

    /**
     * List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
     * 
     */
    @Import(name="terminationPolicies")
    private @Nullable Output<List<String>> terminationPolicies;

    /**
     * @return List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
     * 
     */
    public Optional<Output<List<String>>> terminationPolicies() {
        return Optional.ofNullable(this.terminationPolicies);
    }

    /**
     * Attaches one or more traffic sources to the specified Auto Scaling group.
     * 
     */
    @Import(name="trafficSources")
    private @Nullable Output<List<GroupTrafficSourceArgs>> trafficSources;

    /**
     * @return Attaches one or more traffic sources to the specified Auto Scaling group.
     * 
     */
    public Optional<Output<List<GroupTrafficSourceArgs>>> trafficSources() {
        return Optional.ofNullable(this.trafficSources);
    }

    /**
     * List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
     * 
     */
    @Import(name="vpcZoneIdentifiers")
    private @Nullable Output<List<String>> vpcZoneIdentifiers;

    /**
     * @return List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
     * 
     */
    public Optional<Output<List<String>>> vpcZoneIdentifiers() {
        return Optional.ofNullable(this.vpcZoneIdentifiers);
    }

    /**
     * Maximum
     * [duration](https://golang.org/pkg/time/#ParseDuration) that the provider should
     * wait for ASG instances to be healthy before timing out. (See also Waiting
     * for Capacity below.) Setting this to &#34;0&#34; causes
     * the provider to skip all Capacity Waiting behavior.
     * 
     */
    @Import(name="waitForCapacityTimeout")
    private @Nullable Output<String> waitForCapacityTimeout;

    /**
     * @return Maximum
     * [duration](https://golang.org/pkg/time/#ParseDuration) that the provider should
     * wait for ASG instances to be healthy before timing out. (See also Waiting
     * for Capacity below.) Setting this to &#34;0&#34; causes
     * the provider to skip all Capacity Waiting behavior.
     * 
     */
    public Optional<Output<String>> waitForCapacityTimeout() {
        return Optional.ofNullable(this.waitForCapacityTimeout);
    }

    /**
     * Setting this will cause Pulumi to wait
     * for exactly this number of healthy instances from this Auto Scaling Group in
     * all attached load balancers on both create and update operations. (Takes
     * precedence over `min_elb_capacity` behavior.)
     * (See also Waiting for Capacity below.)
     * 
     */
    @Import(name="waitForElbCapacity")
    private @Nullable Output<Integer> waitForElbCapacity;

    /**
     * @return Setting this will cause Pulumi to wait
     * for exactly this number of healthy instances from this Auto Scaling Group in
     * all attached load balancers on both create and update operations. (Takes
     * precedence over `min_elb_capacity` behavior.)
     * (See also Waiting for Capacity below.)
     * 
     */
    public Optional<Output<Integer>> waitForElbCapacity() {
        return Optional.ofNullable(this.waitForElbCapacity);
    }

    /**
     * If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
     * to the specified Auto Scaling group. Defined below
     * 
     */
    @Import(name="warmPool")
    private @Nullable Output<GroupWarmPoolArgs> warmPool;

    /**
     * @return If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
     * to the specified Auto Scaling group. Defined below
     * 
     */
    public Optional<Output<GroupWarmPoolArgs>> warmPool() {
        return Optional.ofNullable(this.warmPool);
    }

    private GroupArgs() {}

    private GroupArgs(GroupArgs $) {
        this.availabilityZones = $.availabilityZones;
        this.capacityRebalance = $.capacityRebalance;
        this.context = $.context;
        this.defaultCooldown = $.defaultCooldown;
        this.defaultInstanceWarmup = $.defaultInstanceWarmup;
        this.desiredCapacity = $.desiredCapacity;
        this.desiredCapacityType = $.desiredCapacityType;
        this.enabledMetrics = $.enabledMetrics;
        this.forceDelete = $.forceDelete;
        this.forceDeleteWarmPool = $.forceDeleteWarmPool;
        this.healthCheckGracePeriod = $.healthCheckGracePeriod;
        this.healthCheckType = $.healthCheckType;
        this.ignoreFailedScalingActivities = $.ignoreFailedScalingActivities;
        this.initialLifecycleHooks = $.initialLifecycleHooks;
        this.instanceRefresh = $.instanceRefresh;
        this.launchConfiguration = $.launchConfiguration;
        this.launchTemplate = $.launchTemplate;
        this.loadBalancers = $.loadBalancers;
        this.maxInstanceLifetime = $.maxInstanceLifetime;
        this.maxSize = $.maxSize;
        this.metricsGranularity = $.metricsGranularity;
        this.minElbCapacity = $.minElbCapacity;
        this.minSize = $.minSize;
        this.mixedInstancesPolicy = $.mixedInstancesPolicy;
        this.name = $.name;
        this.namePrefix = $.namePrefix;
        this.placementGroup = $.placementGroup;
        this.protectFromScaleIn = $.protectFromScaleIn;
        this.serviceLinkedRoleArn = $.serviceLinkedRoleArn;
        this.suspendedProcesses = $.suspendedProcesses;
        this.tags = $.tags;
        this.targetGroupArns = $.targetGroupArns;
        this.terminationPolicies = $.terminationPolicies;
        this.trafficSources = $.trafficSources;
        this.vpcZoneIdentifiers = $.vpcZoneIdentifiers;
        this.waitForCapacityTimeout = $.waitForCapacityTimeout;
        this.waitForElbCapacity = $.waitForElbCapacity;
        this.warmPool = $.warmPool;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(GroupArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private GroupArgs $;

        public Builder() {
            $ = new GroupArgs();
        }

        public Builder(GroupArgs defaults) {
            $ = new GroupArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param availabilityZones A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZones(@Nullable Output<List<String>> availabilityZones) {
            $.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * @param availabilityZones A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZones(List<String> availabilityZones) {
            return availabilityZones(Output.of(availabilityZones));
        }

        /**
         * @param availabilityZones A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZones(String... availabilityZones) {
            return availabilityZones(List.of(availabilityZones));
        }

        /**
         * @param capacityRebalance Whether capacity rebalance is enabled. Otherwise, capacity rebalance is disabled.
         * 
         * @return builder
         * 
         */
        public Builder capacityRebalance(@Nullable Output<Boolean> capacityRebalance) {
            $.capacityRebalance = capacityRebalance;
            return this;
        }

        /**
         * @param capacityRebalance Whether capacity rebalance is enabled. Otherwise, capacity rebalance is disabled.
         * 
         * @return builder
         * 
         */
        public Builder capacityRebalance(Boolean capacityRebalance) {
            return capacityRebalance(Output.of(capacityRebalance));
        }

        /**
         * @param context Reserved.
         * 
         * @return builder
         * 
         */
        public Builder context(@Nullable Output<String> context) {
            $.context = context;
            return this;
        }

        /**
         * @param context Reserved.
         * 
         * @return builder
         * 
         */
        public Builder context(String context) {
            return context(Output.of(context));
        }

        /**
         * @param defaultCooldown Amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
         * 
         * @return builder
         * 
         */
        public Builder defaultCooldown(@Nullable Output<Integer> defaultCooldown) {
            $.defaultCooldown = defaultCooldown;
            return this;
        }

        /**
         * @param defaultCooldown Amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
         * 
         * @return builder
         * 
         */
        public Builder defaultCooldown(Integer defaultCooldown) {
            return defaultCooldown(Output.of(defaultCooldown));
        }

        /**
         * @param defaultInstanceWarmup Amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the InService state. (See [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html))
         * 
         * @return builder
         * 
         */
        public Builder defaultInstanceWarmup(@Nullable Output<Integer> defaultInstanceWarmup) {
            $.defaultInstanceWarmup = defaultInstanceWarmup;
            return this;
        }

        /**
         * @param defaultInstanceWarmup Amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the InService state. (See [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html))
         * 
         * @return builder
         * 
         */
        public Builder defaultInstanceWarmup(Integer defaultInstanceWarmup) {
            return defaultInstanceWarmup(Output.of(defaultInstanceWarmup));
        }

        /**
         * @param desiredCapacity Number of Amazon EC2 instances that
         * should be running in the group. (See also Waiting for
         * Capacity below.)
         * 
         * @return builder
         * 
         */
        public Builder desiredCapacity(@Nullable Output<Integer> desiredCapacity) {
            $.desiredCapacity = desiredCapacity;
            return this;
        }

        /**
         * @param desiredCapacity Number of Amazon EC2 instances that
         * should be running in the group. (See also Waiting for
         * Capacity below.)
         * 
         * @return builder
         * 
         */
        public Builder desiredCapacity(Integer desiredCapacity) {
            return desiredCapacity(Output.of(desiredCapacity));
        }

        /**
         * @param desiredCapacityType The unit of measurement for the value specified for `desired_capacity`. Supported for attribute-based instance type selection only. Valid values: `&#34;units&#34;`, `&#34;vcpu&#34;`, `&#34;memory-mib&#34;`.
         * 
         * @return builder
         * 
         */
        public Builder desiredCapacityType(@Nullable Output<String> desiredCapacityType) {
            $.desiredCapacityType = desiredCapacityType;
            return this;
        }

        /**
         * @param desiredCapacityType The unit of measurement for the value specified for `desired_capacity`. Supported for attribute-based instance type selection only. Valid values: `&#34;units&#34;`, `&#34;vcpu&#34;`, `&#34;memory-mib&#34;`.
         * 
         * @return builder
         * 
         */
        public Builder desiredCapacityType(String desiredCapacityType) {
            return desiredCapacityType(Output.of(desiredCapacityType));
        }

        /**
         * @param enabledMetrics List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
         * 
         * @return builder
         * 
         */
        public Builder enabledMetrics(@Nullable Output<List<String>> enabledMetrics) {
            $.enabledMetrics = enabledMetrics;
            return this;
        }

        /**
         * @param enabledMetrics List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
         * 
         * @return builder
         * 
         */
        public Builder enabledMetrics(List<String> enabledMetrics) {
            return enabledMetrics(Output.of(enabledMetrics));
        }

        /**
         * @param enabledMetrics List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
         * 
         * @return builder
         * 
         */
        public Builder enabledMetrics(String... enabledMetrics) {
            return enabledMetrics(List.of(enabledMetrics));
        }

        /**
         * @param forceDelete Allows deleting the Auto Scaling Group without waiting
         * for all instances in the pool to terminate. You can force an Auto Scaling Group to delete
         * even if it&#39;s in the process of scaling a resource. Normally, this provider
         * drains all the instances before deleting the group. This bypasses that
         * behavior and potentially leaves resources dangling.
         * 
         * @return builder
         * 
         */
        public Builder forceDelete(@Nullable Output<Boolean> forceDelete) {
            $.forceDelete = forceDelete;
            return this;
        }

        /**
         * @param forceDelete Allows deleting the Auto Scaling Group without waiting
         * for all instances in the pool to terminate. You can force an Auto Scaling Group to delete
         * even if it&#39;s in the process of scaling a resource. Normally, this provider
         * drains all the instances before deleting the group. This bypasses that
         * behavior and potentially leaves resources dangling.
         * 
         * @return builder
         * 
         */
        public Builder forceDelete(Boolean forceDelete) {
            return forceDelete(Output.of(forceDelete));
        }

        public Builder forceDeleteWarmPool(@Nullable Output<Boolean> forceDeleteWarmPool) {
            $.forceDeleteWarmPool = forceDeleteWarmPool;
            return this;
        }

        public Builder forceDeleteWarmPool(Boolean forceDeleteWarmPool) {
            return forceDeleteWarmPool(Output.of(forceDeleteWarmPool));
        }

        /**
         * @param healthCheckGracePeriod Time (in seconds) after instance comes into service before checking health.
         * 
         * @return builder
         * 
         */
        public Builder healthCheckGracePeriod(@Nullable Output<Integer> healthCheckGracePeriod) {
            $.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        /**
         * @param healthCheckGracePeriod Time (in seconds) after instance comes into service before checking health.
         * 
         * @return builder
         * 
         */
        public Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            return healthCheckGracePeriod(Output.of(healthCheckGracePeriod));
        }

        /**
         * @param healthCheckType &#34;EC2&#34; or &#34;ELB&#34;. Controls how health checking is done.
         * 
         * @return builder
         * 
         */
        public Builder healthCheckType(@Nullable Output<String> healthCheckType) {
            $.healthCheckType = healthCheckType;
            return this;
        }

        /**
         * @param healthCheckType &#34;EC2&#34; or &#34;ELB&#34;. Controls how health checking is done.
         * 
         * @return builder
         * 
         */
        public Builder healthCheckType(String healthCheckType) {
            return healthCheckType(Output.of(healthCheckType));
        }

        /**
         * @param ignoreFailedScalingActivities Whether to ignore failed [Auto Scaling scaling activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) while waiting for capacity. The default is `false` -- failed scaling activities cause errors to be returned.
         * 
         * @return builder
         * 
         */
        public Builder ignoreFailedScalingActivities(@Nullable Output<Boolean> ignoreFailedScalingActivities) {
            $.ignoreFailedScalingActivities = ignoreFailedScalingActivities;
            return this;
        }

        /**
         * @param ignoreFailedScalingActivities Whether to ignore failed [Auto Scaling scaling activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) while waiting for capacity. The default is `false` -- failed scaling activities cause errors to be returned.
         * 
         * @return builder
         * 
         */
        public Builder ignoreFailedScalingActivities(Boolean ignoreFailedScalingActivities) {
            return ignoreFailedScalingActivities(Output.of(ignoreFailedScalingActivities));
        }

        /**
         * @param initialLifecycleHooks One or more
         * [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
         * to attach to the Auto Scaling Group **before** instances are launched. The
         * syntax is exactly the same as the separate
         * `aws.autoscaling.LifecycleHook`
         * resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
         * a new Auto Scaling Group. For all other use-cases, please use `aws.autoscaling.LifecycleHook` resource.
         * 
         * @return builder
         * 
         */
        public Builder initialLifecycleHooks(@Nullable Output<List<GroupInitialLifecycleHookArgs>> initialLifecycleHooks) {
            $.initialLifecycleHooks = initialLifecycleHooks;
            return this;
        }

        /**
         * @param initialLifecycleHooks One or more
         * [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
         * to attach to the Auto Scaling Group **before** instances are launched. The
         * syntax is exactly the same as the separate
         * `aws.autoscaling.LifecycleHook`
         * resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
         * a new Auto Scaling Group. For all other use-cases, please use `aws.autoscaling.LifecycleHook` resource.
         * 
         * @return builder
         * 
         */
        public Builder initialLifecycleHooks(List<GroupInitialLifecycleHookArgs> initialLifecycleHooks) {
            return initialLifecycleHooks(Output.of(initialLifecycleHooks));
        }

        /**
         * @param initialLifecycleHooks One or more
         * [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
         * to attach to the Auto Scaling Group **before** instances are launched. The
         * syntax is exactly the same as the separate
         * `aws.autoscaling.LifecycleHook`
         * resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
         * a new Auto Scaling Group. For all other use-cases, please use `aws.autoscaling.LifecycleHook` resource.
         * 
         * @return builder
         * 
         */
        public Builder initialLifecycleHooks(GroupInitialLifecycleHookArgs... initialLifecycleHooks) {
            return initialLifecycleHooks(List.of(initialLifecycleHooks));
        }

        /**
         * @param instanceRefresh If this block is configured, start an
         * [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
         * when this Auto Scaling Group is updated. Defined below.
         * 
         * @return builder
         * 
         */
        public Builder instanceRefresh(@Nullable Output<GroupInstanceRefreshArgs> instanceRefresh) {
            $.instanceRefresh = instanceRefresh;
            return this;
        }

        /**
         * @param instanceRefresh If this block is configured, start an
         * [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
         * when this Auto Scaling Group is updated. Defined below.
         * 
         * @return builder
         * 
         */
        public Builder instanceRefresh(GroupInstanceRefreshArgs instanceRefresh) {
            return instanceRefresh(Output.of(instanceRefresh));
        }

        /**
         * @param launchConfiguration Name of the launch configuration to use.
         * 
         * @return builder
         * 
         */
        public Builder launchConfiguration(@Nullable Output<String> launchConfiguration) {
            $.launchConfiguration = launchConfiguration;
            return this;
        }

        /**
         * @param launchConfiguration Name of the launch configuration to use.
         * 
         * @return builder
         * 
         */
        public Builder launchConfiguration(String launchConfiguration) {
            return launchConfiguration(Output.of(launchConfiguration));
        }

        /**
         * @param launchTemplate Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
         * 
         * @return builder
         * 
         */
        public Builder launchTemplate(@Nullable Output<GroupLaunchTemplateArgs> launchTemplate) {
            $.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * @param launchTemplate Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
         * 
         * @return builder
         * 
         */
        public Builder launchTemplate(GroupLaunchTemplateArgs launchTemplate) {
            return launchTemplate(Output.of(launchTemplate));
        }

        /**
         * @param loadBalancers List of elastic load balancer names to add to the autoscaling
         * group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
         * 
         * @return builder
         * 
         */
        public Builder loadBalancers(@Nullable Output<List<String>> loadBalancers) {
            $.loadBalancers = loadBalancers;
            return this;
        }

        /**
         * @param loadBalancers List of elastic load balancer names to add to the autoscaling
         * group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
         * 
         * @return builder
         * 
         */
        public Builder loadBalancers(List<String> loadBalancers) {
            return loadBalancers(Output.of(loadBalancers));
        }

        /**
         * @param loadBalancers List of elastic load balancer names to add to the autoscaling
         * group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
         * 
         * @return builder
         * 
         */
        public Builder loadBalancers(String... loadBalancers) {
            return loadBalancers(List.of(loadBalancers));
        }

        /**
         * @param maxInstanceLifetime Maximum amount of time, in seconds, that an instance can be in service, values must be either equal to 0 or between 86400 and 31536000 seconds.
         * 
         * @return builder
         * 
         */
        public Builder maxInstanceLifetime(@Nullable Output<Integer> maxInstanceLifetime) {
            $.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        /**
         * @param maxInstanceLifetime Maximum amount of time, in seconds, that an instance can be in service, values must be either equal to 0 or between 86400 and 31536000 seconds.
         * 
         * @return builder
         * 
         */
        public Builder maxInstanceLifetime(Integer maxInstanceLifetime) {
            return maxInstanceLifetime(Output.of(maxInstanceLifetime));
        }

        /**
         * @param maxSize Maximum size of the Auto Scaling Group.
         * 
         * @return builder
         * 
         */
        public Builder maxSize(Output<Integer> maxSize) {
            $.maxSize = maxSize;
            return this;
        }

        /**
         * @param maxSize Maximum size of the Auto Scaling Group.
         * 
         * @return builder
         * 
         */
        public Builder maxSize(Integer maxSize) {
            return maxSize(Output.of(maxSize));
        }

        /**
         * @param metricsGranularity Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
         * 
         * @return builder
         * 
         */
        public Builder metricsGranularity(@Nullable Output<Either<String,MetricsGranularity>> metricsGranularity) {
            $.metricsGranularity = metricsGranularity;
            return this;
        }

        /**
         * @param metricsGranularity Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
         * 
         * @return builder
         * 
         */
        public Builder metricsGranularity(Either<String,MetricsGranularity> metricsGranularity) {
            return metricsGranularity(Output.of(metricsGranularity));
        }

        /**
         * @param metricsGranularity Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
         * 
         * @return builder
         * 
         */
        public Builder metricsGranularity(String metricsGranularity) {
            return metricsGranularity(Either.ofLeft(metricsGranularity));
        }

        /**
         * @param metricsGranularity Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
         * 
         * @return builder
         * 
         */
        public Builder metricsGranularity(MetricsGranularity metricsGranularity) {
            return metricsGranularity(Either.ofRight(metricsGranularity));
        }

        /**
         * @param minElbCapacity Setting this causes Pulumi to wait for
         * this number of instances from this Auto Scaling Group to show up healthy in the
         * ELB only on creation. Updates will not wait on ELB instance number changes.
         * (See also Waiting for Capacity below.)
         * 
         * @return builder
         * 
         */
        public Builder minElbCapacity(@Nullable Output<Integer> minElbCapacity) {
            $.minElbCapacity = minElbCapacity;
            return this;
        }

        /**
         * @param minElbCapacity Setting this causes Pulumi to wait for
         * this number of instances from this Auto Scaling Group to show up healthy in the
         * ELB only on creation. Updates will not wait on ELB instance number changes.
         * (See also Waiting for Capacity below.)
         * 
         * @return builder
         * 
         */
        public Builder minElbCapacity(Integer minElbCapacity) {
            return minElbCapacity(Output.of(minElbCapacity));
        }

        /**
         * @param minSize Minimum size of the Auto Scaling Group.
         * (See also Waiting for Capacity below.)
         * 
         * @return builder
         * 
         */
        public Builder minSize(Output<Integer> minSize) {
            $.minSize = minSize;
            return this;
        }

        /**
         * @param minSize Minimum size of the Auto Scaling Group.
         * (See also Waiting for Capacity below.)
         * 
         * @return builder
         * 
         */
        public Builder minSize(Integer minSize) {
            return minSize(Output.of(minSize));
        }

        /**
         * @param mixedInstancesPolicy Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
         * 
         * @return builder
         * 
         */
        public Builder mixedInstancesPolicy(@Nullable Output<GroupMixedInstancesPolicyArgs> mixedInstancesPolicy) {
            $.mixedInstancesPolicy = mixedInstancesPolicy;
            return this;
        }

        /**
         * @param mixedInstancesPolicy Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
         * 
         * @return builder
         * 
         */
        public Builder mixedInstancesPolicy(GroupMixedInstancesPolicyArgs mixedInstancesPolicy) {
            return mixedInstancesPolicy(Output.of(mixedInstancesPolicy));
        }

        /**
         * @param name Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param namePrefix Creates a unique name beginning with the specified
         * prefix. Conflicts with `name`.
         * 
         * @return builder
         * 
         */
        public Builder namePrefix(@Nullable Output<String> namePrefix) {
            $.namePrefix = namePrefix;
            return this;
        }

        /**
         * @param namePrefix Creates a unique name beginning with the specified
         * prefix. Conflicts with `name`.
         * 
         * @return builder
         * 
         */
        public Builder namePrefix(String namePrefix) {
            return namePrefix(Output.of(namePrefix));
        }

        /**
         * @param placementGroup Name of the placement group into which you&#39;ll launch your instances, if any.
         * 
         * @return builder
         * 
         */
        public Builder placementGroup(@Nullable Output<String> placementGroup) {
            $.placementGroup = placementGroup;
            return this;
        }

        /**
         * @param placementGroup Name of the placement group into which you&#39;ll launch your instances, if any.
         * 
         * @return builder
         * 
         */
        public Builder placementGroup(String placementGroup) {
            return placementGroup(Output.of(placementGroup));
        }

        /**
         * @param protectFromScaleIn Whether newly launched instances
         * are automatically protected from termination by Amazon EC2 Auto Scaling when
         * scaling in. For more information about preventing instances from terminating
         * on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
         * in the Amazon EC2 Auto Scaling User Guide.
         * 
         * @return builder
         * 
         */
        public Builder protectFromScaleIn(@Nullable Output<Boolean> protectFromScaleIn) {
            $.protectFromScaleIn = protectFromScaleIn;
            return this;
        }

        /**
         * @param protectFromScaleIn Whether newly launched instances
         * are automatically protected from termination by Amazon EC2 Auto Scaling when
         * scaling in. For more information about preventing instances from terminating
         * on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
         * in the Amazon EC2 Auto Scaling User Guide.
         * 
         * @return builder
         * 
         */
        public Builder protectFromScaleIn(Boolean protectFromScaleIn) {
            return protectFromScaleIn(Output.of(protectFromScaleIn));
        }

        /**
         * @param serviceLinkedRoleArn ARN of the service-linked role that the ASG will use to call other AWS services
         * 
         * @return builder
         * 
         */
        public Builder serviceLinkedRoleArn(@Nullable Output<String> serviceLinkedRoleArn) {
            $.serviceLinkedRoleArn = serviceLinkedRoleArn;
            return this;
        }

        /**
         * @param serviceLinkedRoleArn ARN of the service-linked role that the ASG will use to call other AWS services
         * 
         * @return builder
         * 
         */
        public Builder serviceLinkedRoleArn(String serviceLinkedRoleArn) {
            return serviceLinkedRoleArn(Output.of(serviceLinkedRoleArn));
        }

        /**
         * @param suspendedProcesses List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
         * Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
         * 
         * @return builder
         * 
         */
        public Builder suspendedProcesses(@Nullable Output<List<String>> suspendedProcesses) {
            $.suspendedProcesses = suspendedProcesses;
            return this;
        }

        /**
         * @param suspendedProcesses List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
         * Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
         * 
         * @return builder
         * 
         */
        public Builder suspendedProcesses(List<String> suspendedProcesses) {
            return suspendedProcesses(Output.of(suspendedProcesses));
        }

        /**
         * @param suspendedProcesses List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
         * Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
         * 
         * @return builder
         * 
         */
        public Builder suspendedProcesses(String... suspendedProcesses) {
            return suspendedProcesses(List.of(suspendedProcesses));
        }

        /**
         * @param tags Configuration block(s) containing resource tags. See Tag below for more details.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<List<GroupTagArgs>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Configuration block(s) containing resource tags. See Tag below for more details.
         * 
         * @return builder
         * 
         */
        public Builder tags(List<GroupTagArgs> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tags Configuration block(s) containing resource tags. See Tag below for more details.
         * 
         * @return builder
         * 
         */
        public Builder tags(GroupTagArgs... tags) {
            return tags(List.of(tags));
        }

        /**
         * @param targetGroupArns Set of `aws.alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
         * 
         * @return builder
         * 
         */
        public Builder targetGroupArns(@Nullable Output<List<String>> targetGroupArns) {
            $.targetGroupArns = targetGroupArns;
            return this;
        }

        /**
         * @param targetGroupArns Set of `aws.alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
         * 
         * @return builder
         * 
         */
        public Builder targetGroupArns(List<String> targetGroupArns) {
            return targetGroupArns(Output.of(targetGroupArns));
        }

        /**
         * @param targetGroupArns Set of `aws.alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
         * 
         * @return builder
         * 
         */
        public Builder targetGroupArns(String... targetGroupArns) {
            return targetGroupArns(List.of(targetGroupArns));
        }

        /**
         * @param terminationPolicies List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
         * 
         * @return builder
         * 
         */
        public Builder terminationPolicies(@Nullable Output<List<String>> terminationPolicies) {
            $.terminationPolicies = terminationPolicies;
            return this;
        }

        /**
         * @param terminationPolicies List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
         * 
         * @return builder
         * 
         */
        public Builder terminationPolicies(List<String> terminationPolicies) {
            return terminationPolicies(Output.of(terminationPolicies));
        }

        /**
         * @param terminationPolicies List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
         * 
         * @return builder
         * 
         */
        public Builder terminationPolicies(String... terminationPolicies) {
            return terminationPolicies(List.of(terminationPolicies));
        }

        /**
         * @param trafficSources Attaches one or more traffic sources to the specified Auto Scaling group.
         * 
         * @return builder
         * 
         */
        public Builder trafficSources(@Nullable Output<List<GroupTrafficSourceArgs>> trafficSources) {
            $.trafficSources = trafficSources;
            return this;
        }

        /**
         * @param trafficSources Attaches one or more traffic sources to the specified Auto Scaling group.
         * 
         * @return builder
         * 
         */
        public Builder trafficSources(List<GroupTrafficSourceArgs> trafficSources) {
            return trafficSources(Output.of(trafficSources));
        }

        /**
         * @param trafficSources Attaches one or more traffic sources to the specified Auto Scaling group.
         * 
         * @return builder
         * 
         */
        public Builder trafficSources(GroupTrafficSourceArgs... trafficSources) {
            return trafficSources(List.of(trafficSources));
        }

        /**
         * @param vpcZoneIdentifiers List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
         * 
         * @return builder
         * 
         */
        public Builder vpcZoneIdentifiers(@Nullable Output<List<String>> vpcZoneIdentifiers) {
            $.vpcZoneIdentifiers = vpcZoneIdentifiers;
            return this;
        }

        /**
         * @param vpcZoneIdentifiers List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
         * 
         * @return builder
         * 
         */
        public Builder vpcZoneIdentifiers(List<String> vpcZoneIdentifiers) {
            return vpcZoneIdentifiers(Output.of(vpcZoneIdentifiers));
        }

        /**
         * @param vpcZoneIdentifiers List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
         * 
         * @return builder
         * 
         */
        public Builder vpcZoneIdentifiers(String... vpcZoneIdentifiers) {
            return vpcZoneIdentifiers(List.of(vpcZoneIdentifiers));
        }

        /**
         * @param waitForCapacityTimeout Maximum
         * [duration](https://golang.org/pkg/time/#ParseDuration) that the provider should
         * wait for ASG instances to be healthy before timing out. (See also Waiting
         * for Capacity below.) Setting this to &#34;0&#34; causes
         * the provider to skip all Capacity Waiting behavior.
         * 
         * @return builder
         * 
         */
        public Builder waitForCapacityTimeout(@Nullable Output<String> waitForCapacityTimeout) {
            $.waitForCapacityTimeout = waitForCapacityTimeout;
            return this;
        }

        /**
         * @param waitForCapacityTimeout Maximum
         * [duration](https://golang.org/pkg/time/#ParseDuration) that the provider should
         * wait for ASG instances to be healthy before timing out. (See also Waiting
         * for Capacity below.) Setting this to &#34;0&#34; causes
         * the provider to skip all Capacity Waiting behavior.
         * 
         * @return builder
         * 
         */
        public Builder waitForCapacityTimeout(String waitForCapacityTimeout) {
            return waitForCapacityTimeout(Output.of(waitForCapacityTimeout));
        }

        /**
         * @param waitForElbCapacity Setting this will cause Pulumi to wait
         * for exactly this number of healthy instances from this Auto Scaling Group in
         * all attached load balancers on both create and update operations. (Takes
         * precedence over `min_elb_capacity` behavior.)
         * (See also Waiting for Capacity below.)
         * 
         * @return builder
         * 
         */
        public Builder waitForElbCapacity(@Nullable Output<Integer> waitForElbCapacity) {
            $.waitForElbCapacity = waitForElbCapacity;
            return this;
        }

        /**
         * @param waitForElbCapacity Setting this will cause Pulumi to wait
         * for exactly this number of healthy instances from this Auto Scaling Group in
         * all attached load balancers on both create and update operations. (Takes
         * precedence over `min_elb_capacity` behavior.)
         * (See also Waiting for Capacity below.)
         * 
         * @return builder
         * 
         */
        public Builder waitForElbCapacity(Integer waitForElbCapacity) {
            return waitForElbCapacity(Output.of(waitForElbCapacity));
        }

        /**
         * @param warmPool If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
         * to the specified Auto Scaling group. Defined below
         * 
         * @return builder
         * 
         */
        public Builder warmPool(@Nullable Output<GroupWarmPoolArgs> warmPool) {
            $.warmPool = warmPool;
            return this;
        }

        /**
         * @param warmPool If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
         * to the specified Auto Scaling group. Defined below
         * 
         * @return builder
         * 
         */
        public Builder warmPool(GroupWarmPoolArgs warmPool) {
            return warmPool(Output.of(warmPool));
        }

        public GroupArgs build() {
            $.maxSize = Objects.requireNonNull($.maxSize, "expected parameter 'maxSize' to be non-null");
            $.minSize = Objects.requireNonNull($.minSize, "expected parameter 'minSize' to be non-null");
            return $;
        }
    }

}
