// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.auditmanager.inputs;

import com.pulumi.aws.auditmanager.inputs.FrameworkControlSetArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class FrameworkState extends com.pulumi.resources.ResourceArgs {

    public static final FrameworkState Empty = new FrameworkState();

    /**
     * Amazon Resource Name (ARN) of the framework.
     * * `control_sets[*].id` - Unique identifier for the framework control set.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the framework.
     * * `control_sets[*].id` - Unique identifier for the framework control set.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * Compliance type that the new custom framework supports, such as `CIS` or `HIPAA`.
     * 
     */
    @Import(name="complianceType")
    private @Nullable Output<String> complianceType;

    /**
     * @return Compliance type that the new custom framework supports, such as `CIS` or `HIPAA`.
     * 
     */
    public Optional<Output<String>> complianceType() {
        return Optional.ofNullable(this.complianceType);
    }

    /**
     * Control sets that are associated with the framework. See `control_sets` below.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="controlSets")
    private @Nullable Output<List<FrameworkControlSetArgs>> controlSets;

    /**
     * @return Control sets that are associated with the framework. See `control_sets` below.
     * 
     * The following arguments are optional:
     * 
     */
    public Optional<Output<List<FrameworkControlSetArgs>>> controlSets() {
        return Optional.ofNullable(this.controlSets);
    }

    /**
     * Description of the framework.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Description of the framework.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Framework type, such as a custom framework or a standard framework.
     * 
     */
    @Import(name="frameworkType")
    private @Nullable Output<String> frameworkType;

    /**
     * @return Framework type, such as a custom framework or a standard framework.
     * 
     */
    public Optional<Output<String>> frameworkType() {
        return Optional.ofNullable(this.frameworkType);
    }

    /**
     * Name of the framework.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Name of the framework.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * A map of tags to assign to the framework. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the framework. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    private FrameworkState() {}

    private FrameworkState(FrameworkState $) {
        this.arn = $.arn;
        this.complianceType = $.complianceType;
        this.controlSets = $.controlSets;
        this.description = $.description;
        this.frameworkType = $.frameworkType;
        this.name = $.name;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(FrameworkState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private FrameworkState $;

        public Builder() {
            $ = new FrameworkState();
        }

        public Builder(FrameworkState defaults) {
            $ = new FrameworkState(Objects.requireNonNull(defaults));
        }

        /**
         * @param arn Amazon Resource Name (ARN) of the framework.
         * * `control_sets[*].id` - Unique identifier for the framework control set.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn Amazon Resource Name (ARN) of the framework.
         * * `control_sets[*].id` - Unique identifier for the framework control set.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param complianceType Compliance type that the new custom framework supports, such as `CIS` or `HIPAA`.
         * 
         * @return builder
         * 
         */
        public Builder complianceType(@Nullable Output<String> complianceType) {
            $.complianceType = complianceType;
            return this;
        }

        /**
         * @param complianceType Compliance type that the new custom framework supports, such as `CIS` or `HIPAA`.
         * 
         * @return builder
         * 
         */
        public Builder complianceType(String complianceType) {
            return complianceType(Output.of(complianceType));
        }

        /**
         * @param controlSets Control sets that are associated with the framework. See `control_sets` below.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder controlSets(@Nullable Output<List<FrameworkControlSetArgs>> controlSets) {
            $.controlSets = controlSets;
            return this;
        }

        /**
         * @param controlSets Control sets that are associated with the framework. See `control_sets` below.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder controlSets(List<FrameworkControlSetArgs> controlSets) {
            return controlSets(Output.of(controlSets));
        }

        /**
         * @param controlSets Control sets that are associated with the framework. See `control_sets` below.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder controlSets(FrameworkControlSetArgs... controlSets) {
            return controlSets(List.of(controlSets));
        }

        /**
         * @param description Description of the framework.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Description of the framework.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param frameworkType Framework type, such as a custom framework or a standard framework.
         * 
         * @return builder
         * 
         */
        public Builder frameworkType(@Nullable Output<String> frameworkType) {
            $.frameworkType = frameworkType;
            return this;
        }

        /**
         * @param frameworkType Framework type, such as a custom framework or a standard framework.
         * 
         * @return builder
         * 
         */
        public Builder frameworkType(String frameworkType) {
            return frameworkType(Output.of(frameworkType));
        }

        /**
         * @param name Name of the framework.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name of the framework.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param tags A map of tags to assign to the framework. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the framework. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        public FrameworkState build() {
            return $;
        }
    }

}
