// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.auditmanager;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.auditmanager.AssessmentReportArgs;
import com.pulumi.aws.auditmanager.inputs.AssessmentReportState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS Audit Manager Assessment Report.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.AssessmentReport;
 * import com.pulumi.aws.auditmanager.AssessmentReportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new AssessmentReport(&#34;test&#34;, AssessmentReportArgs.builder()        
 *             .assessmentId(aws_auditmanager_assessment.test().id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Audit Manager Assessment Reports using the assessment report `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:auditmanager/assessmentReport:AssessmentReport example abc123-de45
 * ```
 * 
 */
@ResourceType(type="aws:auditmanager/assessmentReport:AssessmentReport")
public class AssessmentReport extends com.pulumi.resources.CustomResource {
    /**
     * Unique identifier of the assessment to create the report from.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="assessmentId", refs={String.class}, tree="[0]")
    private Output<String> assessmentId;

    /**
     * @return Unique identifier of the assessment to create the report from.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> assessmentId() {
        return this.assessmentId;
    }
    /**
     * Name of the user who created the assessment report.
     * 
     */
    @Export(name="author", refs={String.class}, tree="[0]")
    private Output<String> author;

    /**
     * @return Name of the user who created the assessment report.
     * 
     */
    public Output<String> author() {
        return this.author;
    }
    /**
     * Description of the assessment report.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return Description of the assessment report.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * Name of the assessment report.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name of the assessment report.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Current status of the specified assessment report. Valid values are `COMPLETE`, `IN_PROGRESS`, and `FAILED`.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return Current status of the specified assessment report. Valid values are `COMPLETE`, `IN_PROGRESS`, and `FAILED`.
     * 
     */
    public Output<String> status() {
        return this.status;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public AssessmentReport(String name) {
        this(name, AssessmentReportArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public AssessmentReport(String name, AssessmentReportArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public AssessmentReport(String name, AssessmentReportArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:auditmanager/assessmentReport:AssessmentReport", name, args == null ? AssessmentReportArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private AssessmentReport(String name, Output<String> id, @Nullable AssessmentReportState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:auditmanager/assessmentReport:AssessmentReport", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static AssessmentReport get(String name, Output<String> id, @Nullable AssessmentReportState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new AssessmentReport(name, id, state, options);
    }
}
