// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.auditmanager;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.auditmanager.AssessmentDelegationArgs;
import com.pulumi.aws.auditmanager.inputs.AssessmentDelegationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS Audit Manager Assessment Delegation.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.AssessmentDelegation;
 * import com.pulumi.aws.auditmanager.AssessmentDelegationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new AssessmentDelegation(&#34;example&#34;, AssessmentDelegationArgs.builder()        
 *             .assessmentId(aws_auditmanager_assessment.example().id())
 *             .roleArn(aws_iam_role.example().arn())
 *             .roleType(&#34;RESOURCE_OWNER&#34;)
 *             .controlSetId(&#34;example&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Audit Manager Assessment Delegation using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:auditmanager/assessmentDelegation:AssessmentDelegation example abcdef-123456,arn:aws:iam::012345678901:role/example,example
 * ```
 * 
 */
@ResourceType(type="aws:auditmanager/assessmentDelegation:AssessmentDelegation")
public class AssessmentDelegation extends com.pulumi.resources.CustomResource {
    /**
     * Identifier for the assessment.
     * 
     */
    @Export(name="assessmentId", refs={String.class}, tree="[0]")
    private Output<String> assessmentId;

    /**
     * @return Identifier for the assessment.
     * 
     */
    public Output<String> assessmentId() {
        return this.assessmentId;
    }
    /**
     * Comment describing the delegation request.
     * 
     */
    @Export(name="comment", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> comment;

    /**
     * @return Comment describing the delegation request.
     * 
     */
    public Output<Optional<String>> comment() {
        return Codegen.optional(this.comment);
    }
    /**
     * Assessment control set name. This value is the control set name used during assessment creation (not the AWS-generated ID). The `_id` suffix on this attribute has been preserved to be consistent with the underlying AWS API.
     * 
     */
    @Export(name="controlSetId", refs={String.class}, tree="[0]")
    private Output<String> controlSetId;

    /**
     * @return Assessment control set name. This value is the control set name used during assessment creation (not the AWS-generated ID). The `_id` suffix on this attribute has been preserved to be consistent with the underlying AWS API.
     * 
     */
    public Output<String> controlSetId() {
        return this.controlSetId;
    }
    /**
     * Unique identifier for the delegation.
     * 
     */
    @Export(name="delegationId", refs={String.class}, tree="[0]")
    private Output<String> delegationId;

    /**
     * @return Unique identifier for the delegation.
     * 
     */
    public Output<String> delegationId() {
        return this.delegationId;
    }
    /**
     * Amazon Resource Name (ARN) of the IAM role.
     * 
     */
    @Export(name="roleArn", refs={String.class}, tree="[0]")
    private Output<String> roleArn;

    /**
     * @return Amazon Resource Name (ARN) of the IAM role.
     * 
     */
    public Output<String> roleArn() {
        return this.roleArn;
    }
    /**
     * Type of customer persona. For assessment delegation, type must always be `RESOURCE_OWNER`.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="roleType", refs={String.class}, tree="[0]")
    private Output<String> roleType;

    /**
     * @return Type of customer persona. For assessment delegation, type must always be `RESOURCE_OWNER`.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> roleType() {
        return this.roleType;
    }
    /**
     * Status of the delegation.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return Status of the delegation.
     * 
     */
    public Output<String> status() {
        return this.status;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public AssessmentDelegation(String name) {
        this(name, AssessmentDelegationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public AssessmentDelegation(String name, AssessmentDelegationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public AssessmentDelegation(String name, AssessmentDelegationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:auditmanager/assessmentDelegation:AssessmentDelegation", name, args == null ? AssessmentDelegationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private AssessmentDelegation(String name, Output<String> id, @Nullable AssessmentDelegationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:auditmanager/assessmentDelegation:AssessmentDelegation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static AssessmentDelegation get(String name, Output<String> id, @Nullable AssessmentDelegationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new AssessmentDelegation(name, id, state, options);
    }
}
