// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.auditmanager;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.auditmanager.AccountRegistrationArgs;
import com.pulumi.aws.auditmanager.inputs.AccountRegistrationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing AWS Audit Manager Account Registration.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.AccountRegistration;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new AccountRegistration(&#34;example&#34;);
 * 
 *     }
 * }
 * ```
 * ### Deregister On Destroy
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.AccountRegistration;
 * import com.pulumi.aws.auditmanager.AccountRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new AccountRegistration(&#34;example&#34;, AccountRegistrationArgs.builder()        
 *             .deregisterOnDestroy(true)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Audit Manager Account Registration resources using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:auditmanager/accountRegistration:AccountRegistration example us-east-1
 * ```
 * 
 */
@ResourceType(type="aws:auditmanager/accountRegistration:AccountRegistration")
public class AccountRegistration extends com.pulumi.resources.CustomResource {
    /**
     * Identifier for the delegated administrator account.
     * 
     */
    @Export(name="delegatedAdminAccount", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> delegatedAdminAccount;

    /**
     * @return Identifier for the delegated administrator account.
     * 
     */
    public Output<Optional<String>> delegatedAdminAccount() {
        return Codegen.optional(this.delegatedAdminAccount);
    }
    /**
     * Flag to deregister AuditManager in the account upon destruction. Defaults to `false` (ie. AuditManager will remain active in the account, even if this resource is removed).
     * 
     */
    @Export(name="deregisterOnDestroy", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> deregisterOnDestroy;

    /**
     * @return Flag to deregister AuditManager in the account upon destruction. Defaults to `false` (ie. AuditManager will remain active in the account, even if this resource is removed).
     * 
     */
    public Output<Optional<Boolean>> deregisterOnDestroy() {
        return Codegen.optional(this.deregisterOnDestroy);
    }
    /**
     * KMS key identifier.
     * 
     */
    @Export(name="kmsKey", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> kmsKey;

    /**
     * @return KMS key identifier.
     * 
     */
    public Output<Optional<String>> kmsKey() {
        return Codegen.optional(this.kmsKey);
    }
    /**
     * Status of the account registration request.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return Status of the account registration request.
     * 
     */
    public Output<String> status() {
        return this.status;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public AccountRegistration(String name) {
        this(name, AccountRegistrationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public AccountRegistration(String name, @Nullable AccountRegistrationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public AccountRegistration(String name, @Nullable AccountRegistrationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:auditmanager/accountRegistration:AccountRegistration", name, args == null ? AccountRegistrationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private AccountRegistration(String name, Output<String> id, @Nullable AccountRegistrationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:auditmanager/accountRegistration:AccountRegistration", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static AccountRegistration get(String name, Output<String> id, @Nullable AccountRegistrationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new AccountRegistration(name, id, state, options);
    }
}
