// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.appsync;

import com.pulumi.aws.appsync.inputs.DataSourceDynamodbConfigArgs;
import com.pulumi.aws.appsync.inputs.DataSourceElasticsearchConfigArgs;
import com.pulumi.aws.appsync.inputs.DataSourceEventBridgeConfigArgs;
import com.pulumi.aws.appsync.inputs.DataSourceHttpConfigArgs;
import com.pulumi.aws.appsync.inputs.DataSourceLambdaConfigArgs;
import com.pulumi.aws.appsync.inputs.DataSourceOpensearchserviceConfigArgs;
import com.pulumi.aws.appsync.inputs.DataSourceRelationalDatabaseConfigArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class DataSourceArgs extends com.pulumi.resources.ResourceArgs {

    public static final DataSourceArgs Empty = new DataSourceArgs();

    /**
     * API ID for the GraphQL API for the data source.
     * 
     */
    @Import(name="apiId", required=true)
    private Output<String> apiId;

    /**
     * @return API ID for the GraphQL API for the data source.
     * 
     */
    public Output<String> apiId() {
        return this.apiId;
    }

    /**
     * Description of the data source.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Description of the data source.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * DynamoDB settings. See DynamoDB Config
     * 
     */
    @Import(name="dynamodbConfig")
    private @Nullable Output<DataSourceDynamodbConfigArgs> dynamodbConfig;

    /**
     * @return DynamoDB settings. See DynamoDB Config
     * 
     */
    public Optional<Output<DataSourceDynamodbConfigArgs>> dynamodbConfig() {
        return Optional.ofNullable(this.dynamodbConfig);
    }

    /**
     * Amazon Elasticsearch settings. See ElasticSearch Config
     * 
     */
    @Import(name="elasticsearchConfig")
    private @Nullable Output<DataSourceElasticsearchConfigArgs> elasticsearchConfig;

    /**
     * @return Amazon Elasticsearch settings. See ElasticSearch Config
     * 
     */
    public Optional<Output<DataSourceElasticsearchConfigArgs>> elasticsearchConfig() {
        return Optional.ofNullable(this.elasticsearchConfig);
    }

    /**
     * AWS EventBridge settings. See Event Bridge Config
     * 
     */
    @Import(name="eventBridgeConfig")
    private @Nullable Output<DataSourceEventBridgeConfigArgs> eventBridgeConfig;

    /**
     * @return AWS EventBridge settings. See Event Bridge Config
     * 
     */
    public Optional<Output<DataSourceEventBridgeConfigArgs>> eventBridgeConfig() {
        return Optional.ofNullable(this.eventBridgeConfig);
    }

    /**
     * HTTP settings. See HTTP Config
     * 
     */
    @Import(name="httpConfig")
    private @Nullable Output<DataSourceHttpConfigArgs> httpConfig;

    /**
     * @return HTTP settings. See HTTP Config
     * 
     */
    public Optional<Output<DataSourceHttpConfigArgs>> httpConfig() {
        return Optional.ofNullable(this.httpConfig);
    }

    /**
     * AWS Lambda settings. See Lambda Config
     * 
     */
    @Import(name="lambdaConfig")
    private @Nullable Output<DataSourceLambdaConfigArgs> lambdaConfig;

    /**
     * @return AWS Lambda settings. See Lambda Config
     * 
     */
    public Optional<Output<DataSourceLambdaConfigArgs>> lambdaConfig() {
        return Optional.ofNullable(this.lambdaConfig);
    }

    /**
     * User-supplied name for the data source.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return User-supplied name for the data source.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Amazon OpenSearch Service settings. See OpenSearch Service Config
     * 
     */
    @Import(name="opensearchserviceConfig")
    private @Nullable Output<DataSourceOpensearchserviceConfigArgs> opensearchserviceConfig;

    /**
     * @return Amazon OpenSearch Service settings. See OpenSearch Service Config
     * 
     */
    public Optional<Output<DataSourceOpensearchserviceConfigArgs>> opensearchserviceConfig() {
        return Optional.ofNullable(this.opensearchserviceConfig);
    }

    /**
     * AWS RDS settings. See Relational Database Config
     * 
     */
    @Import(name="relationalDatabaseConfig")
    private @Nullable Output<DataSourceRelationalDatabaseConfigArgs> relationalDatabaseConfig;

    /**
     * @return AWS RDS settings. See Relational Database Config
     * 
     */
    public Optional<Output<DataSourceRelationalDatabaseConfigArgs>> relationalDatabaseConfig() {
        return Optional.ofNullable(this.relationalDatabaseConfig);
    }

    /**
     * IAM service role ARN for the data source.
     * 
     */
    @Import(name="serviceRoleArn")
    private @Nullable Output<String> serviceRoleArn;

    /**
     * @return IAM service role ARN for the data source.
     * 
     */
    public Optional<Output<String>> serviceRoleArn() {
        return Optional.ofNullable(this.serviceRoleArn);
    }

    /**
     * Type of the Data Source. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`, `AMAZON_EVENTBRIDGE`, `AMAZON_OPENSEARCH_SERVICE`.
     * 
     */
    @Import(name="type", required=true)
    private Output<String> type;

    /**
     * @return Type of the Data Source. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`, `AMAZON_EVENTBRIDGE`, `AMAZON_OPENSEARCH_SERVICE`.
     * 
     */
    public Output<String> type() {
        return this.type;
    }

    private DataSourceArgs() {}

    private DataSourceArgs(DataSourceArgs $) {
        this.apiId = $.apiId;
        this.description = $.description;
        this.dynamodbConfig = $.dynamodbConfig;
        this.elasticsearchConfig = $.elasticsearchConfig;
        this.eventBridgeConfig = $.eventBridgeConfig;
        this.httpConfig = $.httpConfig;
        this.lambdaConfig = $.lambdaConfig;
        this.name = $.name;
        this.opensearchserviceConfig = $.opensearchserviceConfig;
        this.relationalDatabaseConfig = $.relationalDatabaseConfig;
        this.serviceRoleArn = $.serviceRoleArn;
        this.type = $.type;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DataSourceArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DataSourceArgs $;

        public Builder() {
            $ = new DataSourceArgs();
        }

        public Builder(DataSourceArgs defaults) {
            $ = new DataSourceArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param apiId API ID for the GraphQL API for the data source.
         * 
         * @return builder
         * 
         */
        public Builder apiId(Output<String> apiId) {
            $.apiId = apiId;
            return this;
        }

        /**
         * @param apiId API ID for the GraphQL API for the data source.
         * 
         * @return builder
         * 
         */
        public Builder apiId(String apiId) {
            return apiId(Output.of(apiId));
        }

        /**
         * @param description Description of the data source.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Description of the data source.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param dynamodbConfig DynamoDB settings. See DynamoDB Config
         * 
         * @return builder
         * 
         */
        public Builder dynamodbConfig(@Nullable Output<DataSourceDynamodbConfigArgs> dynamodbConfig) {
            $.dynamodbConfig = dynamodbConfig;
            return this;
        }

        /**
         * @param dynamodbConfig DynamoDB settings. See DynamoDB Config
         * 
         * @return builder
         * 
         */
        public Builder dynamodbConfig(DataSourceDynamodbConfigArgs dynamodbConfig) {
            return dynamodbConfig(Output.of(dynamodbConfig));
        }

        /**
         * @param elasticsearchConfig Amazon Elasticsearch settings. See ElasticSearch Config
         * 
         * @return builder
         * 
         */
        public Builder elasticsearchConfig(@Nullable Output<DataSourceElasticsearchConfigArgs> elasticsearchConfig) {
            $.elasticsearchConfig = elasticsearchConfig;
            return this;
        }

        /**
         * @param elasticsearchConfig Amazon Elasticsearch settings. See ElasticSearch Config
         * 
         * @return builder
         * 
         */
        public Builder elasticsearchConfig(DataSourceElasticsearchConfigArgs elasticsearchConfig) {
            return elasticsearchConfig(Output.of(elasticsearchConfig));
        }

        /**
         * @param eventBridgeConfig AWS EventBridge settings. See Event Bridge Config
         * 
         * @return builder
         * 
         */
        public Builder eventBridgeConfig(@Nullable Output<DataSourceEventBridgeConfigArgs> eventBridgeConfig) {
            $.eventBridgeConfig = eventBridgeConfig;
            return this;
        }

        /**
         * @param eventBridgeConfig AWS EventBridge settings. See Event Bridge Config
         * 
         * @return builder
         * 
         */
        public Builder eventBridgeConfig(DataSourceEventBridgeConfigArgs eventBridgeConfig) {
            return eventBridgeConfig(Output.of(eventBridgeConfig));
        }

        /**
         * @param httpConfig HTTP settings. See HTTP Config
         * 
         * @return builder
         * 
         */
        public Builder httpConfig(@Nullable Output<DataSourceHttpConfigArgs> httpConfig) {
            $.httpConfig = httpConfig;
            return this;
        }

        /**
         * @param httpConfig HTTP settings. See HTTP Config
         * 
         * @return builder
         * 
         */
        public Builder httpConfig(DataSourceHttpConfigArgs httpConfig) {
            return httpConfig(Output.of(httpConfig));
        }

        /**
         * @param lambdaConfig AWS Lambda settings. See Lambda Config
         * 
         * @return builder
         * 
         */
        public Builder lambdaConfig(@Nullable Output<DataSourceLambdaConfigArgs> lambdaConfig) {
            $.lambdaConfig = lambdaConfig;
            return this;
        }

        /**
         * @param lambdaConfig AWS Lambda settings. See Lambda Config
         * 
         * @return builder
         * 
         */
        public Builder lambdaConfig(DataSourceLambdaConfigArgs lambdaConfig) {
            return lambdaConfig(Output.of(lambdaConfig));
        }

        /**
         * @param name User-supplied name for the data source.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name User-supplied name for the data source.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param opensearchserviceConfig Amazon OpenSearch Service settings. See OpenSearch Service Config
         * 
         * @return builder
         * 
         */
        public Builder opensearchserviceConfig(@Nullable Output<DataSourceOpensearchserviceConfigArgs> opensearchserviceConfig) {
            $.opensearchserviceConfig = opensearchserviceConfig;
            return this;
        }

        /**
         * @param opensearchserviceConfig Amazon OpenSearch Service settings. See OpenSearch Service Config
         * 
         * @return builder
         * 
         */
        public Builder opensearchserviceConfig(DataSourceOpensearchserviceConfigArgs opensearchserviceConfig) {
            return opensearchserviceConfig(Output.of(opensearchserviceConfig));
        }

        /**
         * @param relationalDatabaseConfig AWS RDS settings. See Relational Database Config
         * 
         * @return builder
         * 
         */
        public Builder relationalDatabaseConfig(@Nullable Output<DataSourceRelationalDatabaseConfigArgs> relationalDatabaseConfig) {
            $.relationalDatabaseConfig = relationalDatabaseConfig;
            return this;
        }

        /**
         * @param relationalDatabaseConfig AWS RDS settings. See Relational Database Config
         * 
         * @return builder
         * 
         */
        public Builder relationalDatabaseConfig(DataSourceRelationalDatabaseConfigArgs relationalDatabaseConfig) {
            return relationalDatabaseConfig(Output.of(relationalDatabaseConfig));
        }

        /**
         * @param serviceRoleArn IAM service role ARN for the data source.
         * 
         * @return builder
         * 
         */
        public Builder serviceRoleArn(@Nullable Output<String> serviceRoleArn) {
            $.serviceRoleArn = serviceRoleArn;
            return this;
        }

        /**
         * @param serviceRoleArn IAM service role ARN for the data source.
         * 
         * @return builder
         * 
         */
        public Builder serviceRoleArn(String serviceRoleArn) {
            return serviceRoleArn(Output.of(serviceRoleArn));
        }

        /**
         * @param type Type of the Data Source. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`, `AMAZON_EVENTBRIDGE`, `AMAZON_OPENSEARCH_SERVICE`.
         * 
         * @return builder
         * 
         */
        public Builder type(Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type Type of the Data Source. Valid values: `AWS_LAMBDA`, `AMAZON_DYNAMODB`, `AMAZON_ELASTICSEARCH`, `HTTP`, `NONE`, `RELATIONAL_DATABASE`, `AMAZON_EVENTBRIDGE`, `AMAZON_OPENSEARCH_SERVICE`.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        public DataSourceArgs build() {
            $.apiId = Objects.requireNonNull($.apiId, "expected parameter 'apiId' to be non-null");
            $.type = Objects.requireNonNull($.type, "expected parameter 'type' to be non-null");
            return $;
        }
    }

}
