// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.appstream;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.appstream.UserStackAssociationArgs;
import com.pulumi.aws.appstream.inputs.UserStackAssociationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages an AppStream User Stack association.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.Stack;
 * import com.pulumi.aws.appstream.User;
 * import com.pulumi.aws.appstream.UserArgs;
 * import com.pulumi.aws.appstream.UserStackAssociation;
 * import com.pulumi.aws.appstream.UserStackAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var testStack = new Stack(&#34;testStack&#34;);
 * 
 *         var testUser = new User(&#34;testUser&#34;, UserArgs.builder()        
 *             .authenticationType(&#34;USERPOOL&#34;)
 *             .userName(&#34;EMAIL&#34;)
 *             .build());
 * 
 *         var testUserStackAssociation = new UserStackAssociation(&#34;testUserStackAssociation&#34;, UserStackAssociationArgs.builder()        
 *             .authenticationType(testUser.authenticationType())
 *             .stackName(testStack.name())
 *             .userName(testUser.userName())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import AppStream User Stack Association using the `user_name`, `authentication_type`, and `stack_name`, separated by a slash (`/`). For example:
 * 
 * ```sh
 *  $ pulumi import aws:appstream/userStackAssociation:UserStackAssociation example userName/auhtenticationType/stackName
 * ```
 * 
 */
@ResourceType(type="aws:appstream/userStackAssociation:UserStackAssociation")
public class UserStackAssociation extends com.pulumi.resources.CustomResource {
    /**
     * Authentication type for the user.
     * 
     */
    @Export(name="authenticationType", refs={String.class}, tree="[0]")
    private Output<String> authenticationType;

    /**
     * @return Authentication type for the user.
     * 
     */
    public Output<String> authenticationType() {
        return this.authenticationType;
    }
    /**
     * Whether a welcome email is sent to a user after the user is created in the user pool.
     * 
     */
    @Export(name="sendEmailNotification", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> sendEmailNotification;

    /**
     * @return Whether a welcome email is sent to a user after the user is created in the user pool.
     * 
     */
    public Output<Optional<Boolean>> sendEmailNotification() {
        return Codegen.optional(this.sendEmailNotification);
    }
    /**
     * Name of the stack that is associated with the user.
     * 
     */
    @Export(name="stackName", refs={String.class}, tree="[0]")
    private Output<String> stackName;

    /**
     * @return Name of the stack that is associated with the user.
     * 
     */
    public Output<String> stackName() {
        return this.stackName;
    }
    /**
     * Email address of the user who is associated with the stack.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="userName", refs={String.class}, tree="[0]")
    private Output<String> userName;

    /**
     * @return Email address of the user who is associated with the stack.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> userName() {
        return this.userName;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public UserStackAssociation(String name) {
        this(name, UserStackAssociationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public UserStackAssociation(String name, UserStackAssociationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public UserStackAssociation(String name, UserStackAssociationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:appstream/userStackAssociation:UserStackAssociation", name, args == null ? UserStackAssociationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private UserStackAssociation(String name, Output<String> id, @Nullable UserStackAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:appstream/userStackAssociation:UserStackAssociation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static UserStackAssociation get(String name, Output<String> id, @Nullable UserStackAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new UserStackAssociation(name, id, state, options);
    }
}
