// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.appstream;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.appstream.FleetStackAssociationArgs;
import com.pulumi.aws.appstream.inputs.FleetStackAssociationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Manages an AppStream Fleet Stack association.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.Fleet;
 * import com.pulumi.aws.appstream.FleetArgs;
 * import com.pulumi.aws.appstream.inputs.FleetComputeCapacityArgs;
 * import com.pulumi.aws.appstream.Stack;
 * import com.pulumi.aws.appstream.FleetStackAssociation;
 * import com.pulumi.aws.appstream.FleetStackAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleFleet = new Fleet(&#34;exampleFleet&#34;, FleetArgs.builder()        
 *             .imageName(&#34;Amazon-AppStream2-Sample-Image-03-11-2023&#34;)
 *             .instanceType(&#34;stream.standard.small&#34;)
 *             .computeCapacity(FleetComputeCapacityArgs.builder()
 *                 .desiredInstances(1)
 *                 .build())
 *             .build());
 * 
 *         var exampleStack = new Stack(&#34;exampleStack&#34;);
 * 
 *         var exampleFleetStackAssociation = new FleetStackAssociation(&#34;exampleFleetStackAssociation&#34;, FleetStackAssociationArgs.builder()        
 *             .fleetName(exampleFleet.name())
 *             .stackName(exampleStack.name())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import AppStream Stack Fleet Association using the `fleet_name` and `stack_name` separated by a slash (`/`). For example:
 * 
 * ```sh
 *  $ pulumi import aws:appstream/fleetStackAssociation:FleetStackAssociation example fleetName/stackName
 * ```
 * 
 */
@ResourceType(type="aws:appstream/fleetStackAssociation:FleetStackAssociation")
public class FleetStackAssociation extends com.pulumi.resources.CustomResource {
    /**
     * Name of the fleet.
     * 
     */
    @Export(name="fleetName", refs={String.class}, tree="[0]")
    private Output<String> fleetName;

    /**
     * @return Name of the fleet.
     * 
     */
    public Output<String> fleetName() {
        return this.fleetName;
    }
    /**
     * Name of the stack.
     * 
     */
    @Export(name="stackName", refs={String.class}, tree="[0]")
    private Output<String> stackName;

    /**
     * @return Name of the stack.
     * 
     */
    public Output<String> stackName() {
        return this.stackName;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public FleetStackAssociation(String name) {
        this(name, FleetStackAssociationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public FleetStackAssociation(String name, FleetStackAssociationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public FleetStackAssociation(String name, FleetStackAssociationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:appstream/fleetStackAssociation:FleetStackAssociation", name, args == null ? FleetStackAssociationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private FleetStackAssociation(String name, Output<String> id, @Nullable FleetStackAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:appstream/fleetStackAssociation:FleetStackAssociation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static FleetStackAssociation get(String name, Output<String> id, @Nullable FleetStackAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new FleetStackAssociation(name, id, state, options);
    }
}
