// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apprunner;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class VpcConnectorArgs extends com.pulumi.resources.ResourceArgs {

    public static final VpcConnectorArgs Empty = new VpcConnectorArgs();

    /**
     * List of IDs of security groups that App Runner should use for access to AWS resources under the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.
     * 
     */
    @Import(name="securityGroups", required=true)
    private Output<List<String>> securityGroups;

    /**
     * @return List of IDs of security groups that App Runner should use for access to AWS resources under the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.
     * 
     */
    public Output<List<String>> securityGroups() {
        return this.securityGroups;
    }

    /**
     * List of IDs of subnets that App Runner should use when it associates your service with a custom Amazon VPC. Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from the subnets you specify.
     * 
     */
    @Import(name="subnets", required=true)
    private Output<List<String>> subnets;

    /**
     * @return List of IDs of subnets that App Runner should use when it associates your service with a custom Amazon VPC. Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from the subnets you specify.
     * 
     */
    public Output<List<String>> subnets() {
        return this.subnets;
    }

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Name for the VPC connector.
     * 
     */
    @Import(name="vpcConnectorName", required=true)
    private Output<String> vpcConnectorName;

    /**
     * @return Name for the VPC connector.
     * 
     */
    public Output<String> vpcConnectorName() {
        return this.vpcConnectorName;
    }

    private VpcConnectorArgs() {}

    private VpcConnectorArgs(VpcConnectorArgs $) {
        this.securityGroups = $.securityGroups;
        this.subnets = $.subnets;
        this.tags = $.tags;
        this.vpcConnectorName = $.vpcConnectorName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(VpcConnectorArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private VpcConnectorArgs $;

        public Builder() {
            $ = new VpcConnectorArgs();
        }

        public Builder(VpcConnectorArgs defaults) {
            $ = new VpcConnectorArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param securityGroups List of IDs of security groups that App Runner should use for access to AWS resources under the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.
         * 
         * @return builder
         * 
         */
        public Builder securityGroups(Output<List<String>> securityGroups) {
            $.securityGroups = securityGroups;
            return this;
        }

        /**
         * @param securityGroups List of IDs of security groups that App Runner should use for access to AWS resources under the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.
         * 
         * @return builder
         * 
         */
        public Builder securityGroups(List<String> securityGroups) {
            return securityGroups(Output.of(securityGroups));
        }

        /**
         * @param securityGroups List of IDs of security groups that App Runner should use for access to AWS resources under the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.
         * 
         * @return builder
         * 
         */
        public Builder securityGroups(String... securityGroups) {
            return securityGroups(List.of(securityGroups));
        }

        /**
         * @param subnets List of IDs of subnets that App Runner should use when it associates your service with a custom Amazon VPC. Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from the subnets you specify.
         * 
         * @return builder
         * 
         */
        public Builder subnets(Output<List<String>> subnets) {
            $.subnets = subnets;
            return this;
        }

        /**
         * @param subnets List of IDs of subnets that App Runner should use when it associates your service with a custom Amazon VPC. Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from the subnets you specify.
         * 
         * @return builder
         * 
         */
        public Builder subnets(List<String> subnets) {
            return subnets(Output.of(subnets));
        }

        /**
         * @param subnets List of IDs of subnets that App Runner should use when it associates your service with a custom Amazon VPC. Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from the subnets you specify.
         * 
         * @return builder
         * 
         */
        public Builder subnets(String... subnets) {
            return subnets(List.of(subnets));
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param vpcConnectorName Name for the VPC connector.
         * 
         * @return builder
         * 
         */
        public Builder vpcConnectorName(Output<String> vpcConnectorName) {
            $.vpcConnectorName = vpcConnectorName;
            return this;
        }

        /**
         * @param vpcConnectorName Name for the VPC connector.
         * 
         * @return builder
         * 
         */
        public Builder vpcConnectorName(String vpcConnectorName) {
            return vpcConnectorName(Output.of(vpcConnectorName));
        }

        public VpcConnectorArgs build() {
            $.securityGroups = Objects.requireNonNull($.securityGroups, "expected parameter 'securityGroups' to be non-null");
            $.subnets = Objects.requireNonNull($.subnets, "expected parameter 'subnets' to be non-null");
            $.vpcConnectorName = Objects.requireNonNull($.vpcConnectorName, "expected parameter 'vpcConnectorName' to be non-null");
            return $;
        }
    }

}
