// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apprunner;

import com.pulumi.aws.apprunner.inputs.ServiceEncryptionConfigurationArgs;
import com.pulumi.aws.apprunner.inputs.ServiceHealthCheckConfigurationArgs;
import com.pulumi.aws.apprunner.inputs.ServiceInstanceConfigurationArgs;
import com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationArgs;
import com.pulumi.aws.apprunner.inputs.ServiceObservabilityConfigurationArgs;
import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ServiceArgs extends com.pulumi.resources.ResourceArgs {

    public static final ServiceArgs Empty = new ServiceArgs();

    /**
     * ARN of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner associates the latest revision of a default auto scaling configuration.
     * 
     */
    @Import(name="autoScalingConfigurationArn")
    private @Nullable Output<String> autoScalingConfigurationArn;

    /**
     * @return ARN of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner associates the latest revision of a default auto scaling configuration.
     * 
     */
    public Optional<Output<String>> autoScalingConfigurationArn() {
        return Optional.ofNullable(this.autoScalingConfigurationArn);
    }

    /**
     * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an AWS managed CMK. See Encryption Configuration below for more details.
     * 
     */
    @Import(name="encryptionConfiguration")
    private @Nullable Output<ServiceEncryptionConfigurationArgs> encryptionConfiguration;

    /**
     * @return An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an AWS managed CMK. See Encryption Configuration below for more details.
     * 
     */
    public Optional<Output<ServiceEncryptionConfigurationArgs>> encryptionConfiguration() {
        return Optional.ofNullable(this.encryptionConfiguration);
    }

    /**
     * Settings of the health check that AWS App Runner performs to monitor the health of your service. See Health Check Configuration below for more details.
     * 
     */
    @Import(name="healthCheckConfiguration")
    private @Nullable Output<ServiceHealthCheckConfigurationArgs> healthCheckConfiguration;

    /**
     * @return Settings of the health check that AWS App Runner performs to monitor the health of your service. See Health Check Configuration below for more details.
     * 
     */
    public Optional<Output<ServiceHealthCheckConfigurationArgs>> healthCheckConfiguration() {
        return Optional.ofNullable(this.healthCheckConfiguration);
    }

    /**
     * The runtime configuration of instances (scaling units) of the App Runner service. See Instance Configuration below for more details.
     * 
     */
    @Import(name="instanceConfiguration")
    private @Nullable Output<ServiceInstanceConfigurationArgs> instanceConfiguration;

    /**
     * @return The runtime configuration of instances (scaling units) of the App Runner service. See Instance Configuration below for more details.
     * 
     */
    public Optional<Output<ServiceInstanceConfigurationArgs>> instanceConfiguration() {
        return Optional.ofNullable(this.instanceConfiguration);
    }

    /**
     * Configuration settings related to network traffic of the web application that the App Runner service runs. See Network Configuration below for more details.
     * 
     */
    @Import(name="networkConfiguration")
    private @Nullable Output<ServiceNetworkConfigurationArgs> networkConfiguration;

    /**
     * @return Configuration settings related to network traffic of the web application that the App Runner service runs. See Network Configuration below for more details.
     * 
     */
    public Optional<Output<ServiceNetworkConfigurationArgs>> networkConfiguration() {
        return Optional.ofNullable(this.networkConfiguration);
    }

    /**
     * The observability configuration of your service. See Observability Configuration below for more details.
     * 
     */
    @Import(name="observabilityConfiguration")
    private @Nullable Output<ServiceObservabilityConfigurationArgs> observabilityConfiguration;

    /**
     * @return The observability configuration of your service. See Observability Configuration below for more details.
     * 
     */
    public Optional<Output<ServiceObservabilityConfigurationArgs>> observabilityConfiguration() {
        return Optional.ofNullable(this.observabilityConfiguration);
    }

    /**
     * Name of the service.
     * 
     */
    @Import(name="serviceName", required=true)
    private Output<String> serviceName;

    /**
     * @return Name of the service.
     * 
     */
    public Output<String> serviceName() {
        return this.serviceName;
    }

    /**
     * The source to deploy to the App Runner service. Can be a code or an image repository. See Source Configuration below for more details.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="sourceConfiguration", required=true)
    private Output<ServiceSourceConfigurationArgs> sourceConfiguration;

    /**
     * @return The source to deploy to the App Runner service. Can be a code or an image repository. See Source Configuration below for more details.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<ServiceSourceConfigurationArgs> sourceConfiguration() {
        return this.sourceConfiguration;
    }

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private ServiceArgs() {}

    private ServiceArgs(ServiceArgs $) {
        this.autoScalingConfigurationArn = $.autoScalingConfigurationArn;
        this.encryptionConfiguration = $.encryptionConfiguration;
        this.healthCheckConfiguration = $.healthCheckConfiguration;
        this.instanceConfiguration = $.instanceConfiguration;
        this.networkConfiguration = $.networkConfiguration;
        this.observabilityConfiguration = $.observabilityConfiguration;
        this.serviceName = $.serviceName;
        this.sourceConfiguration = $.sourceConfiguration;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ServiceArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ServiceArgs $;

        public Builder() {
            $ = new ServiceArgs();
        }

        public Builder(ServiceArgs defaults) {
            $ = new ServiceArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param autoScalingConfigurationArn ARN of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner associates the latest revision of a default auto scaling configuration.
         * 
         * @return builder
         * 
         */
        public Builder autoScalingConfigurationArn(@Nullable Output<String> autoScalingConfigurationArn) {
            $.autoScalingConfigurationArn = autoScalingConfigurationArn;
            return this;
        }

        /**
         * @param autoScalingConfigurationArn ARN of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner associates the latest revision of a default auto scaling configuration.
         * 
         * @return builder
         * 
         */
        public Builder autoScalingConfigurationArn(String autoScalingConfigurationArn) {
            return autoScalingConfigurationArn(Output.of(autoScalingConfigurationArn));
        }

        /**
         * @param encryptionConfiguration An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an AWS managed CMK. See Encryption Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder encryptionConfiguration(@Nullable Output<ServiceEncryptionConfigurationArgs> encryptionConfiguration) {
            $.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * @param encryptionConfiguration An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an AWS managed CMK. See Encryption Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder encryptionConfiguration(ServiceEncryptionConfigurationArgs encryptionConfiguration) {
            return encryptionConfiguration(Output.of(encryptionConfiguration));
        }

        /**
         * @param healthCheckConfiguration Settings of the health check that AWS App Runner performs to monitor the health of your service. See Health Check Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder healthCheckConfiguration(@Nullable Output<ServiceHealthCheckConfigurationArgs> healthCheckConfiguration) {
            $.healthCheckConfiguration = healthCheckConfiguration;
            return this;
        }

        /**
         * @param healthCheckConfiguration Settings of the health check that AWS App Runner performs to monitor the health of your service. See Health Check Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder healthCheckConfiguration(ServiceHealthCheckConfigurationArgs healthCheckConfiguration) {
            return healthCheckConfiguration(Output.of(healthCheckConfiguration));
        }

        /**
         * @param instanceConfiguration The runtime configuration of instances (scaling units) of the App Runner service. See Instance Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder instanceConfiguration(@Nullable Output<ServiceInstanceConfigurationArgs> instanceConfiguration) {
            $.instanceConfiguration = instanceConfiguration;
            return this;
        }

        /**
         * @param instanceConfiguration The runtime configuration of instances (scaling units) of the App Runner service. See Instance Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder instanceConfiguration(ServiceInstanceConfigurationArgs instanceConfiguration) {
            return instanceConfiguration(Output.of(instanceConfiguration));
        }

        /**
         * @param networkConfiguration Configuration settings related to network traffic of the web application that the App Runner service runs. See Network Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder networkConfiguration(@Nullable Output<ServiceNetworkConfigurationArgs> networkConfiguration) {
            $.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * @param networkConfiguration Configuration settings related to network traffic of the web application that the App Runner service runs. See Network Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder networkConfiguration(ServiceNetworkConfigurationArgs networkConfiguration) {
            return networkConfiguration(Output.of(networkConfiguration));
        }

        /**
         * @param observabilityConfiguration The observability configuration of your service. See Observability Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder observabilityConfiguration(@Nullable Output<ServiceObservabilityConfigurationArgs> observabilityConfiguration) {
            $.observabilityConfiguration = observabilityConfiguration;
            return this;
        }

        /**
         * @param observabilityConfiguration The observability configuration of your service. See Observability Configuration below for more details.
         * 
         * @return builder
         * 
         */
        public Builder observabilityConfiguration(ServiceObservabilityConfigurationArgs observabilityConfiguration) {
            return observabilityConfiguration(Output.of(observabilityConfiguration));
        }

        /**
         * @param serviceName Name of the service.
         * 
         * @return builder
         * 
         */
        public Builder serviceName(Output<String> serviceName) {
            $.serviceName = serviceName;
            return this;
        }

        /**
         * @param serviceName Name of the service.
         * 
         * @return builder
         * 
         */
        public Builder serviceName(String serviceName) {
            return serviceName(Output.of(serviceName));
        }

        /**
         * @param sourceConfiguration The source to deploy to the App Runner service. Can be a code or an image repository. See Source Configuration below for more details.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder sourceConfiguration(Output<ServiceSourceConfigurationArgs> sourceConfiguration) {
            $.sourceConfiguration = sourceConfiguration;
            return this;
        }

        /**
         * @param sourceConfiguration The source to deploy to the App Runner service. Can be a code or an image repository. See Source Configuration below for more details.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder sourceConfiguration(ServiceSourceConfigurationArgs sourceConfiguration) {
            return sourceConfiguration(Output.of(sourceConfiguration));
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public ServiceArgs build() {
            $.serviceName = Objects.requireNonNull($.serviceName, "expected parameter 'serviceName' to be non-null");
            $.sourceConfiguration = Objects.requireNonNull($.sourceConfiguration, "expected parameter 'sourceConfiguration' to be non-null");
            return $;
        }
    }

}
