// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apprunner;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.apprunner.ServiceArgs;
import com.pulumi.aws.apprunner.inputs.ServiceState;
import com.pulumi.aws.apprunner.outputs.ServiceEncryptionConfiguration;
import com.pulumi.aws.apprunner.outputs.ServiceHealthCheckConfiguration;
import com.pulumi.aws.apprunner.outputs.ServiceInstanceConfiguration;
import com.pulumi.aws.apprunner.outputs.ServiceNetworkConfiguration;
import com.pulumi.aws.apprunner.outputs.ServiceObservabilityConfiguration;
import com.pulumi.aws.apprunner.outputs.ServiceSourceConfiguration;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages an App Runner Service.
 * 
 * ## Example Usage
 * ### Service with a Code Repository Source
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.Service;
 * import com.pulumi.aws.apprunner.ServiceArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationAuthenticationConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationEgressConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Service(&#34;example&#34;, ServiceArgs.builder()        
 *             .serviceName(&#34;example&#34;)
 *             .sourceConfiguration(ServiceSourceConfigurationArgs.builder()
 *                 .authenticationConfiguration(ServiceSourceConfigurationAuthenticationConfigurationArgs.builder()
 *                     .connectionArn(aws_apprunner_connection.example().arn())
 *                     .build())
 *                 .codeRepository(ServiceSourceConfigurationCodeRepositoryArgs.builder()
 *                     .codeConfiguration(ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs.builder()
 *                         .codeConfigurationValues(ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs.builder()
 *                             .buildCommand(&#34;python setup.py develop&#34;)
 *                             .port(&#34;8000&#34;)
 *                             .runtime(&#34;PYTHON_3&#34;)
 *                             .startCommand(&#34;python runapp.py&#34;)
 *                             .build())
 *                         .configurationSource(&#34;API&#34;)
 *                         .build())
 *                     .repositoryUrl(&#34;https://github.com/example/my-example-python-app&#34;)
 *                     .sourceCodeVersion(ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs.builder()
 *                         .type(&#34;BRANCH&#34;)
 *                         .value(&#34;main&#34;)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .networkConfiguration(ServiceNetworkConfigurationArgs.builder()
 *                 .egressConfiguration(ServiceNetworkConfigurationEgressConfigurationArgs.builder()
 *                     .egressType(&#34;VPC&#34;)
 *                     .vpcConnectorArn(aws_apprunner_vpc_connector.connector().arn())
 *                     .build())
 *                 .build())
 *             .tags(Map.of(&#34;Name&#34;, &#34;example-apprunner-service&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Service with an Image Repository Source
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.Service;
 * import com.pulumi.aws.apprunner.ServiceArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Service(&#34;example&#34;, ServiceArgs.builder()        
 *             .serviceName(&#34;example&#34;)
 *             .sourceConfiguration(ServiceSourceConfigurationArgs.builder()
 *                 .autoDeploymentsEnabled(false)
 *                 .imageRepository(ServiceSourceConfigurationImageRepositoryArgs.builder()
 *                     .imageConfiguration(ServiceSourceConfigurationImageRepositoryImageConfigurationArgs.builder()
 *                         .port(&#34;8000&#34;)
 *                         .build())
 *                     .imageIdentifier(&#34;public.ecr.aws/aws-containers/hello-app-runner:latest&#34;)
 *                     .imageRepositoryType(&#34;ECR_PUBLIC&#34;)
 *                     .build())
 *                 .build())
 *             .tags(Map.of(&#34;Name&#34;, &#34;example-apprunner-service&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Service with Observability Configuration
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.ObservabilityConfiguration;
 * import com.pulumi.aws.apprunner.ObservabilityConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ObservabilityConfigurationTraceConfigurationArgs;
 * import com.pulumi.aws.apprunner.Service;
 * import com.pulumi.aws.apprunner.ServiceArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceObservabilityConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleObservabilityConfiguration = new ObservabilityConfiguration(&#34;exampleObservabilityConfiguration&#34;, ObservabilityConfigurationArgs.builder()        
 *             .observabilityConfigurationName(&#34;example&#34;)
 *             .traceConfiguration(ObservabilityConfigurationTraceConfigurationArgs.builder()
 *                 .vendor(&#34;AWSXRAY&#34;)
 *                 .build())
 *             .build());
 * 
 *         var exampleService = new Service(&#34;exampleService&#34;, ServiceArgs.builder()        
 *             .serviceName(&#34;example&#34;)
 *             .observabilityConfiguration(ServiceObservabilityConfigurationArgs.builder()
 *                 .observabilityConfigurationArn(exampleObservabilityConfiguration.arn())
 *                 .observabilityEnabled(true)
 *                 .build())
 *             .sourceConfiguration(ServiceSourceConfigurationArgs.builder()
 *                 .imageRepository(ServiceSourceConfigurationImageRepositoryArgs.builder()
 *                     .imageConfiguration(ServiceSourceConfigurationImageRepositoryImageConfigurationArgs.builder()
 *                         .port(&#34;8000&#34;)
 *                         .build())
 *                     .imageIdentifier(&#34;public.ecr.aws/aws-containers/hello-app-runner:latest&#34;)
 *                     .imageRepositoryType(&#34;ECR_PUBLIC&#34;)
 *                     .build())
 *                 .autoDeploymentsEnabled(false)
 *                 .build())
 *             .tags(Map.of(&#34;Name&#34;, &#34;example-apprunner-service&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import App Runner Services using the `arn`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:apprunner/service:Service example arn:aws:apprunner:us-east-1:1234567890:service/example/0a03292a89764e5882c41d8f991c82fe
 * ```
 * 
 */
@ResourceType(type="aws:apprunner/service:Service")
public class Service extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the App Runner service.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the App Runner service.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * ARN of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner associates the latest revision of a default auto scaling configuration.
     * 
     */
    @Export(name="autoScalingConfigurationArn", refs={String.class}, tree="[0]")
    private Output<String> autoScalingConfigurationArn;

    /**
     * @return ARN of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner associates the latest revision of a default auto scaling configuration.
     * 
     */
    public Output<String> autoScalingConfigurationArn() {
        return this.autoScalingConfigurationArn;
    }
    /**
     * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an AWS managed CMK. See Encryption Configuration below for more details.
     * 
     */
    @Export(name="encryptionConfiguration", refs={ServiceEncryptionConfiguration.class}, tree="[0]")
    private Output</* @Nullable */ ServiceEncryptionConfiguration> encryptionConfiguration;

    /**
     * @return An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an AWS managed CMK. See Encryption Configuration below for more details.
     * 
     */
    public Output<Optional<ServiceEncryptionConfiguration>> encryptionConfiguration() {
        return Codegen.optional(this.encryptionConfiguration);
    }
    /**
     * Settings of the health check that AWS App Runner performs to monitor the health of your service. See Health Check Configuration below for more details.
     * 
     */
    @Export(name="healthCheckConfiguration", refs={ServiceHealthCheckConfiguration.class}, tree="[0]")
    private Output<ServiceHealthCheckConfiguration> healthCheckConfiguration;

    /**
     * @return Settings of the health check that AWS App Runner performs to monitor the health of your service. See Health Check Configuration below for more details.
     * 
     */
    public Output<ServiceHealthCheckConfiguration> healthCheckConfiguration() {
        return this.healthCheckConfiguration;
    }
    /**
     * The runtime configuration of instances (scaling units) of the App Runner service. See Instance Configuration below for more details.
     * 
     */
    @Export(name="instanceConfiguration", refs={ServiceInstanceConfiguration.class}, tree="[0]")
    private Output<ServiceInstanceConfiguration> instanceConfiguration;

    /**
     * @return The runtime configuration of instances (scaling units) of the App Runner service. See Instance Configuration below for more details.
     * 
     */
    public Output<ServiceInstanceConfiguration> instanceConfiguration() {
        return this.instanceConfiguration;
    }
    /**
     * Configuration settings related to network traffic of the web application that the App Runner service runs. See Network Configuration below for more details.
     * 
     */
    @Export(name="networkConfiguration", refs={ServiceNetworkConfiguration.class}, tree="[0]")
    private Output<ServiceNetworkConfiguration> networkConfiguration;

    /**
     * @return Configuration settings related to network traffic of the web application that the App Runner service runs. See Network Configuration below for more details.
     * 
     */
    public Output<ServiceNetworkConfiguration> networkConfiguration() {
        return this.networkConfiguration;
    }
    /**
     * The observability configuration of your service. See Observability Configuration below for more details.
     * 
     */
    @Export(name="observabilityConfiguration", refs={ServiceObservabilityConfiguration.class}, tree="[0]")
    private Output</* @Nullable */ ServiceObservabilityConfiguration> observabilityConfiguration;

    /**
     * @return The observability configuration of your service. See Observability Configuration below for more details.
     * 
     */
    public Output<Optional<ServiceObservabilityConfiguration>> observabilityConfiguration() {
        return Codegen.optional(this.observabilityConfiguration);
    }
    /**
     * An alphanumeric ID that App Runner generated for this service. Unique within the AWS Region.
     * 
     */
    @Export(name="serviceId", refs={String.class}, tree="[0]")
    private Output<String> serviceId;

    /**
     * @return An alphanumeric ID that App Runner generated for this service. Unique within the AWS Region.
     * 
     */
    public Output<String> serviceId() {
        return this.serviceId;
    }
    /**
     * Name of the service.
     * 
     */
    @Export(name="serviceName", refs={String.class}, tree="[0]")
    private Output<String> serviceName;

    /**
     * @return Name of the service.
     * 
     */
    public Output<String> serviceName() {
        return this.serviceName;
    }
    /**
     * Subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.
     * 
     */
    @Export(name="serviceUrl", refs={String.class}, tree="[0]")
    private Output<String> serviceUrl;

    /**
     * @return Subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.
     * 
     */
    public Output<String> serviceUrl() {
        return this.serviceUrl;
    }
    /**
     * The source to deploy to the App Runner service. Can be a code or an image repository. See Source Configuration below for more details.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="sourceConfiguration", refs={ServiceSourceConfiguration.class}, tree="[0]")
    private Output<ServiceSourceConfiguration> sourceConfiguration;

    /**
     * @return The source to deploy to the App Runner service. Can be a code or an image repository. See Source Configuration below for more details.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<ServiceSourceConfiguration> sourceConfiguration() {
        return this.sourceConfiguration;
    }
    /**
     * Current state of the App Runner service.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return Current state of the App Runner service.
     * 
     */
    public Output<String> status() {
        return this.status;
    }
    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Service(String name) {
        this(name, ServiceArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Service(String name, ServiceArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Service(String name, ServiceArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:apprunner/service:Service", name, args == null ? ServiceArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Service(String name, Output<String> id, @Nullable ServiceState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:apprunner/service:Service", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Service get(String name, Output<String> id, @Nullable ServiceState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Service(name, id, state, options);
    }
}
