// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.appmesh.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class VirtualNodeSpecListenerHealthCheckArgs extends com.pulumi.resources.ResourceArgs {

    public static final VirtualNodeSpecListenerHealthCheckArgs Empty = new VirtualNodeSpecListenerHealthCheckArgs();

    /**
     * Number of consecutive successful health checks that must occur before declaring listener healthy.
     * 
     */
    @Import(name="healthyThreshold", required=true)
    private Output<Integer> healthyThreshold;

    /**
     * @return Number of consecutive successful health checks that must occur before declaring listener healthy.
     * 
     */
    public Output<Integer> healthyThreshold() {
        return this.healthyThreshold;
    }

    /**
     * Time period in milliseconds between each health check execution.
     * 
     */
    @Import(name="intervalMillis", required=true)
    private Output<Integer> intervalMillis;

    /**
     * @return Time period in milliseconds between each health check execution.
     * 
     */
    public Output<Integer> intervalMillis() {
        return this.intervalMillis;
    }

    /**
     * Destination path for the health check request. This is only required if the specified protocol is `http` or `http2`.
     * 
     */
    @Import(name="path")
    private @Nullable Output<String> path;

    /**
     * @return Destination path for the health check request. This is only required if the specified protocol is `http` or `http2`.
     * 
     */
    public Optional<Output<String>> path() {
        return Optional.ofNullable(this.path);
    }

    /**
     * Destination port for the health check request. This port must match the port defined in the `port_mapping` for the listener.
     * 
     */
    @Import(name="port")
    private @Nullable Output<Integer> port;

    /**
     * @return Destination port for the health check request. This port must match the port defined in the `port_mapping` for the listener.
     * 
     */
    public Optional<Output<Integer>> port() {
        return Optional.ofNullable(this.port);
    }

    /**
     * Protocol for the health check request. Valid values are `http`, `http2`, `tcp` and `grpc`.
     * 
     */
    @Import(name="protocol", required=true)
    private Output<String> protocol;

    /**
     * @return Protocol for the health check request. Valid values are `http`, `http2`, `tcp` and `grpc`.
     * 
     */
    public Output<String> protocol() {
        return this.protocol;
    }

    /**
     * Amount of time to wait when receiving a response from the health check, in milliseconds.
     * 
     */
    @Import(name="timeoutMillis", required=true)
    private Output<Integer> timeoutMillis;

    /**
     * @return Amount of time to wait when receiving a response from the health check, in milliseconds.
     * 
     */
    public Output<Integer> timeoutMillis() {
        return this.timeoutMillis;
    }

    /**
     * Number of consecutive failed health checks that must occur before declaring a virtual node unhealthy.
     * 
     */
    @Import(name="unhealthyThreshold", required=true)
    private Output<Integer> unhealthyThreshold;

    /**
     * @return Number of consecutive failed health checks that must occur before declaring a virtual node unhealthy.
     * 
     */
    public Output<Integer> unhealthyThreshold() {
        return this.unhealthyThreshold;
    }

    private VirtualNodeSpecListenerHealthCheckArgs() {}

    private VirtualNodeSpecListenerHealthCheckArgs(VirtualNodeSpecListenerHealthCheckArgs $) {
        this.healthyThreshold = $.healthyThreshold;
        this.intervalMillis = $.intervalMillis;
        this.path = $.path;
        this.port = $.port;
        this.protocol = $.protocol;
        this.timeoutMillis = $.timeoutMillis;
        this.unhealthyThreshold = $.unhealthyThreshold;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(VirtualNodeSpecListenerHealthCheckArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private VirtualNodeSpecListenerHealthCheckArgs $;

        public Builder() {
            $ = new VirtualNodeSpecListenerHealthCheckArgs();
        }

        public Builder(VirtualNodeSpecListenerHealthCheckArgs defaults) {
            $ = new VirtualNodeSpecListenerHealthCheckArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param healthyThreshold Number of consecutive successful health checks that must occur before declaring listener healthy.
         * 
         * @return builder
         * 
         */
        public Builder healthyThreshold(Output<Integer> healthyThreshold) {
            $.healthyThreshold = healthyThreshold;
            return this;
        }

        /**
         * @param healthyThreshold Number of consecutive successful health checks that must occur before declaring listener healthy.
         * 
         * @return builder
         * 
         */
        public Builder healthyThreshold(Integer healthyThreshold) {
            return healthyThreshold(Output.of(healthyThreshold));
        }

        /**
         * @param intervalMillis Time period in milliseconds between each health check execution.
         * 
         * @return builder
         * 
         */
        public Builder intervalMillis(Output<Integer> intervalMillis) {
            $.intervalMillis = intervalMillis;
            return this;
        }

        /**
         * @param intervalMillis Time period in milliseconds between each health check execution.
         * 
         * @return builder
         * 
         */
        public Builder intervalMillis(Integer intervalMillis) {
            return intervalMillis(Output.of(intervalMillis));
        }

        /**
         * @param path Destination path for the health check request. This is only required if the specified protocol is `http` or `http2`.
         * 
         * @return builder
         * 
         */
        public Builder path(@Nullable Output<String> path) {
            $.path = path;
            return this;
        }

        /**
         * @param path Destination path for the health check request. This is only required if the specified protocol is `http` or `http2`.
         * 
         * @return builder
         * 
         */
        public Builder path(String path) {
            return path(Output.of(path));
        }

        /**
         * @param port Destination port for the health check request. This port must match the port defined in the `port_mapping` for the listener.
         * 
         * @return builder
         * 
         */
        public Builder port(@Nullable Output<Integer> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port Destination port for the health check request. This port must match the port defined in the `port_mapping` for the listener.
         * 
         * @return builder
         * 
         */
        public Builder port(Integer port) {
            return port(Output.of(port));
        }

        /**
         * @param protocol Protocol for the health check request. Valid values are `http`, `http2`, `tcp` and `grpc`.
         * 
         * @return builder
         * 
         */
        public Builder protocol(Output<String> protocol) {
            $.protocol = protocol;
            return this;
        }

        /**
         * @param protocol Protocol for the health check request. Valid values are `http`, `http2`, `tcp` and `grpc`.
         * 
         * @return builder
         * 
         */
        public Builder protocol(String protocol) {
            return protocol(Output.of(protocol));
        }

        /**
         * @param timeoutMillis Amount of time to wait when receiving a response from the health check, in milliseconds.
         * 
         * @return builder
         * 
         */
        public Builder timeoutMillis(Output<Integer> timeoutMillis) {
            $.timeoutMillis = timeoutMillis;
            return this;
        }

        /**
         * @param timeoutMillis Amount of time to wait when receiving a response from the health check, in milliseconds.
         * 
         * @return builder
         * 
         */
        public Builder timeoutMillis(Integer timeoutMillis) {
            return timeoutMillis(Output.of(timeoutMillis));
        }

        /**
         * @param unhealthyThreshold Number of consecutive failed health checks that must occur before declaring a virtual node unhealthy.
         * 
         * @return builder
         * 
         */
        public Builder unhealthyThreshold(Output<Integer> unhealthyThreshold) {
            $.unhealthyThreshold = unhealthyThreshold;
            return this;
        }

        /**
         * @param unhealthyThreshold Number of consecutive failed health checks that must occur before declaring a virtual node unhealthy.
         * 
         * @return builder
         * 
         */
        public Builder unhealthyThreshold(Integer unhealthyThreshold) {
            return unhealthyThreshold(Output.of(unhealthyThreshold));
        }

        public VirtualNodeSpecListenerHealthCheckArgs build() {
            $.healthyThreshold = Objects.requireNonNull($.healthyThreshold, "expected parameter 'healthyThreshold' to be non-null");
            $.intervalMillis = Objects.requireNonNull($.intervalMillis, "expected parameter 'intervalMillis' to be non-null");
            $.protocol = Objects.requireNonNull($.protocol, "expected parameter 'protocol' to be non-null");
            $.timeoutMillis = Objects.requireNonNull($.timeoutMillis, "expected parameter 'timeoutMillis' to be non-null");
            $.unhealthyThreshold = Objects.requireNonNull($.unhealthyThreshold, "expected parameter 'unhealthyThreshold' to be non-null");
            return $;
        }
    }

}
