// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.applicationinsights;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.applicationinsights.ApplicationArgs;
import com.pulumi.aws.applicationinsights.inputs.ApplicationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a ApplicationInsights Application resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.resourcegroups.Group;
 * import com.pulumi.aws.resourcegroups.GroupArgs;
 * import com.pulumi.aws.resourcegroups.inputs.GroupResourceQueryArgs;
 * import com.pulumi.aws.applicationinsights.Application;
 * import com.pulumi.aws.applicationinsights.ApplicationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleGroup = new Group(&#34;exampleGroup&#34;, GroupArgs.builder()        
 *             .resourceQuery(GroupResourceQueryArgs.builder()
 *                 .query(serializeJson(
 *                     jsonObject(
 *                         jsonProperty(&#34;ResourceTypeFilters&#34;, jsonArray(&#34;AWS::EC2::Instance&#34;)),
 *                         jsonProperty(&#34;TagFilters&#34;, jsonArray(jsonObject(
 *                             jsonProperty(&#34;Key&#34;, &#34;Stage&#34;),
 *                             jsonProperty(&#34;Values&#34;, jsonArray(&#34;Test&#34;))
 *                         )))
 *                     )))
 *                 .build())
 *             .build());
 * 
 *         var exampleApplication = new Application(&#34;exampleApplication&#34;, ApplicationArgs.builder()        
 *             .resourceGroupName(exampleGroup.name())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import ApplicationInsights Applications using the `resource_group_name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:applicationinsights/application:Application some some-application
 * ```
 * 
 */
@ResourceType(type="aws:applicationinsights/application:Application")
public class Application extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the Application.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the Application.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Indicates whether Application Insights automatically configures unmonitored resources in the resource group.
     * 
     */
    @Export(name="autoConfigEnabled", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> autoConfigEnabled;

    /**
     * @return Indicates whether Application Insights automatically configures unmonitored resources in the resource group.
     * 
     */
    public Output<Optional<Boolean>> autoConfigEnabled() {
        return Codegen.optional(this.autoConfigEnabled);
    }
    /**
     * Configures all of the resources in the resource group by applying the recommended configurations.
     * 
     */
    @Export(name="autoCreate", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> autoCreate;

    /**
     * @return Configures all of the resources in the resource group by applying the recommended configurations.
     * 
     */
    public Output<Optional<Boolean>> autoCreate() {
        return Codegen.optional(this.autoCreate);
    }
    /**
     * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
     * 
     */
    @Export(name="cweMonitorEnabled", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> cweMonitorEnabled;

    /**
     * @return Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
     * 
     */
    public Output<Optional<Boolean>> cweMonitorEnabled() {
        return Codegen.optional(this.cweMonitorEnabled);
    }
    /**
     * Application Insights can create applications based on a resource group or on an account. To create an account-based application using all of the resources in the account, set this parameter to `ACCOUNT_BASED`.
     * 
     */
    @Export(name="groupingType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> groupingType;

    /**
     * @return Application Insights can create applications based on a resource group or on an account. To create an account-based application using all of the resources in the account, set this parameter to `ACCOUNT_BASED`.
     * 
     */
    public Output<Optional<String>> groupingType() {
        return Codegen.optional(this.groupingType);
    }
    /**
     * When set to `true`, creates opsItems for any problems detected on an application.
     * 
     */
    @Export(name="opsCenterEnabled", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> opsCenterEnabled;

    /**
     * @return When set to `true`, creates opsItems for any problems detected on an application.
     * 
     */
    public Output<Optional<Boolean>> opsCenterEnabled() {
        return Codegen.optional(this.opsCenterEnabled);
    }
    /**
     * SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem.
     * 
     */
    @Export(name="opsItemSnsTopicArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> opsItemSnsTopicArn;

    /**
     * @return SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem.
     * 
     */
    public Output<Optional<String>> opsItemSnsTopicArn() {
        return Codegen.optional(this.opsItemSnsTopicArn);
    }
    /**
     * Name of the resource group.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="resourceGroupName", refs={String.class}, tree="[0]")
    private Output<String> resourceGroupName;

    /**
     * @return Name of the resource group.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> resourceGroupName() {
        return this.resourceGroupName;
    }
    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Application(String name) {
        this(name, ApplicationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Application(String name, ApplicationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Application(String name, ApplicationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:applicationinsights/application:Application", name, args == null ? ApplicationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Application(String name, Output<String> id, @Nullable ApplicationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:applicationinsights/application:Application", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Application get(String name, Output<String> id, @Nullable ApplicationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Application(name, id, state, options);
    }
}
