// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.appflow;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.appflow.ConnectorProfileArgs;
import com.pulumi.aws.appflow.inputs.ConnectorProfileState;
import com.pulumi.aws.appflow.outputs.ConnectorProfileConnectorProfileConfig;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an AppFlow connector profile resource.
 * 
 * For information about AppFlow flows, see the [Amazon AppFlow API Reference](https://docs.aws.amazon.com/appflow/1.0/APIReference/Welcome.html).
 * For specific information about creating an AppFlow connector profile, see the
 * [CreateConnectorProfile](https://docs.aws.amazon.com/appflow/1.0/APIReference/API_CreateConnectorProfile.html) page in the Amazon AppFlow API Reference.
 * 
 * ## Import
 * 
 * Using `pulumi import`, import AppFlow Connector Profile using the connector profile `arn`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:appflow/connectorProfile:ConnectorProfile profile arn:aws:appflow:us-west-2:123456789012:connectorprofile/example-profile
 * ```
 * 
 */
@ResourceType(type="aws:appflow/connectorProfile:ConnectorProfile")
public class ConnectorProfile extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the connector profile.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the connector profile.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Indicates the connection mode and specifies whether it is public or private. Private flows use AWS PrivateLink to route data over AWS infrastructure without exposing it to the public internet. One of: `Public`, `Private`.
     * 
     */
    @Export(name="connectionMode", refs={String.class}, tree="[0]")
    private Output<String> connectionMode;

    /**
     * @return Indicates the connection mode and specifies whether it is public or private. Private flows use AWS PrivateLink to route data over AWS infrastructure without exposing it to the public internet. One of: `Public`, `Private`.
     * 
     */
    public Output<String> connectionMode() {
        return this.connectionMode;
    }
    /**
     * The label of the connector. The label is unique for each ConnectorRegistration in your AWS account. Only needed if calling for `CustomConnector` connector type.
     * 
     */
    @Export(name="connectorLabel", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> connectorLabel;

    /**
     * @return The label of the connector. The label is unique for each ConnectorRegistration in your AWS account. Only needed if calling for `CustomConnector` connector type.
     * 
     */
    public Output<Optional<String>> connectorLabel() {
        return Codegen.optional(this.connectorLabel);
    }
    /**
     * Defines the connector-specific configuration and credentials. See Connector Profile Config for more details.
     * 
     */
    @Export(name="connectorProfileConfig", refs={ConnectorProfileConnectorProfileConfig.class}, tree="[0]")
    private Output<ConnectorProfileConnectorProfileConfig> connectorProfileConfig;

    /**
     * @return Defines the connector-specific configuration and credentials. See Connector Profile Config for more details.
     * 
     */
    public Output<ConnectorProfileConnectorProfileConfig> connectorProfileConfig() {
        return this.connectorProfileConfig;
    }
    /**
     * The type of connector. One of: `Amplitude`, `CustomConnector`, `CustomerProfiles`, `Datadog`, `Dynatrace`, `EventBridge`, `Googleanalytics`, `Honeycode`, `Infornexus`, `LookoutMetrics`, `Marketo`, `Redshift`, `S3`, `Salesforce`, `SAPOData`, `Servicenow`, `Singular`, `Slack`, `Snowflake`, `Trendmicro`, `Upsolver`, `Veeva`, `Zendesk`.
     * 
     */
    @Export(name="connectorType", refs={String.class}, tree="[0]")
    private Output<String> connectorType;

    /**
     * @return The type of connector. One of: `Amplitude`, `CustomConnector`, `CustomerProfiles`, `Datadog`, `Dynatrace`, `EventBridge`, `Googleanalytics`, `Honeycode`, `Infornexus`, `LookoutMetrics`, `Marketo`, `Redshift`, `S3`, `Salesforce`, `SAPOData`, `Servicenow`, `Singular`, `Slack`, `Snowflake`, `Trendmicro`, `Upsolver`, `Veeva`, `Zendesk`.
     * 
     */
    public Output<String> connectorType() {
        return this.connectorType;
    }
    /**
     * ARN of the connector profile credentials.
     * 
     */
    @Export(name="credentialsArn", refs={String.class}, tree="[0]")
    private Output<String> credentialsArn;

    /**
     * @return ARN of the connector profile credentials.
     * 
     */
    public Output<String> credentialsArn() {
        return this.credentialsArn;
    }
    /**
     * ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don&#39;t provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     * 
     */
    @Export(name="kmsArn", refs={String.class}, tree="[0]")
    private Output<String> kmsArn;

    /**
     * @return ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don&#39;t provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     * 
     */
    public Output<String> kmsArn() {
        return this.kmsArn;
    }
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    public Output<String> name() {
        return this.name;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ConnectorProfile(String name) {
        this(name, ConnectorProfileArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ConnectorProfile(String name, ConnectorProfileArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ConnectorProfile(String name, ConnectorProfileArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:appflow/connectorProfile:ConnectorProfile", name, args == null ? ConnectorProfileArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ConnectorProfile(String name, Output<String> id, @Nullable ConnectorProfileState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:appflow/connectorProfile:ConnectorProfile", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ConnectorProfile get(String name, Output<String> id, @Nullable ConnectorProfileState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ConnectorProfile(name, id, state, options);
    }
}
