// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.appconfig;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class DeploymentArgs extends com.pulumi.resources.ResourceArgs {

    public static final DeploymentArgs Empty = new DeploymentArgs();

    /**
     * Application ID. Must be between 4 and 7 characters in length.
     * 
     */
    @Import(name="applicationId", required=true)
    private Output<String> applicationId;

    /**
     * @return Application ID. Must be between 4 and 7 characters in length.
     * 
     */
    public Output<String> applicationId() {
        return this.applicationId;
    }

    /**
     * Configuration profile ID. Must be between 4 and 7 characters in length.
     * 
     */
    @Import(name="configurationProfileId", required=true)
    private Output<String> configurationProfileId;

    /**
     * @return Configuration profile ID. Must be between 4 and 7 characters in length.
     * 
     */
    public Output<String> configurationProfileId() {
        return this.configurationProfileId;
    }

    /**
     * Configuration version to deploy. Can be at most 1024 characters.
     * 
     */
    @Import(name="configurationVersion", required=true)
    private Output<String> configurationVersion;

    /**
     * @return Configuration version to deploy. Can be at most 1024 characters.
     * 
     */
    public Output<String> configurationVersion() {
        return this.configurationVersion;
    }

    /**
     * Deployment strategy ID or name of a predefined deployment strategy. See [Predefined Deployment Strategies](https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-deployment-strategy.html#appconfig-creating-deployment-strategy-predefined) for more details.
     * 
     */
    @Import(name="deploymentStrategyId", required=true)
    private Output<String> deploymentStrategyId;

    /**
     * @return Deployment strategy ID or name of a predefined deployment strategy. See [Predefined Deployment Strategies](https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-deployment-strategy.html#appconfig-creating-deployment-strategy-predefined) for more details.
     * 
     */
    public Output<String> deploymentStrategyId() {
        return this.deploymentStrategyId;
    }

    /**
     * Description of the deployment. Can be at most 1024 characters.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Description of the deployment. Can be at most 1024 characters.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Environment ID. Must be between 4 and 7 characters in length.
     * 
     */
    @Import(name="environmentId", required=true)
    private Output<String> environmentId;

    /**
     * @return Environment ID. Must be between 4 and 7 characters in length.
     * 
     */
    public Output<String> environmentId() {
        return this.environmentId;
    }

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private DeploymentArgs() {}

    private DeploymentArgs(DeploymentArgs $) {
        this.applicationId = $.applicationId;
        this.configurationProfileId = $.configurationProfileId;
        this.configurationVersion = $.configurationVersion;
        this.deploymentStrategyId = $.deploymentStrategyId;
        this.description = $.description;
        this.environmentId = $.environmentId;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DeploymentArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DeploymentArgs $;

        public Builder() {
            $ = new DeploymentArgs();
        }

        public Builder(DeploymentArgs defaults) {
            $ = new DeploymentArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param applicationId Application ID. Must be between 4 and 7 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder applicationId(Output<String> applicationId) {
            $.applicationId = applicationId;
            return this;
        }

        /**
         * @param applicationId Application ID. Must be between 4 and 7 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder applicationId(String applicationId) {
            return applicationId(Output.of(applicationId));
        }

        /**
         * @param configurationProfileId Configuration profile ID. Must be between 4 and 7 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder configurationProfileId(Output<String> configurationProfileId) {
            $.configurationProfileId = configurationProfileId;
            return this;
        }

        /**
         * @param configurationProfileId Configuration profile ID. Must be between 4 and 7 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder configurationProfileId(String configurationProfileId) {
            return configurationProfileId(Output.of(configurationProfileId));
        }

        /**
         * @param configurationVersion Configuration version to deploy. Can be at most 1024 characters.
         * 
         * @return builder
         * 
         */
        public Builder configurationVersion(Output<String> configurationVersion) {
            $.configurationVersion = configurationVersion;
            return this;
        }

        /**
         * @param configurationVersion Configuration version to deploy. Can be at most 1024 characters.
         * 
         * @return builder
         * 
         */
        public Builder configurationVersion(String configurationVersion) {
            return configurationVersion(Output.of(configurationVersion));
        }

        /**
         * @param deploymentStrategyId Deployment strategy ID or name of a predefined deployment strategy. See [Predefined Deployment Strategies](https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-deployment-strategy.html#appconfig-creating-deployment-strategy-predefined) for more details.
         * 
         * @return builder
         * 
         */
        public Builder deploymentStrategyId(Output<String> deploymentStrategyId) {
            $.deploymentStrategyId = deploymentStrategyId;
            return this;
        }

        /**
         * @param deploymentStrategyId Deployment strategy ID or name of a predefined deployment strategy. See [Predefined Deployment Strategies](https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-deployment-strategy.html#appconfig-creating-deployment-strategy-predefined) for more details.
         * 
         * @return builder
         * 
         */
        public Builder deploymentStrategyId(String deploymentStrategyId) {
            return deploymentStrategyId(Output.of(deploymentStrategyId));
        }

        /**
         * @param description Description of the deployment. Can be at most 1024 characters.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Description of the deployment. Can be at most 1024 characters.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param environmentId Environment ID. Must be between 4 and 7 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder environmentId(Output<String> environmentId) {
            $.environmentId = environmentId;
            return this;
        }

        /**
         * @param environmentId Environment ID. Must be between 4 and 7 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder environmentId(String environmentId) {
            return environmentId(Output.of(environmentId));
        }

        /**
         * @param tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public DeploymentArgs build() {
            $.applicationId = Objects.requireNonNull($.applicationId, "expected parameter 'applicationId' to be non-null");
            $.configurationProfileId = Objects.requireNonNull($.configurationProfileId, "expected parameter 'configurationProfileId' to be non-null");
            $.configurationVersion = Objects.requireNonNull($.configurationVersion, "expected parameter 'configurationVersion' to be non-null");
            $.deploymentStrategyId = Objects.requireNonNull($.deploymentStrategyId, "expected parameter 'deploymentStrategyId' to be non-null");
            $.environmentId = Objects.requireNonNull($.environmentId, "expected parameter 'environmentId' to be non-null");
            return $;
        }
    }

}
