// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apigatewayv2.inputs;

import com.pulumi.aws.apigatewayv2.inputs.IntegrationResponseParameterArgs;
import com.pulumi.aws.apigatewayv2.inputs.IntegrationTlsConfigArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class IntegrationState extends com.pulumi.resources.ResourceArgs {

    public static final IntegrationState Empty = new IntegrationState();

    /**
     * API identifier.
     * 
     */
    @Import(name="apiId")
    private @Nullable Output<String> apiId;

    /**
     * @return API identifier.
     * 
     */
    public Optional<Output<String>> apiId() {
        return Optional.ofNullable(this.apiId);
    }

    /**
     * ID of the VPC link for a private integration. Supported only for HTTP APIs. Must be between 1 and 1024 characters in length.
     * 
     */
    @Import(name="connectionId")
    private @Nullable Output<String> connectionId;

    /**
     * @return ID of the VPC link for a private integration. Supported only for HTTP APIs. Must be between 1 and 1024 characters in length.
     * 
     */
    public Optional<Output<String>> connectionId() {
        return Optional.ofNullable(this.connectionId);
    }

    /**
     * Type of the network connection to the integration endpoint. Valid values: `INTERNET`, `VPC_LINK`. Default is `INTERNET`.
     * 
     */
    @Import(name="connectionType")
    private @Nullable Output<String> connectionType;

    /**
     * @return Type of the network connection to the integration endpoint. Valid values: `INTERNET`, `VPC_LINK`. Default is `INTERNET`.
     * 
     */
    public Optional<Output<String>> connectionType() {
        return Optional.ofNullable(this.connectionType);
    }

    /**
     * How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`. Supported only for WebSocket APIs.
     * 
     */
    @Import(name="contentHandlingStrategy")
    private @Nullable Output<String> contentHandlingStrategy;

    /**
     * @return How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`. Supported only for WebSocket APIs.
     * 
     */
    public Optional<Output<String>> contentHandlingStrategy() {
        return Optional.ofNullable(this.contentHandlingStrategy);
    }

    /**
     * Credentials required for the integration, if any.
     * 
     */
    @Import(name="credentialsArn")
    private @Nullable Output<String> credentialsArn;

    /**
     * @return Credentials required for the integration, if any.
     * 
     */
    public Optional<Output<String>> credentialsArn() {
        return Optional.ofNullable(this.credentialsArn);
    }

    /**
     * Description of the integration.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Description of the integration.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Integration&#39;s HTTP method. Must be specified if `integration_type` is not `MOCK`.
     * 
     */
    @Import(name="integrationMethod")
    private @Nullable Output<String> integrationMethod;

    /**
     * @return Integration&#39;s HTTP method. Must be specified if `integration_type` is not `MOCK`.
     * 
     */
    public Optional<Output<String>> integrationMethod() {
        return Optional.ofNullable(this.integrationMethod);
    }

    /**
     * The [integration response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions) for the integration.
     * 
     */
    @Import(name="integrationResponseSelectionExpression")
    private @Nullable Output<String> integrationResponseSelectionExpression;

    /**
     * @return The [integration response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions) for the integration.
     * 
     */
    public Optional<Output<String>> integrationResponseSelectionExpression() {
        return Optional.ofNullable(this.integrationResponseSelectionExpression);
    }

    /**
     * AWS service action to invoke. Supported only for HTTP APIs when `integration_type` is `AWS_PROXY`. See the [AWS service integration reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html) documentation for supported values. Must be between 1 and 128 characters in length.
     * 
     */
    @Import(name="integrationSubtype")
    private @Nullable Output<String> integrationSubtype;

    /**
     * @return AWS service action to invoke. Supported only for HTTP APIs when `integration_type` is `AWS_PROXY`. See the [AWS service integration reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html) documentation for supported values. Must be between 1 and 128 characters in length.
     * 
     */
    public Optional<Output<String>> integrationSubtype() {
        return Optional.ofNullable(this.integrationSubtype);
    }

    /**
     * Integration type of an integration.
     * Valid values: `AWS` (supported only for WebSocket APIs), `AWS_PROXY`, `HTTP` (supported only for WebSocket APIs), `HTTP_PROXY`, `MOCK` (supported only for WebSocket APIs). For an HTTP API private integration, use `HTTP_PROXY`.
     * 
     */
    @Import(name="integrationType")
    private @Nullable Output<String> integrationType;

    /**
     * @return Integration type of an integration.
     * Valid values: `AWS` (supported only for WebSocket APIs), `AWS_PROXY`, `HTTP` (supported only for WebSocket APIs), `HTTP_PROXY`, `MOCK` (supported only for WebSocket APIs). For an HTTP API private integration, use `HTTP_PROXY`.
     * 
     */
    public Optional<Output<String>> integrationType() {
        return Optional.ofNullable(this.integrationType);
    }

    /**
     * URI of the Lambda function for a Lambda proxy integration, when `integration_type` is `AWS_PROXY`.
     * For an `HTTP` integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
     * 
     */
    @Import(name="integrationUri")
    private @Nullable Output<String> integrationUri;

    /**
     * @return URI of the Lambda function for a Lambda proxy integration, when `integration_type` is `AWS_PROXY`.
     * For an `HTTP` integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
     * 
     */
    public Optional<Output<String>> integrationUri() {
        return Optional.ofNullable(this.integrationUri);
    }

    /**
     * Pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `request_templates` attribute.
     * Valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`. Default is `WHEN_NO_MATCH`. Supported only for WebSocket APIs.
     * 
     */
    @Import(name="passthroughBehavior")
    private @Nullable Output<String> passthroughBehavior;

    /**
     * @return Pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `request_templates` attribute.
     * Valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`. Default is `WHEN_NO_MATCH`. Supported only for WebSocket APIs.
     * 
     */
    public Optional<Output<String>> passthroughBehavior() {
        return Optional.ofNullable(this.passthroughBehavior);
    }

    /**
     * The [format of the payload](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html#http-api-develop-integrations-lambda.proxy-format) sent to an integration. Valid values: `1.0`, `2.0`. Default is `1.0`.
     * 
     */
    @Import(name="payloadFormatVersion")
    private @Nullable Output<String> payloadFormatVersion;

    /**
     * @return The [format of the payload](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html#http-api-develop-integrations-lambda.proxy-format) sent to an integration. Valid values: `1.0`, `2.0`. Default is `1.0`.
     * 
     */
    public Optional<Output<String>> payloadFormatVersion() {
        return Optional.ofNullable(this.payloadFormatVersion);
    }

    /**
     * For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
     * For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
     * For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
     * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
     * 
     */
    @Import(name="requestParameters")
    private @Nullable Output<Map<String,String>> requestParameters;

    /**
     * @return For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
     * For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
     * For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
     * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
     * 
     */
    public Optional<Output<Map<String,String>>> requestParameters() {
        return Optional.ofNullable(this.requestParameters);
    }

    /**
     * Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
     * 
     */
    @Import(name="requestTemplates")
    private @Nullable Output<Map<String,String>> requestTemplates;

    /**
     * @return Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
     * 
     */
    public Optional<Output<Map<String,String>>> requestTemplates() {
        return Optional.ofNullable(this.requestTemplates);
    }

    /**
     * Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
     * 
     */
    @Import(name="responseParameters")
    private @Nullable Output<List<IntegrationResponseParameterArgs>> responseParameters;

    /**
     * @return Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
     * 
     */
    public Optional<Output<List<IntegrationResponseParameterArgs>>> responseParameters() {
        return Optional.ofNullable(this.responseParameters);
    }

    /**
     * The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration.
     * 
     */
    @Import(name="templateSelectionExpression")
    private @Nullable Output<String> templateSelectionExpression;

    /**
     * @return The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration.
     * 
     */
    public Optional<Output<String>> templateSelectionExpression() {
        return Optional.ofNullable(this.templateSelectionExpression);
    }

    /**
     * Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
     * The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
     * this provider will only perform drift detection of its value when present in a configuration.
     * 
     */
    @Import(name="timeoutMilliseconds")
    private @Nullable Output<Integer> timeoutMilliseconds;

    /**
     * @return Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
     * The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
     * this provider will only perform drift detection of its value when present in a configuration.
     * 
     */
    public Optional<Output<Integer>> timeoutMilliseconds() {
        return Optional.ofNullable(this.timeoutMilliseconds);
    }

    /**
     * TLS configuration for a private integration. Supported only for HTTP APIs.
     * 
     */
    @Import(name="tlsConfig")
    private @Nullable Output<IntegrationTlsConfigArgs> tlsConfig;

    /**
     * @return TLS configuration for a private integration. Supported only for HTTP APIs.
     * 
     */
    public Optional<Output<IntegrationTlsConfigArgs>> tlsConfig() {
        return Optional.ofNullable(this.tlsConfig);
    }

    private IntegrationState() {}

    private IntegrationState(IntegrationState $) {
        this.apiId = $.apiId;
        this.connectionId = $.connectionId;
        this.connectionType = $.connectionType;
        this.contentHandlingStrategy = $.contentHandlingStrategy;
        this.credentialsArn = $.credentialsArn;
        this.description = $.description;
        this.integrationMethod = $.integrationMethod;
        this.integrationResponseSelectionExpression = $.integrationResponseSelectionExpression;
        this.integrationSubtype = $.integrationSubtype;
        this.integrationType = $.integrationType;
        this.integrationUri = $.integrationUri;
        this.passthroughBehavior = $.passthroughBehavior;
        this.payloadFormatVersion = $.payloadFormatVersion;
        this.requestParameters = $.requestParameters;
        this.requestTemplates = $.requestTemplates;
        this.responseParameters = $.responseParameters;
        this.templateSelectionExpression = $.templateSelectionExpression;
        this.timeoutMilliseconds = $.timeoutMilliseconds;
        this.tlsConfig = $.tlsConfig;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(IntegrationState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private IntegrationState $;

        public Builder() {
            $ = new IntegrationState();
        }

        public Builder(IntegrationState defaults) {
            $ = new IntegrationState(Objects.requireNonNull(defaults));
        }

        /**
         * @param apiId API identifier.
         * 
         * @return builder
         * 
         */
        public Builder apiId(@Nullable Output<String> apiId) {
            $.apiId = apiId;
            return this;
        }

        /**
         * @param apiId API identifier.
         * 
         * @return builder
         * 
         */
        public Builder apiId(String apiId) {
            return apiId(Output.of(apiId));
        }

        /**
         * @param connectionId ID of the VPC link for a private integration. Supported only for HTTP APIs. Must be between 1 and 1024 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder connectionId(@Nullable Output<String> connectionId) {
            $.connectionId = connectionId;
            return this;
        }

        /**
         * @param connectionId ID of the VPC link for a private integration. Supported only for HTTP APIs. Must be between 1 and 1024 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder connectionId(String connectionId) {
            return connectionId(Output.of(connectionId));
        }

        /**
         * @param connectionType Type of the network connection to the integration endpoint. Valid values: `INTERNET`, `VPC_LINK`. Default is `INTERNET`.
         * 
         * @return builder
         * 
         */
        public Builder connectionType(@Nullable Output<String> connectionType) {
            $.connectionType = connectionType;
            return this;
        }

        /**
         * @param connectionType Type of the network connection to the integration endpoint. Valid values: `INTERNET`, `VPC_LINK`. Default is `INTERNET`.
         * 
         * @return builder
         * 
         */
        public Builder connectionType(String connectionType) {
            return connectionType(Output.of(connectionType));
        }

        /**
         * @param contentHandlingStrategy How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`. Supported only for WebSocket APIs.
         * 
         * @return builder
         * 
         */
        public Builder contentHandlingStrategy(@Nullable Output<String> contentHandlingStrategy) {
            $.contentHandlingStrategy = contentHandlingStrategy;
            return this;
        }

        /**
         * @param contentHandlingStrategy How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`. Supported only for WebSocket APIs.
         * 
         * @return builder
         * 
         */
        public Builder contentHandlingStrategy(String contentHandlingStrategy) {
            return contentHandlingStrategy(Output.of(contentHandlingStrategy));
        }

        /**
         * @param credentialsArn Credentials required for the integration, if any.
         * 
         * @return builder
         * 
         */
        public Builder credentialsArn(@Nullable Output<String> credentialsArn) {
            $.credentialsArn = credentialsArn;
            return this;
        }

        /**
         * @param credentialsArn Credentials required for the integration, if any.
         * 
         * @return builder
         * 
         */
        public Builder credentialsArn(String credentialsArn) {
            return credentialsArn(Output.of(credentialsArn));
        }

        /**
         * @param description Description of the integration.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Description of the integration.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param integrationMethod Integration&#39;s HTTP method. Must be specified if `integration_type` is not `MOCK`.
         * 
         * @return builder
         * 
         */
        public Builder integrationMethod(@Nullable Output<String> integrationMethod) {
            $.integrationMethod = integrationMethod;
            return this;
        }

        /**
         * @param integrationMethod Integration&#39;s HTTP method. Must be specified if `integration_type` is not `MOCK`.
         * 
         * @return builder
         * 
         */
        public Builder integrationMethod(String integrationMethod) {
            return integrationMethod(Output.of(integrationMethod));
        }

        /**
         * @param integrationResponseSelectionExpression The [integration response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions) for the integration.
         * 
         * @return builder
         * 
         */
        public Builder integrationResponseSelectionExpression(@Nullable Output<String> integrationResponseSelectionExpression) {
            $.integrationResponseSelectionExpression = integrationResponseSelectionExpression;
            return this;
        }

        /**
         * @param integrationResponseSelectionExpression The [integration response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions) for the integration.
         * 
         * @return builder
         * 
         */
        public Builder integrationResponseSelectionExpression(String integrationResponseSelectionExpression) {
            return integrationResponseSelectionExpression(Output.of(integrationResponseSelectionExpression));
        }

        /**
         * @param integrationSubtype AWS service action to invoke. Supported only for HTTP APIs when `integration_type` is `AWS_PROXY`. See the [AWS service integration reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html) documentation for supported values. Must be between 1 and 128 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder integrationSubtype(@Nullable Output<String> integrationSubtype) {
            $.integrationSubtype = integrationSubtype;
            return this;
        }

        /**
         * @param integrationSubtype AWS service action to invoke. Supported only for HTTP APIs when `integration_type` is `AWS_PROXY`. See the [AWS service integration reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html) documentation for supported values. Must be between 1 and 128 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder integrationSubtype(String integrationSubtype) {
            return integrationSubtype(Output.of(integrationSubtype));
        }

        /**
         * @param integrationType Integration type of an integration.
         * Valid values: `AWS` (supported only for WebSocket APIs), `AWS_PROXY`, `HTTP` (supported only for WebSocket APIs), `HTTP_PROXY`, `MOCK` (supported only for WebSocket APIs). For an HTTP API private integration, use `HTTP_PROXY`.
         * 
         * @return builder
         * 
         */
        public Builder integrationType(@Nullable Output<String> integrationType) {
            $.integrationType = integrationType;
            return this;
        }

        /**
         * @param integrationType Integration type of an integration.
         * Valid values: `AWS` (supported only for WebSocket APIs), `AWS_PROXY`, `HTTP` (supported only for WebSocket APIs), `HTTP_PROXY`, `MOCK` (supported only for WebSocket APIs). For an HTTP API private integration, use `HTTP_PROXY`.
         * 
         * @return builder
         * 
         */
        public Builder integrationType(String integrationType) {
            return integrationType(Output.of(integrationType));
        }

        /**
         * @param integrationUri URI of the Lambda function for a Lambda proxy integration, when `integration_type` is `AWS_PROXY`.
         * For an `HTTP` integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
         * 
         * @return builder
         * 
         */
        public Builder integrationUri(@Nullable Output<String> integrationUri) {
            $.integrationUri = integrationUri;
            return this;
        }

        /**
         * @param integrationUri URI of the Lambda function for a Lambda proxy integration, when `integration_type` is `AWS_PROXY`.
         * For an `HTTP` integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
         * 
         * @return builder
         * 
         */
        public Builder integrationUri(String integrationUri) {
            return integrationUri(Output.of(integrationUri));
        }

        /**
         * @param passthroughBehavior Pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `request_templates` attribute.
         * Valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`. Default is `WHEN_NO_MATCH`. Supported only for WebSocket APIs.
         * 
         * @return builder
         * 
         */
        public Builder passthroughBehavior(@Nullable Output<String> passthroughBehavior) {
            $.passthroughBehavior = passthroughBehavior;
            return this;
        }

        /**
         * @param passthroughBehavior Pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `request_templates` attribute.
         * Valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`. Default is `WHEN_NO_MATCH`. Supported only for WebSocket APIs.
         * 
         * @return builder
         * 
         */
        public Builder passthroughBehavior(String passthroughBehavior) {
            return passthroughBehavior(Output.of(passthroughBehavior));
        }

        /**
         * @param payloadFormatVersion The [format of the payload](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html#http-api-develop-integrations-lambda.proxy-format) sent to an integration. Valid values: `1.0`, `2.0`. Default is `1.0`.
         * 
         * @return builder
         * 
         */
        public Builder payloadFormatVersion(@Nullable Output<String> payloadFormatVersion) {
            $.payloadFormatVersion = payloadFormatVersion;
            return this;
        }

        /**
         * @param payloadFormatVersion The [format of the payload](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html#http-api-develop-integrations-lambda.proxy-format) sent to an integration. Valid values: `1.0`, `2.0`. Default is `1.0`.
         * 
         * @return builder
         * 
         */
        public Builder payloadFormatVersion(String payloadFormatVersion) {
            return payloadFormatVersion(Output.of(payloadFormatVersion));
        }

        /**
         * @param requestParameters For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
         * For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
         * For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
         * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
         * 
         * @return builder
         * 
         */
        public Builder requestParameters(@Nullable Output<Map<String,String>> requestParameters) {
            $.requestParameters = requestParameters;
            return this;
        }

        /**
         * @param requestParameters For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
         * For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
         * For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
         * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
         * 
         * @return builder
         * 
         */
        public Builder requestParameters(Map<String,String> requestParameters) {
            return requestParameters(Output.of(requestParameters));
        }

        /**
         * @param requestTemplates Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
         * 
         * @return builder
         * 
         */
        public Builder requestTemplates(@Nullable Output<Map<String,String>> requestTemplates) {
            $.requestTemplates = requestTemplates;
            return this;
        }

        /**
         * @param requestTemplates Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
         * 
         * @return builder
         * 
         */
        public Builder requestTemplates(Map<String,String> requestTemplates) {
            return requestTemplates(Output.of(requestTemplates));
        }

        /**
         * @param responseParameters Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder responseParameters(@Nullable Output<List<IntegrationResponseParameterArgs>> responseParameters) {
            $.responseParameters = responseParameters;
            return this;
        }

        /**
         * @param responseParameters Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder responseParameters(List<IntegrationResponseParameterArgs> responseParameters) {
            return responseParameters(Output.of(responseParameters));
        }

        /**
         * @param responseParameters Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder responseParameters(IntegrationResponseParameterArgs... responseParameters) {
            return responseParameters(List.of(responseParameters));
        }

        /**
         * @param templateSelectionExpression The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration.
         * 
         * @return builder
         * 
         */
        public Builder templateSelectionExpression(@Nullable Output<String> templateSelectionExpression) {
            $.templateSelectionExpression = templateSelectionExpression;
            return this;
        }

        /**
         * @param templateSelectionExpression The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration.
         * 
         * @return builder
         * 
         */
        public Builder templateSelectionExpression(String templateSelectionExpression) {
            return templateSelectionExpression(Output.of(templateSelectionExpression));
        }

        /**
         * @param timeoutMilliseconds Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
         * The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
         * this provider will only perform drift detection of its value when present in a configuration.
         * 
         * @return builder
         * 
         */
        public Builder timeoutMilliseconds(@Nullable Output<Integer> timeoutMilliseconds) {
            $.timeoutMilliseconds = timeoutMilliseconds;
            return this;
        }

        /**
         * @param timeoutMilliseconds Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
         * The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
         * this provider will only perform drift detection of its value when present in a configuration.
         * 
         * @return builder
         * 
         */
        public Builder timeoutMilliseconds(Integer timeoutMilliseconds) {
            return timeoutMilliseconds(Output.of(timeoutMilliseconds));
        }

        /**
         * @param tlsConfig TLS configuration for a private integration. Supported only for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder tlsConfig(@Nullable Output<IntegrationTlsConfigArgs> tlsConfig) {
            $.tlsConfig = tlsConfig;
            return this;
        }

        /**
         * @param tlsConfig TLS configuration for a private integration. Supported only for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder tlsConfig(IntegrationTlsConfigArgs tlsConfig) {
            return tlsConfig(Output.of(tlsConfig));
        }

        public IntegrationState build() {
            return $;
        }
    }

}
