// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.apigatewayv2.inputs;

import com.pulumi.aws.apigatewayv2.inputs.ApiCorsConfigurationArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ApiState extends com.pulumi.resources.ResourceArgs {

    public static final ApiState Empty = new ApiState();

    /**
     * URI of the API, of the form `https://{api-id}.execute-api.{region}.amazonaws.com` for HTTP APIs and `wss://{api-id}.execute-api.{region}.amazonaws.com` for WebSocket APIs.
     * 
     */
    @Import(name="apiEndpoint")
    private @Nullable Output<String> apiEndpoint;

    /**
     * @return URI of the API, of the form `https://{api-id}.execute-api.{region}.amazonaws.com` for HTTP APIs and `wss://{api-id}.execute-api.{region}.amazonaws.com` for WebSocket APIs.
     * 
     */
    public Optional<Output<String>> apiEndpoint() {
        return Optional.ofNullable(this.apiEndpoint);
    }

    /**
     * An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
     * Valid values: `$context.authorizer.usageIdentifierKey`, `$request.header.x-api-key`. Defaults to `$request.header.x-api-key`.
     * Applicable for WebSocket APIs.
     * 
     */
    @Import(name="apiKeySelectionExpression")
    private @Nullable Output<String> apiKeySelectionExpression;

    /**
     * @return An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
     * Valid values: `$context.authorizer.usageIdentifierKey`, `$request.header.x-api-key`. Defaults to `$request.header.x-api-key`.
     * Applicable for WebSocket APIs.
     * 
     */
    public Optional<Output<String>> apiKeySelectionExpression() {
        return Optional.ofNullable(this.apiKeySelectionExpression);
    }

    /**
     * ARN of the API.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return ARN of the API.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * An OpenAPI specification that defines the set of routes and integrations to create as part of the HTTP APIs. Supported only for HTTP APIs.
     * 
     */
    @Import(name="body")
    private @Nullable Output<String> body;

    /**
     * @return An OpenAPI specification that defines the set of routes and integrations to create as part of the HTTP APIs. Supported only for HTTP APIs.
     * 
     */
    public Optional<Output<String>> body() {
        return Optional.ofNullable(this.body);
    }

    /**
     * Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
     * 
     */
    @Import(name="corsConfiguration")
    private @Nullable Output<ApiCorsConfigurationArgs> corsConfiguration;

    /**
     * @return Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
     * 
     */
    public Optional<Output<ApiCorsConfigurationArgs>> corsConfiguration() {
        return Optional.ofNullable(this.corsConfiguration);
    }

    /**
     * Part of _quick create_. Specifies any credentials required for the integration. Applicable for HTTP APIs.
     * 
     */
    @Import(name="credentialsArn")
    private @Nullable Output<String> credentialsArn;

    /**
     * @return Part of _quick create_. Specifies any credentials required for the integration. Applicable for HTTP APIs.
     * 
     */
    public Optional<Output<String>> credentialsArn() {
        return Optional.ofNullable(this.credentialsArn);
    }

    /**
     * Description of the API. Must be less than or equal to 1024 characters in length.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Description of the API. Must be less than or equal to 1024 characters in length.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Whether clients can invoke the API by using the default `execute-api` endpoint.
     * By default, clients can invoke the API with the default `{api_id}.execute-api.{region}.amazonaws.com endpoint`.
     * To require that clients use a custom domain name to invoke the API, disable the default endpoint.
     * 
     */
    @Import(name="disableExecuteApiEndpoint")
    private @Nullable Output<Boolean> disableExecuteApiEndpoint;

    /**
     * @return Whether clients can invoke the API by using the default `execute-api` endpoint.
     * By default, clients can invoke the API with the default `{api_id}.execute-api.{region}.amazonaws.com endpoint`.
     * To require that clients use a custom domain name to invoke the API, disable the default endpoint.
     * 
     */
    public Optional<Output<Boolean>> disableExecuteApiEndpoint() {
        return Optional.ofNullable(this.disableExecuteApiEndpoint);
    }

    /**
     * ARN prefix to be used in an `aws.lambda.Permission`&#39;s `source_arn` attribute
     * or in an `aws.iam.Policy` to authorize access to the [`@connections` API](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html).
     * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-control-access-iam.html) for details.
     * 
     */
    @Import(name="executionArn")
    private @Nullable Output<String> executionArn;

    /**
     * @return ARN prefix to be used in an `aws.lambda.Permission`&#39;s `source_arn` attribute
     * or in an `aws.iam.Policy` to authorize access to the [`@connections` API](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html).
     * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-control-access-iam.html) for details.
     * 
     */
    public Optional<Output<String>> executionArn() {
        return Optional.ofNullable(this.executionArn);
    }

    /**
     * Whether warnings should return an error while API Gateway is creating or updating the resource using an OpenAPI specification. Defaults to `false`. Applicable for HTTP APIs.
     * 
     */
    @Import(name="failOnWarnings")
    private @Nullable Output<Boolean> failOnWarnings;

    /**
     * @return Whether warnings should return an error while API Gateway is creating or updating the resource using an OpenAPI specification. Defaults to `false`. Applicable for HTTP APIs.
     * 
     */
    public Optional<Output<Boolean>> failOnWarnings() {
        return Optional.ofNullable(this.failOnWarnings);
    }

    /**
     * Name of the API. Must be less than or equal to 128 characters in length.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Name of the API. Must be less than or equal to 128 characters in length.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * API protocol. Valid values: `HTTP`, `WEBSOCKET`.
     * 
     */
    @Import(name="protocolType")
    private @Nullable Output<String> protocolType;

    /**
     * @return API protocol. Valid values: `HTTP`, `WEBSOCKET`.
     * 
     */
    public Optional<Output<String>> protocolType() {
        return Optional.ofNullable(this.protocolType);
    }

    /**
     * Part of _quick create_. Specifies any [route key](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html). Applicable for HTTP APIs.
     * 
     */
    @Import(name="routeKey")
    private @Nullable Output<String> routeKey;

    /**
     * @return Part of _quick create_. Specifies any [route key](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html). Applicable for HTTP APIs.
     * 
     */
    public Optional<Output<String>> routeKey() {
        return Optional.ofNullable(this.routeKey);
    }

    /**
     * The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
     * Defaults to `$request.method $request.path`.
     * 
     */
    @Import(name="routeSelectionExpression")
    private @Nullable Output<String> routeSelectionExpression;

    /**
     * @return The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
     * Defaults to `$request.method $request.path`.
     * 
     */
    public Optional<Output<String>> routeSelectionExpression() {
        return Optional.ofNullable(this.routeSelectionExpression);
    }

    /**
     * Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * Part of _quick create_. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes.
     * For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN.
     * The type of the integration will be `HTTP_PROXY` or `AWS_PROXY`, respectively. Applicable for HTTP APIs.
     * 
     */
    @Import(name="target")
    private @Nullable Output<String> target;

    /**
     * @return Part of _quick create_. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes.
     * For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN.
     * The type of the integration will be `HTTP_PROXY` or `AWS_PROXY`, respectively. Applicable for HTTP APIs.
     * 
     */
    public Optional<Output<String>> target() {
        return Optional.ofNullable(this.target);
    }

    /**
     * Version identifier for the API. Must be between 1 and 64 characters in length.
     * 
     */
    @Import(name="version")
    private @Nullable Output<String> version;

    /**
     * @return Version identifier for the API. Must be between 1 and 64 characters in length.
     * 
     */
    public Optional<Output<String>> version() {
        return Optional.ofNullable(this.version);
    }

    private ApiState() {}

    private ApiState(ApiState $) {
        this.apiEndpoint = $.apiEndpoint;
        this.apiKeySelectionExpression = $.apiKeySelectionExpression;
        this.arn = $.arn;
        this.body = $.body;
        this.corsConfiguration = $.corsConfiguration;
        this.credentialsArn = $.credentialsArn;
        this.description = $.description;
        this.disableExecuteApiEndpoint = $.disableExecuteApiEndpoint;
        this.executionArn = $.executionArn;
        this.failOnWarnings = $.failOnWarnings;
        this.name = $.name;
        this.protocolType = $.protocolType;
        this.routeKey = $.routeKey;
        this.routeSelectionExpression = $.routeSelectionExpression;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.target = $.target;
        this.version = $.version;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ApiState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ApiState $;

        public Builder() {
            $ = new ApiState();
        }

        public Builder(ApiState defaults) {
            $ = new ApiState(Objects.requireNonNull(defaults));
        }

        /**
         * @param apiEndpoint URI of the API, of the form `https://{api-id}.execute-api.{region}.amazonaws.com` for HTTP APIs and `wss://{api-id}.execute-api.{region}.amazonaws.com` for WebSocket APIs.
         * 
         * @return builder
         * 
         */
        public Builder apiEndpoint(@Nullable Output<String> apiEndpoint) {
            $.apiEndpoint = apiEndpoint;
            return this;
        }

        /**
         * @param apiEndpoint URI of the API, of the form `https://{api-id}.execute-api.{region}.amazonaws.com` for HTTP APIs and `wss://{api-id}.execute-api.{region}.amazonaws.com` for WebSocket APIs.
         * 
         * @return builder
         * 
         */
        public Builder apiEndpoint(String apiEndpoint) {
            return apiEndpoint(Output.of(apiEndpoint));
        }

        /**
         * @param apiKeySelectionExpression An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
         * Valid values: `$context.authorizer.usageIdentifierKey`, `$request.header.x-api-key`. Defaults to `$request.header.x-api-key`.
         * Applicable for WebSocket APIs.
         * 
         * @return builder
         * 
         */
        public Builder apiKeySelectionExpression(@Nullable Output<String> apiKeySelectionExpression) {
            $.apiKeySelectionExpression = apiKeySelectionExpression;
            return this;
        }

        /**
         * @param apiKeySelectionExpression An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
         * Valid values: `$context.authorizer.usageIdentifierKey`, `$request.header.x-api-key`. Defaults to `$request.header.x-api-key`.
         * Applicable for WebSocket APIs.
         * 
         * @return builder
         * 
         */
        public Builder apiKeySelectionExpression(String apiKeySelectionExpression) {
            return apiKeySelectionExpression(Output.of(apiKeySelectionExpression));
        }

        /**
         * @param arn ARN of the API.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn ARN of the API.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param body An OpenAPI specification that defines the set of routes and integrations to create as part of the HTTP APIs. Supported only for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder body(@Nullable Output<String> body) {
            $.body = body;
            return this;
        }

        /**
         * @param body An OpenAPI specification that defines the set of routes and integrations to create as part of the HTTP APIs. Supported only for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder body(String body) {
            return body(Output.of(body));
        }

        /**
         * @param corsConfiguration Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder corsConfiguration(@Nullable Output<ApiCorsConfigurationArgs> corsConfiguration) {
            $.corsConfiguration = corsConfiguration;
            return this;
        }

        /**
         * @param corsConfiguration Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder corsConfiguration(ApiCorsConfigurationArgs corsConfiguration) {
            return corsConfiguration(Output.of(corsConfiguration));
        }

        /**
         * @param credentialsArn Part of _quick create_. Specifies any credentials required for the integration. Applicable for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder credentialsArn(@Nullable Output<String> credentialsArn) {
            $.credentialsArn = credentialsArn;
            return this;
        }

        /**
         * @param credentialsArn Part of _quick create_. Specifies any credentials required for the integration. Applicable for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder credentialsArn(String credentialsArn) {
            return credentialsArn(Output.of(credentialsArn));
        }

        /**
         * @param description Description of the API. Must be less than or equal to 1024 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Description of the API. Must be less than or equal to 1024 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param disableExecuteApiEndpoint Whether clients can invoke the API by using the default `execute-api` endpoint.
         * By default, clients can invoke the API with the default `{api_id}.execute-api.{region}.amazonaws.com endpoint`.
         * To require that clients use a custom domain name to invoke the API, disable the default endpoint.
         * 
         * @return builder
         * 
         */
        public Builder disableExecuteApiEndpoint(@Nullable Output<Boolean> disableExecuteApiEndpoint) {
            $.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        /**
         * @param disableExecuteApiEndpoint Whether clients can invoke the API by using the default `execute-api` endpoint.
         * By default, clients can invoke the API with the default `{api_id}.execute-api.{region}.amazonaws.com endpoint`.
         * To require that clients use a custom domain name to invoke the API, disable the default endpoint.
         * 
         * @return builder
         * 
         */
        public Builder disableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            return disableExecuteApiEndpoint(Output.of(disableExecuteApiEndpoint));
        }

        /**
         * @param executionArn ARN prefix to be used in an `aws.lambda.Permission`&#39;s `source_arn` attribute
         * or in an `aws.iam.Policy` to authorize access to the [`@connections` API](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html).
         * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-control-access-iam.html) for details.
         * 
         * @return builder
         * 
         */
        public Builder executionArn(@Nullable Output<String> executionArn) {
            $.executionArn = executionArn;
            return this;
        }

        /**
         * @param executionArn ARN prefix to be used in an `aws.lambda.Permission`&#39;s `source_arn` attribute
         * or in an `aws.iam.Policy` to authorize access to the [`@connections` API](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html).
         * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-control-access-iam.html) for details.
         * 
         * @return builder
         * 
         */
        public Builder executionArn(String executionArn) {
            return executionArn(Output.of(executionArn));
        }

        /**
         * @param failOnWarnings Whether warnings should return an error while API Gateway is creating or updating the resource using an OpenAPI specification. Defaults to `false`. Applicable for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder failOnWarnings(@Nullable Output<Boolean> failOnWarnings) {
            $.failOnWarnings = failOnWarnings;
            return this;
        }

        /**
         * @param failOnWarnings Whether warnings should return an error while API Gateway is creating or updating the resource using an OpenAPI specification. Defaults to `false`. Applicable for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder failOnWarnings(Boolean failOnWarnings) {
            return failOnWarnings(Output.of(failOnWarnings));
        }

        /**
         * @param name Name of the API. Must be less than or equal to 128 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name of the API. Must be less than or equal to 128 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param protocolType API protocol. Valid values: `HTTP`, `WEBSOCKET`.
         * 
         * @return builder
         * 
         */
        public Builder protocolType(@Nullable Output<String> protocolType) {
            $.protocolType = protocolType;
            return this;
        }

        /**
         * @param protocolType API protocol. Valid values: `HTTP`, `WEBSOCKET`.
         * 
         * @return builder
         * 
         */
        public Builder protocolType(String protocolType) {
            return protocolType(Output.of(protocolType));
        }

        /**
         * @param routeKey Part of _quick create_. Specifies any [route key](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html). Applicable for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder routeKey(@Nullable Output<String> routeKey) {
            $.routeKey = routeKey;
            return this;
        }

        /**
         * @param routeKey Part of _quick create_. Specifies any [route key](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html). Applicable for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder routeKey(String routeKey) {
            return routeKey(Output.of(routeKey));
        }

        /**
         * @param routeSelectionExpression The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
         * Defaults to `$request.method $request.path`.
         * 
         * @return builder
         * 
         */
        public Builder routeSelectionExpression(@Nullable Output<String> routeSelectionExpression) {
            $.routeSelectionExpression = routeSelectionExpression;
            return this;
        }

        /**
         * @param routeSelectionExpression The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
         * Defaults to `$request.method $request.path`.
         * 
         * @return builder
         * 
         */
        public Builder routeSelectionExpression(String routeSelectionExpression) {
            return routeSelectionExpression(Output.of(routeSelectionExpression));
        }

        /**
         * @param tags Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param target Part of _quick create_. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes.
         * For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN.
         * The type of the integration will be `HTTP_PROXY` or `AWS_PROXY`, respectively. Applicable for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder target(@Nullable Output<String> target) {
            $.target = target;
            return this;
        }

        /**
         * @param target Part of _quick create_. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes.
         * For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN.
         * The type of the integration will be `HTTP_PROXY` or `AWS_PROXY`, respectively. Applicable for HTTP APIs.
         * 
         * @return builder
         * 
         */
        public Builder target(String target) {
            return target(Output.of(target));
        }

        /**
         * @param version Version identifier for the API. Must be between 1 and 64 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder version(@Nullable Output<String> version) {
            $.version = version;
            return this;
        }

        /**
         * @param version Version identifier for the API. Must be between 1 and 64 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder version(String version) {
            return version(Output.of(version));
        }

        public ApiState build() {
            return $;
        }
    }

}
